/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.ingredients.type.IngredientTierFormatting;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.models.items.items.game.DungeonKeyItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.models.items.items.game.RuneItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.wynn.ColorScaleUtils;
import com.wynnventory.api.WynnventoryAPI;
import com.wynnventory.core.ModInfo;
import com.wynnventory.model.item.trademarket.TradeMarketItemPriceHolder;
import com.wynnventory.model.item.trademarket.TradeMarketItemPriceInfo;
import com.wynnventory.util.PriceTooltipHelper;
import com.wynnventory.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5251;

public class ItemStackUtils {
    private static final String TITLE_TEXT = "Trade Market Price Info";
    private static final long EXPIRE_MINS = 2L;
    private static final TradeMarketItemPriceInfo FETCHING = new TradeMarketItemPriceInfo();
    private static final TradeMarketItemPriceInfo UNTRADABLE = new TradeMarketItemPriceInfo();
    private static final Map<String, PriceHolderPair> priceCache = new HashMap<String, PriceHolderPair>();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private static final WynnventoryAPI wynnventoryAPI = new WynnventoryAPI();
    private static final NavigableMap<Float, class_5251> COLOR_MAP = new TreeMap<Float, class_5251>(Map.of(Float.valueOf(0.0f), class_5251.method_27718((class_124)class_124.field_1061), Float.valueOf(40.0f), class_5251.method_27718((class_124)class_124.field_1065), Float.valueOf(70.0f), class_5251.method_27718((class_124)class_124.field_1054), Float.valueOf(90.0f), class_5251.method_27718((class_124)class_124.field_1060), Float.valueOf(100.0f), class_5251.method_27718((class_124)class_124.field_1075)));

    public static StyledText getWynntilsOriginalName(class_1799 itemStack) {
        try {
            Field originalNameField = class_1799.class.getDeclaredField("wynntilsOriginalName");
            originalNameField.setAccessible(true);
            return (StyledText)originalNameField.get(itemStack);
        }
        catch (ReflectiveOperationException e) {
            ModInfo.logError("Error retrieving original name", e);
            return null;
        }
    }

    public static String getWynntilsOriginalNameAsString(WynnItem item) {
        return Objects.requireNonNull(ItemStackUtils.getWynntilsOriginalName((class_1799)item.getData().get("itemstack"))).getLastPart().getComponent().getString();
    }

    public static List<class_2561> getTooltips(class_1799 itemStack) {
        Optional maybeItem = Models.Item.getWynnItem(itemStack);
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        if (maybeItem.isEmpty()) {
            return tooltipLines;
        }
        WynnItem wynnItem = (WynnItem)maybeItem.get();
        Objects.requireNonNull(wynnItem);
        WynnItem wynnItem2 = wynnItem;
        int n = 0;
        block14: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GearItem.class, GearBoxItem.class, IngredientItem.class, MaterialItem.class, PowderItem.class, AmplifierItem.class, HorseItem.class, EmeraldPouchItem.class, InsulatorItem.class, SimulatorItem.class, RuneItem.class, DungeonKeyItem.class}, (Object)wynnItem2, n)) {
                case 0: {
                    GearItem gearItem = (GearItem)wynnItem2;
                    ItemStackUtils.processSimple(gearItem.getName(), gearItem.getGearTier().getChatFormatting(), tooltipLines, gearItem.getItemInfo().metaInfo().restrictions() == GearRestrictions.UNTRADABLE);
                    break block14;
                }
                case 1: {
                    GearBoxItem gearBoxItem = (GearBoxItem)wynnItem2;
                    if (gearBoxItem.getGearType().equals((Object)GearType.MASTERY_TOME)) {
                        n = 2;
                        continue block14;
                    }
                    ItemStackUtils.processGearBox(gearBoxItem, tooltipLines);
                    break block14;
                }
                case 2: {
                    IngredientItem ingredientItem = (IngredientItem)wynnItem2;
                    ItemStackUtils.processCrafting(ingredientItem.getName(), ingredientItem.getQualityTier(), class_124.field_1080, tooltipLines);
                    break block14;
                }
                case 3: {
                    MaterialItem materialItem = (MaterialItem)wynnItem2;
                    ItemStackUtils.processCrafting(ItemStackUtils.getMaterialName(materialItem), materialItem.getQualityTier(), class_124.field_1068, tooltipLines);
                    break block14;
                }
                case 4: {
                    PowderItem powderItem = (PowderItem)wynnItem2;
                    ItemStackUtils.processTiered(ItemStackUtils.getPowderName(powderItem), powderItem.getTier(), powderItem.getPowderProfile().element().getLightColor(), tooltipLines);
                    break block14;
                }
                case 5: {
                    AmplifierItem amplifierItem = (AmplifierItem)wynnItem2;
                    ItemStackUtils.processTiered(ItemStackUtils.getAmplifierName(amplifierItem), amplifierItem.getTier(), amplifierItem.getGearTier().getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 6: {
                    HorseItem horseItem = (HorseItem)wynnItem2;
                    ItemStackUtils.processTiered(ItemStackUtils.getHorseName(horseItem), horseItem.getTier().getNumeral(), GearTier.NORMAL.getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 7: {
                    EmeraldPouchItem emeraldPouchItem = (EmeraldPouchItem)wynnItem2;
                    ItemStackUtils.processTiered(emeraldPouchItem.getName(), emeraldPouchItem.getName() + " " + emeraldPouchItem.getTier(), emeraldPouchItem.getTier(), GearTier.NORMAL.getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 8: {
                    InsulatorItem insulatorItem = (InsulatorItem)wynnItem2;
                    ItemStackUtils.processSimple(ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)insulatorItem), insulatorItem.getGearTier().getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 9: {
                    SimulatorItem simulatorItem = (SimulatorItem)wynnItem2;
                    ItemStackUtils.processSimple(ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)simulatorItem), simulatorItem.getGearTier().getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 10: {
                    RuneItem runeItem = (RuneItem)wynnItem2;
                    ItemStackUtils.processSimple(ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)runeItem), GearTier.NORMAL.getChatFormatting(), tooltipLines);
                    break block14;
                }
                case 11: {
                    DungeonKeyItem dungeonKeyItem = (DungeonKeyItem)wynnItem2;
                    ItemStackUtils.processSimple(ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)dungeonKeyItem), GearTier.NORMAL.getChatFormatting(), tooltipLines);
                    break block14;
                }
                default: {
                    return tooltipLines;
                }
            }
            break;
        }
        return tooltipLines;
    }

    private static void processSimple(String itemName, class_124 color, List<class_2561> tooltipLines) {
        ItemStackUtils.processSimple(itemName, color, tooltipLines, false);
    }

    private static void processSimple(String itemName, class_124 color, List<class_2561> tooltipLines, boolean untradable) {
        tooltipLines.addFirst((class_2561)class_2561.method_43470((String)TITLE_TEXT).method_27692(class_124.field_1065));
        ItemStackUtils.fetchPrices(itemName, () -> wynnventoryAPI.fetchItemPrice(itemName), () -> untradable ? UNTRADABLE : wynnventoryAPI.fetchLatestHistoricItemPrice(itemName));
        tooltipLines.addAll(ItemStackUtils.createTooltip(itemName, color, untradable));
        ItemStackUtils.removeExpiredPrices(itemName);
    }

    private static void processGearBox(GearBoxItem gearBoxItem, List<class_2561> tooltipLines) {
        tooltipLines.addFirst((class_2561)class_2561.method_43470((String)TITLE_TEXT).method_27692(class_124.field_1065));
        List possibleGears = Models.Gear.getPossibleGears(gearBoxItem);
        if (possibleGears.isEmpty()) {
            return;
        }
        class_124 color = ((GearInfo)possibleGears.getFirst()).tier().getChatFormatting();
        ArrayList<TradeMarketItemPriceHolder> priceHolders = new ArrayList<TradeMarketItemPriceHolder>();
        for (GearInfo gearInfo : possibleGears) {
            String gearName = gearInfo.name();
            ItemStackUtils.fetchPrices(gearName, () -> wynnventoryAPI.fetchItemPrice(gearName), () -> wynnventoryAPI.fetchLatestHistoricItemPrice(gearName));
            PriceHolderPair pair = priceCache.get(gearName);
            priceHolders.add(pair.currentHolder);
        }
        PriceTooltipHelper.sortTradeMarketPriceHolders(priceHolders);
        for (TradeMarketItemPriceHolder holder : priceHolders) {
            String itemKey = holder.getItemName();
            tooltipLines.addAll(ItemStackUtils.createTooltip(itemKey, color, false));
            tooltipLines.add((class_2561)class_2561.method_43470((String)""));
            ItemStackUtils.removeExpiredPrices(itemKey);
        }
    }

    private static void processCrafting(String displayName, int tier, class_124 color, List<class_2561> tooltipLines) {
        tooltipLines.addFirst((class_2561)class_2561.method_43470((String)TITLE_TEXT).method_27692(class_124.field_1065));
        String itemKey = displayName + "_" + tier;
        ItemStackUtils.fetchPrices(itemKey, () -> wynnventoryAPI.fetchItemPrice(displayName, tier), () -> wynnventoryAPI.fetchLatestHistoricItemPrice(displayName, tier));
        Object name = displayName;
        if (tier > 0) {
            name = displayName + " " + IngredientTierFormatting.fromTierNum((int)tier).getTierString();
        }
        tooltipLines.addAll(ItemStackUtils.createTooltip((String)name, itemKey, color, false));
        ItemStackUtils.removeExpiredPrices(itemKey);
    }

    private static void processTiered(String displayName, int tier, class_124 color, List<class_2561> tooltipLines) {
        ItemStackUtils.processTiered(displayName + " " + MathUtils.toRoman((int)tier), displayName + " " + tier, tier, color, tooltipLines);
    }

    private static void processTiered(String displayName, String key, int tier, class_124 color, List<class_2561> tooltipLines) {
        tooltipLines.addFirst((class_2561)class_2561.method_43470((String)TITLE_TEXT).method_27692(class_124.field_1065));
        ItemStackUtils.fetchPrices(key, () -> wynnventoryAPI.fetchItemPrice(displayName, tier), () -> wynnventoryAPI.fetchLatestHistoricItemPrice(displayName, tier));
        tooltipLines.addAll(ItemStackUtils.createTooltip(displayName, key, color, false));
        ItemStackUtils.removeExpiredPrices(key);
    }

    private static void fetchPrices(String itemKey, Supplier<TradeMarketItemPriceInfo> currentPriceSupplier, Supplier<TradeMarketItemPriceInfo> historicPriceSupplier) {
        priceCache.computeIfAbsent(itemKey, key -> {
            TradeMarketItemPriceHolder currentHolder = new TradeMarketItemPriceHolder(FETCHING, (String)key);
            TradeMarketItemPriceHolder historicHolder = new TradeMarketItemPriceHolder(FETCHING, (String)key);
            CompletableFuture.supplyAsync(currentPriceSupplier, executorService).thenAccept(currentHolder::setPriceInfo);
            CompletableFuture.supplyAsync(historicPriceSupplier, executorService).thenAccept(historicHolder::setPriceInfo);
            return new PriceHolderPair((String)key, currentHolder, historicHolder);
        });
    }

    private static List<class_2561> createTooltip(String itemKey, class_124 color, boolean untradable) {
        return ItemStackUtils.createTooltip(itemKey, itemKey, color, untradable);
    }

    private static List<class_2561> createTooltip(String displayName, String itemKey, class_124 color, boolean untradable) {
        PriceHolderPair holders = priceCache.get(itemKey);
        TradeMarketItemPriceInfo currentInfo = holders.currentHolder.getPriceInfo();
        if (untradable || currentInfo == UNTRADABLE) {
            return Collections.singletonList(class_2561.method_43470((String)"Item is untradable.").method_27692(class_124.field_1061));
        }
        if (currentInfo == FETCHING) {
            return Collections.singletonList(class_2561.method_43470((String)"Retrieving price information...").method_27692(class_124.field_1068));
        }
        TradeMarketItemPriceInfo historicInfo = holders.historicHolder.getPriceInfo();
        return PriceTooltipHelper.createPriceTooltip(currentInfo, historicInfo, displayName, color);
    }

    private static void removeExpiredPrices(String itemKey) {
        PriceHolderPair holders = priceCache.get(itemKey);
        if (holders.currentHolder.isPriceExpired(2L)) {
            priceCache.remove(itemKey);
        }
    }

    public static class_124 getRarityColor(String rarity) {
        return Optional.ofNullable(GearTier.fromString((String)rarity)).map(GearTier::getChatFormatting).orElse(class_124.field_1068);
    }

    public static String getMaterialName(MaterialItem item) {
        String source = item.getMaterialProfile().getSourceMaterial().name();
        String resource = item.getMaterialProfile().getResourceType().name();
        return StringUtils.toCamelCase(source + " " + resource, " ");
    }

    public static String getPowderName(PowderItem item) {
        return item.getPowderProfile().element().getName() + " Powder";
    }

    public static String getPowderType(PowderItem item) {
        return StringUtils.toCamelCase(ItemStackUtils.getPowderName(item));
    }

    public static String getAmplifierName(AmplifierItem item) {
        String name = ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)item);
        String[] nameParts = name.split(" ");
        if (nameParts.length > 1) {
            return nameParts[0] + " " + nameParts[1];
        }
        return name;
    }

    public static String getAmplifierType(AmplifierItem item) {
        return StringUtils.toCamelCase(ItemStackUtils.getAmplifierName(item));
    }

    public static String getHorseName(HorseItem item) {
        return item.getName().orElse(ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)item));
    }

    public static String getRollPercentColor(Float rollPercent) {
        try {
            int colorValue = ColorScaleUtils.getPercentageTextComponent(COLOR_MAP, (float)rollPercent.floatValue(), (boolean)true, (int)1).method_10866().method_10973().method_27716();
            return String.format("#%06X", 0xFFFFFF & colorValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    private record PriceHolderPair(String itemKey, TradeMarketItemPriceHolder currentHolder, TradeMarketItemPriceHolder historicHolder) {
    }
}

