/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynnventory.core.ModInfo;
import com.wynnventory.model.github.Asset;
import com.wynnventory.model.github.Release;
import com.wynnventory.util.HttpUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ModUpdater {
    private static final String LATEST_RELEASE_URL = "https://api.github.com/repos/Wynnventory/Wynnventory_Mod/releases/latest";
    private static boolean alreadyChecked = false;

    private ModUpdater() {
    }

    public static void checkForUpdates() {
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        if (ModInfo.INSTANCE.isEmpty()) {
            ModInfo.logError("Could not find Wynnventory in Fabric Loader!");
            return;
        }
        if (ModInfo.isDev()) {
            ModInfo.logInfo("This is a dev build. Skipping auto update...");
        } else {
            String currentVersion = ModInfo.VERSION;
            ModUpdater.initiateUpdateCheck(currentVersion);
        }
    }

    private static void initiateUpdateCheck(String currentVersion) {
        new Thread(() -> {
            try {
                Release latestRelease = ModUpdater.fetchLatestRelease();
                String latestVersion = ModUpdater.sanitizeVersion(latestRelease.getTagName());
                if (!ModUpdater.isUpToDate(currentVersion, latestVersion)) {
                    ModUpdater.handleNewVersionFound(latestRelease, latestVersion);
                }
            }
            catch (Exception e) {
                ModInfo.logError("Failed to check for updates.", e);
            }
        }).start();
    }

    private static Release fetchLatestRelease() throws Exception {
        URI uri = new URI(LATEST_RELEASE_URL);
        HttpResponse<String> response = HttpUtil.sendHttpGetRequest(uri);
        return new ObjectMapper().readValue(response.body(), Release.class);
    }

    private static String sanitizeVersion(String versionTag) {
        return versionTag.toLowerCase().replace("v", "");
    }

    private static boolean isUpToDate(String currentVersion, String latestVersion) {
        return currentVersion.equals(latestVersion);
    }

    private static void handleNewVersionFound(Release latestRelease, String latestVersion) {
        ModUpdater.notifyUserOfUpdate(latestVersion);
        String modName = ModInfo.NAME;
        latestRelease.getAssets().stream().filter(asset -> asset.getName().startsWith(modName) && asset.getName().endsWith(".jar")).forEach(ModUpdater::downloadAndApplyUpdate);
    }

    private static void notifyUserOfUpdate(String latestVersion) {
        class_5250 message = class_2561.method_43470((String)("[Wynnventory] New version available: " + latestVersion + ". Attempting to auto-update...")).method_27696(class_2583.field_24360.method_10977(class_124.field_1054));
        McUtils.sendMessageToClient((class_2561)message);
    }

    private static void downloadAndApplyUpdate(Asset asset) {
        new Thread(() -> {
            try {
                Path newFilePath = ModUpdater.downloadAsset(asset);
                ModUpdater.notifyUserOfDownloadCompletion();
                File oldFile = ModUpdater.getExistingModFile();
                ModUpdater.scheduleFileReplacementOnShutdown(oldFile, newFilePath.toFile());
            }
            catch (Exception e) {
                ModInfo.logError("Failed to download Wynnventory update", e);
            }
        }).start();
    }

    private static Path downloadAsset(Asset asset) throws Exception {
        URI uri = new URI(asset.getBrowserDownloadUrl());
        Path newFilePath = ModUpdater.getModFilePath(asset.getName());
        Files.copy(uri.toURL().openStream(), newFilePath, StandardCopyOption.REPLACE_EXISTING);
        return newFilePath;
    }

    private static Path getModFilePath(String fileName) {
        return new File(class_310.method_1551().field_1697, "mods/" + fileName).toPath();
    }

    private static void notifyUserOfDownloadCompletion() {
        class_5250 message = class_2561.method_43470((String)"[Wynnventory] Download completed! Restart Minecraft to apply the update.").method_27696(class_2583.field_24360.method_10977(class_124.field_1060));
        McUtils.sendMessageToClient((class_2561)message);
    }

    private static File getExistingModFile() {
        return new File(((Path)ModInfo.INSTANCE.get().getOrigin().getPaths().getFirst()).toUri());
    }

    private static void scheduleFileReplacementOnShutdown(File oldJar, File newJar) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ModUpdater.replaceOldFileWithNew(oldJar, newJar);
            }
            catch (IOException e) {
                ModInfo.logError("Cannot apply update!", e);
            }
        }));
    }

    private static void replaceOldFileWithNew(File oldJar, File newJar) throws IOException {
        if (!ModUpdater.isValidJarFile(oldJar)) {
            ModInfo.logWarn("Mod jar file not found or incorrect.");
            return;
        }
        FileUtils.copyFile((File)newJar, (File)oldJar);
        if (newJar.delete()) {
            ModInfo.logInfo("Successfully applied update!");
        } else {
            ModInfo.logWarn("Failed to delete the new JAR file after copying.");
        }
    }

    private static boolean isValidJarFile(File jarFile) {
        return jarFile != null && jarFile.exists() && !jarFile.isDirectory();
    }
}

