/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.utils.mc.McUtils;
import com.wynnventory.config.ConfigManager;
import com.wynnventory.config.EmeraldDisplayOption;
import com.wynnventory.model.item.trademarket.TradeMarketItemPriceHolder;
import com.wynnventory.model.item.trademarket.TradeMarketItemPriceInfo;
import com.wynnventory.util.EmeraldPrice;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Unique;

public class PriceTooltipHelper {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final EmeraldPrice EMERALD_PRICE = new EmeraldPrice();

    private PriceTooltipHelper() {
    }

    public static Dimension calculateTooltipDimension(List<class_2561> tooltipLines, class_327 font) {
        int width = tooltipLines.stream().mapToInt(arg_0 -> ((class_327)font).method_27525(arg_0)).max().orElse(0);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int height = n * 9;
        return new Dimension(width, height);
    }

    public static float calculateScaleFactor(List<class_2561> tooltipLines, int maxHeight, int maxWidth, float minScale, float maxScale, class_327 font) {
        Dimension dim = PriceTooltipHelper.calculateTooltipDimension(tooltipLines, font);
        float heightScale = (float)maxHeight / (float)dim.height;
        float scaleFactor = Math.clamp(heightScale, minScale, maxScale);
        int scaledWidth = Math.round((float)dim.width * scaleFactor);
        if (scaledWidth > maxWidth) {
            float widthScale = (float)maxWidth / (float)dim.width;
            scaleFactor = Math.clamp(widthScale, minScale, maxScale);
        }
        return scaleFactor;
    }

    public static List<class_2561> createPriceTooltip(TradeMarketItemPriceInfo priceInfo, TradeMarketItemPriceInfo historicInfo, String itemName, class_124 color) {
        ConfigManager config = ConfigManager.getInstance();
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        tooltipLines.add((class_2561)PriceTooltipHelper.formatText(itemName, color));
        if (priceInfo == null || priceInfo.isEmpty()) {
            tooltipLines.add((class_2561)PriceTooltipHelper.formatText("No price data available yet!", class_124.field_1061));
        } else {
            PriceTooltipHelper.addPriceLine(tooltipLines, "Max: ", priceInfo.getHighestPrice(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getHighestPrice());
            PriceTooltipHelper.addPriceLine(tooltipLines, "Min: ", priceInfo.getLowestPrice(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getLowestPrice());
            PriceTooltipHelper.addPriceLine(tooltipLines, "Avg: ", priceInfo.getAveragePrice(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getAveragePrice());
            PriceTooltipHelper.addPriceLine(tooltipLines, "Avg 80%: ", priceInfo.getAverage80Price(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getAverage80Price());
            PriceTooltipHelper.addPriceLine(tooltipLines, "Unidentified Avg: ", priceInfo.getUnidentifiedAveragePrice(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getUnidentifiedAveragePrice());
            PriceTooltipHelper.addPriceLine(tooltipLines, "Unidentified Avg 80%: ", priceInfo.getUnidentifiedAverage80Price(), config.isShowPriceFluctuation(), historicInfo.isEmpty() ? 0 : historicInfo.getUnidentifiedAverage80Price());
        }
        return tooltipLines;
    }

    public static void addPriceLine(List<class_2561> tooltipLines, String label, int price, boolean showFluct, int historicPrice) {
        boolean shouldShow = PriceTooltipHelper.isShouldShow(label);
        if (price > 0 && shouldShow) {
            if (showFluct) {
                float fluctuation = PriceTooltipHelper.calcPriceDiff(price, historicPrice);
                tooltipLines.add((class_2561)PriceTooltipHelper.formatPriceWithFluctuation(label, price, fluctuation));
            } else {
                tooltipLines.add((class_2561)PriceTooltipHelper.formatPrice(label, price));
            }
        }
    }

    private static boolean isShouldShow(String label) {
        ConfigManager config = ConfigManager.getInstance();
        return switch (label) {
            case "Max: " -> config.isShowMaxPrice();
            case "Min: " -> config.isShowMinPrice();
            case "Avg: " -> config.isShowAveragePrice();
            case "Avg 80%: " -> config.isShowAverage80Price();
            case "Unidentified Avg: " -> config.isShowUnidAveragePrice();
            case "Unidentified Avg 80%: " -> config.isShowUnidAverage80Price();
            default -> false;
        };
    }

    public static class_5250 formatPrice(String label, int price) {
        int color;
        ConfigManager config = ConfigManager.getInstance();
        EmeraldDisplayOption priceFormat = config.getPriceFormat();
        class_5250 priceComponent = class_2561.method_43470((String)label).method_27696(class_2583.field_24360.method_10977(class_124.field_1068));
        int n = color = config.getColorSettings().isShowColors() && price >= config.getColorSettings().getColorMinPrice() ? config.getColorSettings().getHighlightColor() : class_124.field_1080.method_532().intValue();
        if (price > 0) {
            String formattedPrice = NUMBER_FORMAT.format(price) + EmeraldUnits.EMERALD.getSymbol();
            String formattedEmeralds = EMERALD_PRICE.getFormattedString(price, false);
            switch (priceFormat) {
                case EMERALDS: {
                    priceComponent.method_10852((class_2561)class_2561.method_43470((String)formattedPrice).method_27696(class_2583.field_24360.method_36139(color)));
                    break;
                }
                case FORMATTED: {
                    priceComponent.method_10852((class_2561)class_2561.method_43470((String)formattedEmeralds).method_27696(class_2583.field_24360.method_36139(color)));
                    break;
                }
                default: {
                    priceComponent.method_10852((class_2561)class_2561.method_43470((String)formattedPrice).method_27696(class_2583.field_24360.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)(" (" + formattedEmeralds + ")")).method_27696(class_2583.field_24360.method_36139(color)));
                }
            }
        }
        return priceComponent;
    }

    public static class_5250 formatPriceWithFluctuation(String label, int price, float fluctuation) {
        return price > 0 ? PriceTooltipHelper.formatPrice(label, price).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)PriceTooltipHelper.formatPriceFluctuation(fluctuation)) : class_2561.method_43470((String)"");
    }

    public static class_5250 formatText(String text, class_124 color) {
        return class_2561.method_43470((String)text).method_27696(class_2583.field_24360.method_10977(color));
    }

    public static class_5250 formatPriceFluctuation(float fluctuation) {
        class_2583 style = fluctuation < 0.0f ? class_2583.field_24360.method_10977(class_124.field_1061) : (fluctuation > 0.0f ? class_2583.field_24360.method_10977(class_124.field_1060) : class_2583.field_24360.method_10977(class_124.field_1080));
        String formattedValue = fluctuation < 0.0f ? String.format("%.1f", Float.valueOf(fluctuation)) + "%" : "+" + String.format("%.1f", Float.valueOf(fluctuation)) + "%";
        return class_2561.method_43470((String)formattedValue).method_27696(style);
    }

    public static float calcPriceDiff(float newPrice, float oldPrice) {
        return oldPrice == 0.0f ? 0.0f : (newPrice - oldPrice) / oldPrice * 100.0f;
    }

    public static void sortTradeMarketPriceHolders(List<TradeMarketItemPriceHolder> holders) {
        holders.sort((h1, h2) -> {
            int group2;
            TradeMarketItemPriceInfo p1 = h1.getPriceInfo();
            TradeMarketItemPriceInfo p2 = h2.getPriceInfo();
            int group1 = PriceTooltipHelper.getPriceGroup(p1);
            int groupComparison = Integer.compare(group1, group2 = PriceTooltipHelper.getPriceGroup(p2));
            if (groupComparison != 0) {
                return groupComparison;
            }
            return switch (group1) {
                case 0 -> Double.compare(p2.getUnidentifiedAverage80Price(), p1.getUnidentifiedAverage80Price());
                case 1 -> Double.compare(p2.getAverage80Price(), p1.getAverage80Price());
                default -> 0;
            };
        });
    }

    private static int getPriceGroup(TradeMarketItemPriceInfo priceInfo) {
        if (priceInfo == null) {
            return 2;
        }
        return priceInfo.getUnidentifiedAverage80Price() != 0 ? 0 : 1;
    }

    @Unique
    public static void renderPriceInfoTooltip(class_332 guiGraphics, int mouseX, int mouseY, class_1799 item, List<class_2561> tooltipLines, boolean anchored) {
        float posY;
        float posX;
        int spaceR;
        int spaceL;
        class_327 font = McUtils.mc().field_1772;
        class_1041 window = McUtils.window();
        mouseX = Math.min(mouseX, guiGraphics.method_51421() - 10);
        mouseY = Math.max(mouseY, 10);
        int guiwWindow = window.method_4486();
        int guiwGraphics = guiGraphics.method_51421();
        int guiH = window.method_4502();
        int guiScale = (int)window.method_4495();
        int gap = 5 * guiScale;
        List primary = class_437.method_25408((class_310)McUtils.mc(), (class_1799)item);
        Dimension pDim = PriceTooltipHelper.calculateTooltipDimension(primary, font);
        boolean gearBox = false;
        if (!primary.isEmpty()) {
            String title = ((class_2561)primary.getFirst()).getString();
            if (title.startsWith("Unidentified ")) {
                String suf = title.substring("Unidentified ".length()).trim();
                for (GearType g : GearType.values()) {
                    if (!g.name().equalsIgnoreCase(suf)) continue;
                    gearBox = true;
                    break;
                }
            }
            if (gearBox) {
                pDim.width += 35 * guiScale;
                pDim.height += 35 * guiScale;
            }
        }
        boolean placeLeft = (spaceL = mouseX - gap) >= (spaceR = guiwWindow - (mouseX + pDim.width + gap));
        int availableWidth = Math.max(placeLeft ? spaceL : spaceR, 0);
        int tooltipMaxH = Math.round((float)guiH * 0.8f);
        float scale = PriceTooltipHelper.calculateScaleFactor(tooltipLines, tooltipMaxH, availableWidth, 0.4f, 1.0f, font);
        Dimension tDim = PriceTooltipHelper.calculateTooltipDimension(tooltipLines, font);
        Dimension sDim = new Dimension(Math.round((float)tDim.width * scale), Math.round((float)tDim.height * scale));
        if (!anchored) {
            posX = placeLeft ? (float)(mouseX - gap - sDim.width) : (float)(mouseX + pDim.width);
            posY = mouseY + sDim.height > guiH ? (float)(guiH - sDim.height - gap) : (float)mouseY;
        } else {
            posX = placeLeft ? 0.0f : (float)(guiwWindow - sDim.width);
            posY = (float)(guiH - sDim.height) / 2.0f;
        }
        int maxX = guiwGraphics - sDim.width - gap;
        int maxY = guiH - sDim.height - gap;
        posX = !anchored ? Math.min(Math.max(posX, 0.0f), (float)maxX) : Math.min(posX, (float)maxX);
        posY = Math.min(Math.max(posY, (float)gap), (float)maxY);
        class_4587 ms = guiGraphics.method_51448();
        ms.method_22903();
        ms.method_46416(posX, posY, 0.0f);
        ms.method_22905(scale, scale, 1.0f);
        guiGraphics.method_51434(font, tooltipLines, 0, 0);
        ms.method_22909();
    }
}

