/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.trademarket.type.TradeMarketPriceInfo;
import com.wynntils.utils.mc.LoreUtils;
import com.wynnventory.core.ModInfo;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public class TradeMarketPriceParser {
    private static final Pattern PRICE_STR = Pattern.compile("\u00a76Price:");
    private static final Pattern PRICE_PATTERN = Pattern.compile("\u00a7[67] ?- (?:\u00a7f(?<amount>[\\d,]+) \u00a77x )?\u00a7(?:(?:(?:c\u2716|a\u2714) \u00a7f)|f\u00a7m|f)(?<price>[\\d,]+)\u00a77(?:\u00a7m)?\u00b2(?:\u00a7b \u272e (?<silverbullPrice>[\\d,]+)\u00a73\u00b2)?(?: .+)?");

    public static TradeMarketPriceInfo calculateItemPriceInfo(class_1799 itemStack) {
        LinkedList loreLines = LoreUtils.getLore((class_1799)itemStack);
        if (loreLines.size() < 2) {
            return TradeMarketPriceInfo.EMPTY;
        }
        StyledText priceLine = (StyledText)loreLines.get(1);
        if (priceLine != null && priceLine.matches(PRICE_STR)) {
            StyledText priceValueLine = (StyledText)loreLines.get(2);
            Matcher matcher = priceValueLine.getMatcher(PRICE_PATTERN);
            if (!matcher.matches()) {
                ModInfo.logWarn("Trade Market item had an unexpected price value line: " + String.valueOf(priceValueLine));
                return TradeMarketPriceInfo.EMPTY;
            }
            int price = Integer.parseInt(matcher.group("price").replace(",", ""));
            String silverbullPriceStr = matcher.group("silverbullPrice");
            int silverbullPrice = silverbullPriceStr == null ? price : Integer.parseInt(silverbullPriceStr.replace(",", ""));
            String amountStr = matcher.group("amount");
            int amount = amountStr == null ? 1 : Integer.parseInt(amountStr.replace(",", ""));
            return new TradeMarketPriceInfo(price, silverbullPrice, amount);
        }
        ModInfo.logWarn("Trade Market item had an unexpected price line: " + String.valueOf(priceLine));
        return TradeMarketPriceInfo.EMPTY;
    }
}

