/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.MixinService;

public class PreLaunchHandler {
    static void onPreLaunch() {
        if (Boolean.getBoolean("com.ishland.c2me.mixin.doAudit")) {
            Logger auditLogger = LoggerFactory.getLogger((String)"C2ME Mixin Audit");
            try {
                Class<?> transformerClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer");
                if (transformerClazz.isInstance(MixinEnvironment.getCurrentEnvironment().getActiveTransformer())) {
                    Field processorField = transformerClazz.getDeclaredField("processor");
                    processorField.setAccessible(true);
                    Object processor = processorField.get(MixinEnvironment.getCurrentEnvironment().getActiveTransformer());
                    Class<?> processorClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinProcessor");
                    Field configsField = processorClazz.getDeclaredField("configs");
                    configsField.setAccessible(true);
                    List configs = (List)configsField.get(processor);
                    Class<?> configClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
                    Method getUnhandledTargetsMethod = configClazz.getDeclaredMethod("getUnhandledTargets", new Class[0]);
                    getUnhandledTargetsMethod.setAccessible(true);
                    HashSet unhandled = new HashSet();
                    for (Object config : configs) {
                        Set unhandledTargets = (Set)getUnhandledTargetsMethod.invoke(config, new Object[0]);
                        unhandled.addAll(unhandledTargets);
                    }
                    for (String s : unhandled) {
                        auditLogger.info("Loading class {}", (Object)s);
                        try {
                            MixinService.getService().getClassProvider().findClass(s, false);
                        }
                        catch (ClassNotFoundException e) {
                            auditLogger.warn("Failed to find class {}", (Object)s, (Object)e);
                        }
                    }
                    for (Object config : configs) {
                        for (String unhandledTarget : (Set)getUnhandledTargetsMethod.invoke(config, new Object[0])) {
                            auditLogger.error("{} is already classloaded", (Object)unhandledTarget);
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to audit mixins", t);
            }
        }
    }
}

