/*
 * Decompiled with CFR 0.152.
 */
package com.keysmith;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Keysmith
extends JavaPlugin
implements Listener {
    private final Map<String, String> lockedObjects = new ConcurrentHashMap<String, String>();
    private final Map<String, Integer> lockDurability = new ConcurrentHashMap<String, Integer>();
    private final Set<String> masterKeys = new HashSet<String>();
    private NamespacedKey keyIdKey;
    private NamespacedKey keyNameKey;
    private NamespacedKey lockIdKey;
    private FileConfiguration config;
    private boolean lockpickingEnabled;
    private boolean lockDurabilityEnabled;
    private boolean masterKeyEnabled;
    private double lockpickChance;
    private int maxLockDurability;
    private List<Material> lockpickTools;

    public void onEnable() {
        this.keyIdKey = new NamespacedKey((Plugin)this, "key_id");
        this.keyNameKey = new NamespacedKey((Plugin)this, "key_name");
        this.lockIdKey = new NamespacedKey((Plugin)this, "lock_id");
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.loadData();
        this.getLogger().info("Keysmith v1.0.0 has been enabled!");
        this.getLogger().info("Compatible with Minecraft 1.20 \u2192 1.21.5");
    }

    public void onDisable() {
        this.saveData();
        this.getLogger().info("Keysmith has been disabled!");
    }

    private void loadConfig() {
        this.config = this.getConfig();
        this.lockpickingEnabled = this.config.getBoolean("lockpicking.enabled", false);
        this.lockDurabilityEnabled = this.config.getBoolean("lock-durability.enabled", false);
        this.masterKeyEnabled = this.config.getBoolean("master-key.enabled", false);
        this.lockpickChance = this.config.getDouble("lockpicking.chance", 0.1);
        this.maxLockDurability = this.config.getInt("lock-durability.max", 100);
        this.lockpickTools = new ArrayList<Material>();
        for (String tool : this.config.getStringList("lockpicking.tools")) {
            try {
                this.lockpickTools.add(Material.valueOf((String)tool.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid lockpick tool: " + tool);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("keysmith")) {
            if (args.length == 0) {
                this.showHelp(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "create": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /keysmith create [keyName]");
                        return true;
                    }
                    this.createKey(player, args[1]);
                    break;
                }
                case "unlock": {
                    this.handleUnlock(player);
                    break;
                }
                case "master": {
                    if (!player.hasPermission("keysmith.master")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use master keys!");
                        return true;
                    }
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /keysmith master [add/remove] [keyName]");
                        return true;
                    }
                    this.handleMasterKey(player, args);
                    break;
                }
                case "reload": {
                    if (!player.hasPermission("keysmith.admin")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the config!");
                        return true;
                    }
                    this.reloadConfig();
                    this.loadConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded!");
                    break;
                }
                default: {
                    this.showHelp(player);
                }
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Keysmith Commands ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/keysmith create [keyName] - Create a new key");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/keysmith unlock - Unlock with key in hand");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Sneak + Right-click to lock objects");
        if (player.hasPermission("keysmith.master")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/keysmith master [add/remove] [keyName] - Manage master keys");
        }
        if (player.hasPermission("keysmith.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/keysmith reload - Reload config");
        }
    }

    private void createKey(Player player, String keyName) {
        if (!player.hasPermission("keysmith.create")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to create keys!");
            return;
        }
        String keyId = UUID.randomUUID().toString();
        ItemStack key = new ItemStack(Material.TRIPWIRE_HOOK);
        ItemMeta meta = key.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "\ud83d\udd11 " + keyName);
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Key ID: " + keyId.substring(0, 8), String.valueOf(ChatColor.GRAY) + "Right-click to unlock", String.valueOf(ChatColor.GRAY) + "Sneak + Right-click to lock"));
        meta.getPersistentDataContainer().set(this.keyIdKey, PersistentDataType.STRING, (Object)keyId);
        meta.getPersistentDataContainer().set(this.keyNameKey, PersistentDataType.STRING, (Object)keyName);
        key.setItemMeta(meta);
        if (player.getInventory().firstEmpty() == -1) {
            player.getWorld().dropItem(player.getLocation(), key);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your inventory is full! Key dropped on ground.");
        } else {
            player.getInventory().addItem(new ItemStack[]{key});
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Created key: " + String.valueOf(ChatColor.GOLD) + keyName);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        Block block = event.getClickedBlock();
        if (item == null || block == null) {
            return;
        }
        if (this.isKey(item)) {
            String keyId = this.getKeyId(item);
            String keyName = this.getKeyName(item);
            if (player.isSneaking()) {
                if (this.isLockableBlock(block)) {
                    this.lockObject(player, block, keyId, keyName);
                    event.setCancelled(true);
                }
            } else if (this.isLockedObject(block)) {
                this.unlockObject(player, block, keyId);
                event.setCancelled(true);
            }
        } else if (this.lockpickingEnabled && this.isLockpickTool(item.getType()) && this.isLockedObject(block)) {
            this.attemptLockpick(player, block);
            event.setCancelled(true);
        }
    }

    private boolean isKey(ItemStack item) {
        if (item == null || item.getType() != Material.TRIPWIRE_HOOK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.getPersistentDataContainer().has(this.keyIdKey, PersistentDataType.STRING);
    }

    private String getKeyId(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(this.keyIdKey, PersistentDataType.STRING);
    }

    private String getKeyName(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(this.keyNameKey, PersistentDataType.STRING);
    }

    private boolean isLockableBlock(Block block) {
        Material type = block.getType();
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL || type == Material.SHULKER_BOX || type.name().contains("SHULKER_BOX") || type.name().contains("DOOR") || type.name().contains("TRAPDOOR") || type.name().contains("FENCE_GATE");
    }

    private void lockObject(Player player, Block block, String keyId, String keyName) {
        String blockId = this.getBlockId(block);
        if (this.lockedObjects.containsKey(blockId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This object is already locked!");
            return;
        }
        this.lockedObjects.put(blockId, keyId);
        if (this.lockDurabilityEnabled) {
            this.lockDurability.put(blockId, this.maxLockDurability);
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Locked with key: " + String.valueOf(ChatColor.GOLD) + keyName);
        player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 0.8f);
        block.getWorld().spawnParticle(Particle.CRIT, block.getLocation().add(0.5, 1.0, 0.5), 10, 0.2, 0.2, 0.2, 0.1);
    }

    private void lockEntity(Player player, AbstractHorse horse, String keyId, String keyName) {
        String entityId = horse.getUniqueId().toString();
        if (this.lockedObjects.containsKey(entityId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This horse is already locked!");
            return;
        }
        this.lockedObjects.put(entityId, keyId);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Locked horse with key: " + String.valueOf(ChatColor.GOLD) + keyName);
        player.playSound(player.getLocation(), Sound.ENTITY_HORSE_SADDLE, 1.0f, 0.8f);
    }

    private boolean isLockedObject(Block block) {
        String blockId = this.getBlockId(block);
        return this.lockedObjects.containsKey(blockId);
    }

    private void unlockObject(Player player, Block block, String keyId) {
        Integer durability;
        String blockId = this.getBlockId(block);
        String requiredKeyId = this.lockedObjects.get(blockId);
        if (requiredKeyId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This object is not locked!");
            return;
        }
        if (!requiredKeyId.equals(keyId) && !this.isMasterKey(keyId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Wrong key!");
            player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 0.5f);
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Unlocked!");
        player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.2f);
        if (this.lockDurabilityEnabled && (durability = this.lockDurability.get(blockId)) != null) {
            Integer n = durability;
            durability = durability - 1;
            if (durability <= 0) {
                this.lockedObjects.remove(blockId);
                this.lockDurability.remove(blockId);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "The lock has broken!");
            } else {
                this.lockDurability.put(blockId, durability);
            }
        }
        this.openObject(block);
    }

    private void unlockEntity(Player player, AbstractHorse horse, String keyId) {
        String entityId = horse.getUniqueId().toString();
        String requiredKeyId = this.lockedObjects.get(entityId);
        if (requiredKeyId == null) {
            return;
        }
        if (!requiredKeyId.equals(keyId) && !this.isMasterKey(keyId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Wrong key for this horse!");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Horse unlocked!");
        player.playSound(player.getLocation(), Sound.ENTITY_HORSE_EAT, 1.0f, 1.2f);
    }

    private void openObject(Block block) {
        if (block.getBlockData() instanceof Openable) {
            Openable openable;
            openable.setOpen(!(openable = (Openable)block.getBlockData()).isOpen());
            block.setBlockData((BlockData)openable);
        }
    }

    private String getBlockId(Block block) {
        return block.getWorld().getName() + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ();
    }

    private void handleUnlock(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!this.isKey(item)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You need to hold a key!");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Right-click on a locked object to unlock it!");
    }

    private void handleMasterKey(Player player, String[] args) {
        if (!this.masterKeyEnabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Master keys are disabled!");
            return;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /keysmith master [add/remove] [keyName]");
            return;
        }
        String action = args[1].toLowerCase();
        String keyName = args[2];
        if (action.equals("add")) {
            this.masterKeys.add(keyName);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Added master key: " + keyName);
        } else if (action.equals("remove")) {
            this.masterKeys.remove(keyName);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed master key: " + keyName);
        }
    }

    private boolean isMasterKey(String keyId) {
        return this.masterKeyEnabled && this.masterKeys.contains(keyId);
    }

    private boolean isLockpickTool(Material material) {
        return this.lockpickTools.contains(material);
    }

    private void attemptLockpick(Player player, Block block) {
        if (Math.random() < this.lockpickChance) {
            String blockId = this.getBlockId(block);
            this.lockedObjects.remove(blockId);
            this.lockDurability.remove(blockId);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully picked the lock!");
            player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.2f);
            ItemStack tool = player.getInventory().getItemInMainHand();
            if (tool.getType().getMaxDurability() > 0) {
                tool.setDurability((short)(tool.getDurability() + 5));
                if (tool.getDurability() >= tool.getType().getMaxDurability()) {
                    player.getInventory().setItemInMainHand(null);
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                }
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to pick the lock!");
            player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 0.5f);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Block block;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof BlockState && this.isLockedObject(block = ((BlockState)holder).getBlock())) {
            boolean hasKey = false;
            String requiredKeyId = this.lockedObjects.get(this.getBlockId(block));
            for (ItemStack item : player.getInventory().getContents()) {
                String keyId;
                if (!this.isKey(item) || !(keyId = this.getKeyId(item)).equals(requiredKeyId) && !this.isMasterKey(keyId)) continue;
                hasKey = true;
                break;
            }
            if (!hasKey) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "You need the correct key to access this!");
                player.closeInventory();
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        ItemStack first = event.getInventory().getItem(0);
        ItemStack second = event.getInventory().getItem(1);
        if (first != null && second != null && this.isKey(first) && this.isKey(second)) {
            ItemStack result = first.clone();
            result.setAmount(2);
            event.setResult(result);
        }
    }

    private void loadData() {
        File dataFile = new File(this.getDataFolder(), "locks.yml");
        if (dataFile.exists()) {
            // empty if block
        }
    }

    private void saveData() {
        File dataFile = new File(this.getDataFolder(), "locks.yml");
        try {
            if (!dataFile.exists()) {
                dataFile.getParentFile().mkdirs();
                dataFile.createNewFile();
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save lock data: " + e.getMessage());
        }
    }
}

