/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.saroseasygmswitch;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="saroseasygmswitch")
public class SarosEasyGmSwitchMod {
    public static final String MODID = "saroseasygmswitch";
    private static final Logger LOGGER = LogManager.getLogger();

    public SarosEasyGmSwitchMod(FMLJavaModLoadingContext context) {
        FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RegisterCommandsEvent.BUS.addListener(this::onRegisterCommands);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        this.registerCommands((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"gamemode").then(((RequiredArgumentBuilder)Commands.argument((String)"mode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(context -> {
            int mode = IntegerArgumentType.getInteger((CommandContext)context, (String)"mode");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return this.setGameMode((CommandSourceStack)context.getSource(), player, mode);
        })).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().stream().map(Player::getName).map(Component::getString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> {
            int mode = IntegerArgumentType.getInteger((CommandContext)context, (String)"mode");
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
            if (targetPlayer != null) {
                return this.setGameMode((CommandSourceStack)context.getSource(), targetPlayer, mode);
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"gm").then(((RequiredArgumentBuilder)Commands.argument((String)"mode", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"0", "1", "2", "3", "s", "c", "a", "sp"}, (SuggestionsBuilder)builder)).executes(context -> {
            String modeString = StringArgumentType.getString((CommandContext)context, (String)"mode");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int mode = this.parseMode(modeString);
            if (mode != -1) {
                return this.setGameMode((CommandSourceStack)context.getSource(), player, mode);
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Invalid mode"));
            return 0;
        })).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().stream().map(Player::getName).map(Component::getString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> {
            String modeString = StringArgumentType.getString((CommandContext)context, (String)"mode");
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
            int mode = this.parseMode(modeString);
            if (targetPlayer != null && mode != -1) {
                return this.setGameMode((CommandSourceStack)context.getSource(), targetPlayer, mode);
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Invalid mode or player not found"));
            return 0;
        }))));
    }

    private int parseMode(String modeString) {
        return switch (modeString) {
            case "0", "s" -> 0;
            case "1", "c" -> 1;
            case "2", "a" -> 2;
            case "3", "sp" -> 3;
            default -> -1;
        };
    }

    private int setGameMode(CommandSourceStack source, ServerPlayer player, int mode) {
        GameType gameType;
        switch (mode) {
            case 0: {
                GameType gameType2 = GameType.SURVIVAL;
                break;
            }
            case 1: {
                GameType gameType2 = GameType.CREATIVE;
                break;
            }
            case 2: {
                GameType gameType2 = GameType.ADVENTURE;
                break;
            }
            case 3: {
                GameType gameType2 = GameType.SPECTATOR;
                break;
            }
            default: {
                GameType gameType2 = gameType = null;
            }
        }
        if (gameType == null) {
            source.sendFailure((Component)Component.literal((String)"Invalid game mode"));
            return 0;
        }
        player.setGameMode(gameType);
        source.sendSuccess(() -> Component.literal((String)("Set game mode of " + player.getName().getString() + " to " + mode)), true);
        return 1;
    }
}

