/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.api;

import com.Apothic0n.Astrological.api.AstrologicalMath;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.SimplexNoise;

public final class AstrologicalDensityFunctions {
    public static final DeferredRegister<Codec<? extends DensityFunction>> DENSITY_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256746_, (String)"astrological");
    public static final RegistryObject<Codec<? extends DensityFunction>> LOWER_ISLANDS_DENSITY_FUNCTION_TYPE = DENSITY_FUNCTION_TYPES.register("lower_islands", () -> LowerIslands.CODEC.f_216232_());

    public static void register(IEventBus eventBus) {
        DENSITY_FUNCTION_TYPES.register(eventBus);
    }

    static <O> KeyDispatchDataCodec<O> makeCodec(MapCodec<O> codec) {
        return KeyDispatchDataCodec.m_216238_(codec);
    }

    protected record LowerIslands(DensityFunction input, boolean hollow) implements DensityFunction
    {
        private static final MapCodec<LowerIslands> DATA_CODEC = RecordCodecBuilder.mapCodec(data -> data.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(LowerIslands::input), (App)Codec.BOOL.fieldOf("hollow").forGetter(LowerIslands::hollow)).apply((Applicative)data, LowerIslands::new));
        public static final KeyDispatchDataCodec<LowerIslands> CODEC = AstrologicalDensityFunctions.makeCodec(DATA_CODEC);

        public double m_207386_(@NotNull DensityFunction.FunctionContext context) {
            int x = context.m_207115_();
            int y = context.m_207114_();
            int z = context.m_207113_();
            int mainOffset = (int)(SimplexNoise.noise((float)((float)x * 0.005f), (float)((float)z * 0.005f)) * 25.0f);
            int offset = -300 + mainOffset;
            int offset2 = -400 + mainOffset;
            if (y < 0) {
                double airPart = Math.abs(SimplexNoise.noise((float)((float)x * 0.02f), (float)((float)(y + mainOffset) * 0.005f), (float)((float)z * 0.02f))) * -1.0f;
                double solidPart = Math.abs(SimplexNoise.noise((float)((float)x * 0.0024f), (float)((float)(y + mainOffset) * 0.0016f), (float)((float)z * 0.0024f)));
                double floatingIsland = y > -155 ? Math.min(0.5 - (airPart + AstrologicalMath.gradient(y, 164 + offset, 292 + offset, -1.0f, 1.5f)), solidPart + (AstrologicalMath.gradient(y, 228 + offset, 356 + offset, 0.75f, 0.5f) - 2.0 * (0.1 + AstrologicalMath.gradient(y, 169 + offset, 259 + offset, 0.76f, 0.0f)))) : Math.min(0.5 - (airPart + AstrologicalMath.gradient(y, 164 + offset2, 292 + offset2, -1.0f, 1.5f)), solidPart + (AstrologicalMath.gradient(y, 228 + offset2, 356 + offset2, 0.75f, 0.5f) - 2.0 * (0.1 + AstrologicalMath.gradient(y, 169 + offset2, 259 + offset2, 0.76f, 0.0f))));
                double caves = 0.0;
                if (this.hollow()) {
                    caves = Math.min(0.0, (floatingIsland - 0.2) * -5.0);
                }
                return caves + floatingIsland + this.input().m_207386_(context);
            }
            return this.input().m_207386_(context);
        }

        public void m_207362_(double @NotNull [] densities, DensityFunction.ContextProvider context) {
            context.m_207207_(densities, (DensityFunction)this);
        }

        @NotNull
        public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
            return visitor.m_214017_((DensityFunction)new LowerIslands(this.input().m_207456_(visitor), this.hollow()));
        }

        public double m_207402_() {
            return -1875000.0;
        }

        public double m_207401_() {
            return 1875000.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC;
        }
    }
}

