/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.api;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public final class MaskingSource
implements SpriteSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation ID = new ResourceLocation("astrological", "mask");
    private static SpriteSourceType TYPE = null;
    private static final Codec<MaskingSource> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("source").forGetter(s -> s.source), (App)ResourceLocation.f_135803_.fieldOf("mask").forGetter(s -> s.mask), (App)ResourceLocation.f_135803_.fieldOf("sprite").forGetter(s -> s.outLoc)).apply((Applicative)inst, MaskingSource::new));
    private final ResourceLocation source;
    private final ResourceLocation mask;
    private final ResourceLocation outLoc;

    public MaskingSource(ResourceLocation source, ResourceLocation mask, ResourceLocation outLoc) {
        this.source = source;
        this.mask = mask;
        this.outLoc = outLoc;
    }

    public void m_260891_(ResourceManager mgr, SpriteSource.Output out) {
        ResourceLocation sourcePath = f_266012_.m_245698_(this.source);
        Optional optSource = mgr.m_213713_(sourcePath);
        if (optSource.isEmpty()) {
            LOGGER.warn("Missing source texture: {}", (Object)sourcePath);
            return;
        }
        ResourceLocation maskPath = f_266012_.m_245698_(this.mask);
        Optional optMask = mgr.m_213713_(maskPath);
        if (optMask.isEmpty()) {
            LOGGER.warn("Missing mask texture: {}", (Object)maskPath);
            return;
        }
        Resource sourceRes = (Resource)optSource.get();
        Resource maskRes = (Resource)optMask.get();
        LazyLoadedImage sourceImg = new LazyLoadedImage(sourcePath, sourceRes, 1);
        LazyLoadedImage maskImg = new LazyLoadedImage(maskPath, maskRes, 1);
        out.m_260840_(this.outLoc, (SpriteSource.SpriteSupplier)new MaskingSpriteSupplier(sourcePath, maskPath, sourceRes, maskRes, sourceImg, maskImg, this.outLoc));
    }

    public SpriteSourceType m_260850_() {
        Preconditions.checkNotNull((Object)TYPE, (Object)"SpriteSourceType not registered");
        return TYPE;
    }

    public static void register() {
        TYPE = SpriteSources.m_260887_((String)ID.toString(), CODEC);
    }

    private record MaskingSpriteSupplier(ResourceLocation sourceLoc, ResourceLocation maskLoc, Resource sourceRes, Resource maskRes, LazyLoadedImage sourceImg, LazyLoadedImage maskImg, ResourceLocation outLoc) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents get() {
            try {
                int maskScale;
                int maskHeight;
                int maskWidth;
                int srcHeight;
                AnimationMetadataSection maskAnim = this.maskRes.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
                if (maskAnim != AnimationMetadataSection.f_119012_) {
                    throw new IllegalArgumentException("Mask texture must not be animated");
                }
                NativeImage source = this.sourceImg.m_266167_();
                NativeImage mask = this.maskImg.m_266167_();
                AnimationMetadataSection sourceAnim = this.sourceRes.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
                FrameSize srcSize = sourceAnim.m_245821_(source.m_84982_(), source.m_85084_());
                int srcWidth = srcSize.f_244129_();
                if (!MaskingSpriteSupplier.checkAspectRatio(srcWidth, srcHeight = srcSize.f_244503_(), maskWidth = mask.m_84982_(), maskHeight = mask.m_85084_())) {
                    throw new IllegalArgumentException("Aspect ratio of source texture and mask texture don't match. Texture sizes: (%d, %d) and (%d, %d)".formatted(srcWidth, srcHeight, maskWidth, maskHeight));
                }
                int srcScale = maskWidth > srcWidth ? maskWidth / srcWidth : 1;
                int n = maskScale = srcWidth > maskWidth ? srcWidth / maskWidth : 1;
                if (srcScale > 1 && srcWidth * srcScale != maskWidth || maskScale > 1 && maskWidth * maskScale != srcWidth) {
                    throw new IllegalArgumentException("Source texture and mask texture cannot be scaled to match. Texture sizes: (%d, %d) and (%d, %d)".formatted(srcWidth, srcHeight, maskWidth, maskHeight));
                }
                source = MaskingSpriteSupplier.scaleImage(source, srcScale);
                mask = MaskingSpriteSupplier.scaleImage(mask, maskScale);
                FrameSize resultSize = new FrameSize(Math.max(srcWidth, maskWidth), Math.max(srcHeight, maskHeight));
                NativeImage imageOut = new NativeImage(NativeImage.Format.RGBA, source.m_84982_(), source.m_85084_(), false);
                List<FrameInfo> frames = MaskingSpriteSupplier.collectFrames(source, srcSize, sourceAnim);
                MaskingSpriteSupplier.buildOutputImage(frames, source, mask, imageOut, resultSize);
                SpriteContents spriteContents = new SpriteContents(this.outLoc, resultSize, imageOut, sourceAnim, null);
                return spriteContents;
            }
            catch (Exception e) {
                LOGGER.error("Failed to apply mask '{}' to texture '{}'", new Object[]{this.maskLoc, this.sourceLoc, e});
            }
            finally {
                this.sourceImg.m_266458_();
                this.maskImg.m_266458_();
            }
            return null;
        }

        public void m_260986_() {
            this.sourceImg.m_266458_();
            this.maskImg.m_266458_();
        }

        private static boolean checkAspectRatio(int bgWidth, int bgHeight, int fgWidth, int fgHeight) {
            int heightFactor;
            int widthFactor = Math.max(bgWidth, fgWidth) / Math.min(bgWidth, fgWidth);
            return widthFactor == (heightFactor = Math.max(bgHeight, fgHeight) / Math.min(bgHeight, fgHeight));
        }

        private static NativeImage scaleImage(NativeImage source, int scale) {
            if (scale > 1) {
                NativeImage scaled = new NativeImage(source.m_85102_(), source.m_84982_() * scale, source.m_85084_() * scale, false);
                scaled.m_85034_(0, 0, source.m_84982_(), source.m_85084_(), source);
                source.close();
                return scaled;
            }
            return source;
        }

        private static List<FrameInfo> collectFrames(NativeImage image, FrameSize size, AnimationMetadataSection animation) {
            ArrayList<FrameInfo> frames = new ArrayList<FrameInfo>();
            int rowCount = image.m_84982_() / size.f_244129_();
            animation.m_174861_((idx, time) -> {
                int frameX = idx % rowCount * size.f_244129_();
                int frameY = idx / rowCount * size.f_244503_();
                frames.add(new FrameInfo(idx, frameX, frameY));
            });
            if (frames.isEmpty()) {
                int frameCount = rowCount * (image.m_85084_() / size.f_244503_());
                for (int idx2 = 0; idx2 < frameCount; ++idx2) {
                    int frameX = idx2 % rowCount * size.f_244129_();
                    int frameY = idx2 / rowCount * size.f_244503_();
                    frames.add(new FrameInfo(idx2, frameX, frameY));
                }
            }
            return frames;
        }

        private static void buildOutputImage(List<FrameInfo> frames, NativeImage source, NativeImage mask, NativeImage imageOut, FrameSize resultSize) {
            frames.forEach(frame -> {
                int fx = frame.x();
                int fy = frame.y();
                for (int y = 0; y < resultSize.f_244503_(); ++y) {
                    for (int x = 0; x < resultSize.f_244129_(); ++x) {
                        int absX = fx + x;
                        int absY = fy + y;
                        int color = 0;
                        if (mask.m_85087_(x, y) != 0) {
                            color = source.m_84985_(absX, absY);
                        }
                        imageOut.m_84988_(absX, absY, color);
                    }
                }
            });
        }
    }

    private record FrameInfo(int idx, int x, int y) {
    }
}

