/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.events;

import com.Apothic0n.Astrological.api.AstrologicalJsonReader;
import com.Apothic0n.Astrological.api.AstrologicalMath;
import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="astrological", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    private static ResourceLocation END_SUN_LOCATION = new ResourceLocation("astrological", "textures/environment/end_sun.png");
    private static ResourceLocation SATURN_PHASES_LOCATION = new ResourceLocation("astrological", "textures/environment/saturn_phases.png");
    private static int sleepSoundDelay = 19;
    private static int soundDelay = 40;

    @SubscribeEvent
    public static void renderLevelStageEvent(RenderLevelStageEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && level.m_46472_().equals((Object)Level.f_46430_) && event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY)) {
            float time;
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            PoseStack poseStack = event.getPoseStack();
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            if (AstrologicalJsonReader.customEndSky) {
                RenderSystem.setShader(GameRenderer::m_172820_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TheEndPortalRenderer.f_112627_);
                for (int i = 0; i < 6; ++i) {
                    poseStack.m_85836_();
                    if (i == 1) {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    }
                    if (i == 2) {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    }
                    if (i == 3) {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    }
                    if (i == 4) {
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    }
                    if (i == 5) {
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                    }
                    Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    bufferbuilder.m_252986_(matrix4f, -110.0f, -110.0f, -110.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 100).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, -110.0f, -110.0f, 110.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 100).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, 110.0f, -110.0f, 110.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 100).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, 110.0f, -110.0f, -110.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 100).m_5752_();
                    tesselator.m_85914_();
                    poseStack.m_85849_();
                }
            }
            if ((time = (float)level.m_46468_()) > 24000.0f) {
                time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
            }
            float finalTime = time;
            Block sleep = (Block)AstrologicalBlocks.SLEEP.get();
            --soundDelay;
            level.m_6907_().forEach(player -> {
                if (soundDelay <= 0 && (finalTime >= 22700.0f && finalTime <= 23750.0f || finalTime >= 12500.0f && finalTime <= 13000.0f)) {
                    soundDelay = 40;
                    level.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_11737_, SoundSource.WEATHER, 0.3f, 1.69f);
                    if (finalTime == 22700.0f || finalTime == 12500.0f) {
                        level.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_11736_, SoundSource.AMBIENT, 2.0f, 1.69f);
                    } else if (finalTime == 23750.0f || finalTime == 13000.0f) {
                        level.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_11738_, SoundSource.AMBIENT, 2.0f, 1.69f);
                    }
                }
                double speed = Math.max(player.m_20184_().m_7096_(), player.m_20184_().m_7094_()) + player.m_20184_().m_7098_();
                if ((level.m_8055_(player.m_20183_().m_7495_()).m_60713_(sleep) || level.m_8055_(player.m_20183_()).m_60713_(sleep) || level.m_8055_(player.m_20183_().m_7494_()).m_60713_(sleep)) && !Minecraft.m_91087_().m_91104_() && sleepSoundDelay < 0) {
                    sleepSoundDelay = 20;
                    level.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_12591_, SoundSource.PLAYERS, Math.max((float)(speed * 4.0 + 0.1), 1.0f), Math.max((float)(speed * 8.0 + 0.1), 1.0f));
                }
                sleepSoundDelay -= (int)(speed * 5.0) + 1;
            });
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_SUN_LOCATION);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f1, -f12, 110.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 110.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 110.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, -f12, 110.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            if (time >= 22000.0f || time <= 500.0f) {
                float o16;
                float o12;
                float o8;
                float o4;
                int mid;
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.m_46941_();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                int min = 22000;
                int max = 24500;
                float extraTime = time;
                if (extraTime <= 500.0f) {
                    extraTime = 24000.0f + time;
                }
                if (extraTime < (float)(mid = (max - min) / 2 + min)) {
                    max = mid;
                    o4 = AstrologicalMath.invLerp(extraTime, 4.0f, min, max);
                    o8 = AstrologicalMath.invLerp(extraTime, 8.0f, min, max);
                    o12 = AstrologicalMath.invLerp(extraTime, 12.0f, min, max);
                    o16 = AstrologicalMath.invLerp(extraTime, 16.0f, min, max);
                } else {
                    min = mid;
                    o4 = AstrologicalMath.invLerp(extraTime, 4.0f, max, min);
                    o8 = AstrologicalMath.invLerp(extraTime, 8.0f, max, min);
                    o12 = AstrologicalMath.invLerp(extraTime, 12.0f, max, min);
                    o16 = AstrologicalMath.invLerp(extraTime, 16.0f, max, min);
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -f12 + o8, 100.0f, -f12 + o16).m_7421_(f15, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12 + o4, 100.0f, -f12 + o12).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12 + o8, 100.0f, f12 + o8).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -f12 + o12, 100.0f, f12 + o12).m_7421_(f15, f14).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            } else if (time >= 12000.0f && time <= 13500.0f) {
                float o16;
                float o12;
                float o8;
                float o4;
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.m_46941_();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                int min = 12000;
                int max = 13500;
                int mid = (max - min) / 2 + min;
                if (time < (float)mid) {
                    max = mid;
                    o4 = AstrologicalMath.invLerp(time, 4.0f, min, max);
                    o8 = AstrologicalMath.invLerp(time, 8.0f, min, max);
                    o12 = AstrologicalMath.invLerp(time, 12.0f, min, max);
                    o16 = AstrologicalMath.invLerp(time, 16.0f, min, max);
                } else {
                    min = mid;
                    o4 = AstrologicalMath.invLerp(time, 4.0f, max, min);
                    o8 = AstrologicalMath.invLerp(time, 8.0f, max, min);
                    o12 = AstrologicalMath.invLerp(time, 12.0f, max, min);
                    o16 = AstrologicalMath.invLerp(time, 16.0f, max, min);
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -f12 - o8, 100.0f, -f12 - o16).m_7421_(f15, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12 - o4, 100.0f, -f12 - o12).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12 - o8, 100.0f, f12 - o8).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -f12 - o12, 100.0f, f12 - o12).m_7421_(f15, f14).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            } else {
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.m_46941_();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(f15, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(f15, f14).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }
}

