/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.events;

import com.Apothic0n.Astrological.api.MaskingSource;
import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.Apothic0n.Astrological.core.objects.AstrologicalItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="astrological", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEvents {
    public static final PerlinSimplexNoise SATURATION_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (List)ImmutableList.of((Object)0));
    public static final PerlinSimplexNoise BRIGHTNESS_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(5432L)), (List)ImmutableList.of((Object)0));

    @SubscribeEvent
    public static void registerMask(RegisterClientReloadListenersEvent event) {
        MaskingSource.register();
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        if (tab.equals((Object)CreativeModeTabs.f_256776_)) {
            event.m_245282_((ItemLike)AstrologicalItems.SLEEP.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.TUMOR.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.CYST.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.CRYING_DUCT.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.INSOMNIA_VENT.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.OCHRE_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.VERDANT_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.PEARLESCENT_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.PURPURITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.TRIPHYLITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.LIGHT_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tab.equals((Object)CreativeModeTabs.f_256788_)) {
            event.m_245282_((ItemLike)AstrologicalItems.PRISMATIC_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.SELENITE_WALL.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.REINFORCED_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.JADE_BRICKS.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.POLISHED_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.MARBLED_JADE_SLAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.LIGHT_JADE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.CRACKED_LIGHT_JADE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.PURPURITE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            List<List<RegistryObject<Item>>> buildingBlockItems = List.of(AstrologicalItems.wallItems, AstrologicalItems.stairItems, AstrologicalItems.slabItems);
            for (int i = 0; i < buildingBlockItems.size(); ++i) {
                List<RegistryObject<Item>> blockItemTypeList = buildingBlockItems.get(i);
                for (int o = 0; o < blockItemTypeList.size(); ++o) {
                    event.m_245282_((ItemLike)blockItemTypeList.get(o).get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        } else if (tab.equals((Object)CreativeModeTabs.f_256968_)) {
            event.m_245282_((ItemLike)AstrologicalItems.PURPURITE_BLOB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_245282_((ItemLike)AstrologicalItems.POPPED_PURPURITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, tint) -> {
            if (blockPos != null && Minecraft.m_91087_().f_91073_ != null) {
                int x = blockPos.m_123341_();
                int z = blockPos.m_123343_();
                int color = -328966;
                double saturate = Mth.m_14008_((double)(SATURATION_NOISE.m_75449_((double)x * 0.1, (double)z * 0.1, false) * 0.33), (double)-0.03, (double)0.03) + 1.1;
                double brighten = Mth.m_14008_((double)(BRIGHTNESS_NOISE.m_75449_((double)x * 0.025, (double)z * 0.025, false) * 0.3), (double)-0.33, (double)0.33);
                float red = (float)FastColor.ABGR32.m_266313_((int)color) / 255.0f;
                float green = (float)FastColor.ABGR32.m_266446_((int)color) / 255.0f;
                float blue = (float)FastColor.ABGR32.m_266247_((int)color) / 255.0f;
                float gray = (float)((double)(red + green + blue) / (3.0 + brighten));
                return FastColor.ABGR32.m_266248_((int)FastColor.ABGR32.m_266503_((int)color), (int)((int)(Mth.m_14008_((double)((double)(blue + (gray - blue)) * saturate), (double)0.0, (double)1.0) * 255.0)), (int)((int)(Mth.m_14008_((double)((double)(green + (gray - green)) * saturate), (double)0.0, (double)1.0) * 255.0)), (int)((int)(Mth.m_14008_((double)((double)(red + (gray - red)) * saturate), (double)0.0, (double)1.0) * 255.0)));
            }
            return -328966;
        }, new Block[]{(Block)AstrologicalBlocks.OCHRE_SELENITE.get(), (Block)AstrologicalBlocks.VERDANT_SELENITE.get(), (Block)AstrologicalBlocks.PEARLESCENT_SELENITE.get(), (Block)AstrologicalBlocks.JADE.get(), Blocks.f_50259_, Blocks.f_50443_, Blocks.f_50634_, Blocks.f_50648_, Blocks.f_50614_});
        event.register((blockState, blockAndTintGetter, blockPos, tint) -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                int color = -19457;
                float time = level.m_46468_();
                if (time > 24000.0f) {
                    time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
                }
                if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                    color = -9549;
                } else if (time <= 12000.0f) {
                    color = -3670093;
                }
                return color;
            }
            return -328966;
        }, new Block[]{(Block)AstrologicalBlocks.PRISMATIC_SELENITE.get(), (Block)AstrologicalBlocks.SELENITE_WALL.get()});
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((blockAndTintGetter, tint) -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                int color = -19457;
                float time = level.m_46468_();
                if (time > 24000.0f) {
                    time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
                }
                if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                    color = -9549;
                } else if (time <= 12000.0f) {
                    color = -3670093;
                }
                return color;
            }
            return -328966;
        }, new ItemLike[]{(ItemLike)AstrologicalBlocks.PRISMATIC_SELENITE.get(), (ItemLike)AstrologicalBlocks.SELENITE_WALL.get()});
    }
}

