/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.AstrologicalBlockEntities;
import com.Apothic0n.Astrological.core.objects.PrismaticBlockEntity;
import com.Apothic0n.Astrological.core.objects.PrismaticWallBlockEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class PrismaticWallBlock
extends WallBlock
implements EntityBlock {
    public PrismaticWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PrismaticBlockEntity.PRISMATIC_POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)PrismaticBlockEntity.USELESS_TOGGLE, (Comparable)Boolean.valueOf(false)));
        this.fixShapeMaps();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PrismaticBlockEntity.PRISMATIC_POWER, PrismaticBlockEntity.USELESS_TOGGLE});
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos blockpos = blockHitResult.m_82425_();
            level.m_5594_((Player)null, blockpos, SoundEvents.f_144245_, SoundSource.BLOCKS, 2.0f, 2.03f + level.f_46441_.m_188501_() * 0.02f);
            level.m_5594_((Player)null, blockpos, SoundEvents.f_144243_, SoundSource.BLOCKS, 2.0f, 2.03f + level.f_46441_.m_188501_() * 0.02f);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return PrismaticWallBlockEntity::tick;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)AstrologicalBlockEntities.SELENITE_WALL.get()).m_155264_(blockPos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_49958_() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float newFriction = this.f_60447_;
        if (level != null) {
            float time = level.m_46468_();
            if (time > 24000.0f) {
                time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
            }
            if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                newFriction = 1.15f;
            } else if (time <= 12000.0f) {
                newFriction = 0.2f;
            }
        }
        return newFriction;
    }

    private void fixShapeMaps() {
        Map<BlockState, VoxelShape> shapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)((Object)this), (String)"f_57955_");
        shapeByIndex = PrismaticWallBlock.fixShapeMap(shapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)((Object)this), shapeByIndex, (String)"f_57955_");
        Map<BlockState, VoxelShape> collisionShapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)((Object)this), (String)"f_57956_");
        collisionShapeByIndex = PrismaticWallBlock.fixShapeMap(collisionShapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)((Object)this), collisionShapeByIndex, (String)"f_57956_");
    }

    private static Map<BlockState, VoxelShape> fixShapeMap(Map<BlockState, VoxelShape> map) {
        Preconditions.checkNotNull(map, (Object)"Got a null map?!");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : map.keySet()) {
            VoxelShape shape = map.get(state);
            Iterator iterator = PrismaticBlockEntity.PRISMATIC_POWER.m_6908_().iterator();
            while (iterator.hasNext()) {
                int prismaticPower = (Integer)iterator.next();
                state = (BlockState)state.m_61124_((Property)PrismaticBlockEntity.PRISMATIC_POWER, (Comparable)Integer.valueOf(prismaticPower));
                builder.put((Object)state, (Object)shape);
                builder.put((Object)((BlockState)state.m_61122_((Property)PrismaticBlockEntity.USELESS_TOGGLE)), (Object)shape);
            }
        }
        return builder.build();
    }
}

