/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.mixin;

import com.Apothic0n.Astrological.api.AstrologicalJsonReader;
import com.Apothic0n.Astrological.api.AstrologicalMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DimensionType.class})
public abstract class DimensionTypeMixin {
    @Inject(method={"ambientLight"}, at={@At(value="HEAD")}, cancellable=true)
    public void ambientLight(CallbackInfoReturnable<Float> ci) {
        ClientLevel level;
        if (AstrologicalJsonReader.customEndLighting && (level = Minecraft.m_91087_().f_91073_) != null && level.m_46472_().equals((Object)Level.f_46430_)) {
            float ambientLight;
            float time = level.m_46468_();
            if (time > 24000.0f) {
                time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
            }
            if (time >= 22450.0f && time <= 23999.0f) {
                int max = 23750;
                int min = 22750;
                int mid = (max - min) / 2 + min;
                if (time < (float)mid) {
                    max = mid;
                    ambientLight = AstrologicalMath.invLerp(time, 0.1f, min, max);
                } else {
                    min = mid;
                    ambientLight = AstrologicalMath.invLerp(time, 0.1f, max, min);
                }
            } else if (time >= 12333.0f && time <= 13125.0f) {
                int max = 13000;
                int min = 12500;
                int mid = (max - min) / 2 + min;
                if (time < (float)mid) {
                    max = mid;
                    ambientLight = AstrologicalMath.invLerp(time, 0.1f, min, max);
                } else {
                    min = mid;
                    ambientLight = AstrologicalMath.invLerp(time, 0.1f, max, min);
                }
            } else {
                ambientLight = -0.1f;
            }
            ci.setReturnValue((Object)Float.valueOf(ambientLight - 0.166f));
        }
    }
}

