/*
 * Decompiled with CFR 0.152.
 */
package net.moritz_htk.music_delay_reducer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.moritz_htk.music_delay_reducer.MusicDelayReducer;
import net.moritz_htk.music_delay_reducer.config.MDRConfig;

public class MDRConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/music_delay_reducer.json");
    private static MDRConfig CONFIG;

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (MDRConfig)GSON.fromJson((Reader)reader, MDRConfig.class);
                MusicDelayReducer.logDebugMode("Config loaded successfully", new Object[0]);
            }
            catch (IOException e) {
                MusicDelayReducer.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            CONFIG = new MDRConfig();
            MusicDelayReducer.LOGGER.warn("Config file not found. Creating new config...");
        }
    }

    public static void saveConfig() {
        MusicDelayReducer.logDebugMode("Saving config...", new Object[0]);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
            MusicDelayReducer.logDebugMode("Config saved successfully", new Object[0]);
        }
        catch (IOException e) {
            MusicDelayReducer.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static MDRConfig getConfig() {
        return CONFIG;
    }
}

