/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class BbPathfinding {
    public static Map<Integer, List<class_2338>> PATHS = new HashMap<Integer, List<class_2338>>();

    public static List<class_2338> getPathTo(class_1297 pathingEntity, class_2338 targetPos) {
        List<class_2338> path;
        if (PATHS.containsKey(pathingEntity.method_5628()) && (path = PATHS.get(pathingEntity.method_5628())) != null && !path.isEmpty() && path.getLast().equals((Object)targetPos)) {
            return path;
        }
        path = BbPathfinding.calculatePath(pathingEntity.method_24515(), targetPos, pathingEntity.method_37908());
        if (path != null && !path.isEmpty()) {
            PATHS.put(pathingEntity.method_5628(), path);
            return path;
        }
        PATHS.remove(pathingEntity.method_5628());
        return null;
    }

    private static List<class_2338> calculatePath(class_2338 startPos, class_2338 targetPos, class_1937 world) {
        if (world.method_8320(startPos).method_26164(class_3481.field_15467)) {
            startPos = startPos.method_10069(0, 1, 0);
        }
        if (world.method_8320(targetPos).method_26164(class_3481.field_15467)) {
            targetPos = targetPos.method_10069(0, 1, 0);
        }
        if (!BbPathfinding.validPosition(targetPos, world)) {
            return null;
        }
        PriorityQueue<class_2338> openSet = new PriorityQueue<class_2338>();
        openSet.add(startPos);
        HashMap<class_2338, class_2338> cameFrom = new HashMap<class_2338, class_2338>();
        while (!openSet.isEmpty()) {
            class_2338 currentPos = (class_2338)openSet.poll();
            if (currentPos.equals((Object)targetPos)) {
                return BbPathfinding.reconstructPath(cameFrom, currentPos);
            }
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    boolean validNeighbour;
                    class_2338 neighbourPos = currentPos.method_10069(xo, 0, zo);
                    if (cameFrom.containsKey(neighbourPos) || neighbourPos.equals((Object)startPos) || !(validNeighbour = BbPathfinding.validPosition(neighbourPos, world))) continue;
                    cameFrom.put(neighbourPos, currentPos);
                    if (openSet.contains(neighbourPos)) continue;
                    openSet.add(neighbourPos);
                }
            }
        }
        return null;
    }

    private static List<class_2338> reconstructPath(Map<class_2338, class_2338> cameFrom, class_2338 pos) {
        ArrayList<class_2338> path;
        block1: {
            path = new ArrayList<class_2338>();
            do {
                path.add(pos);
                if (!cameFrom.containsKey(pos)) break block1;
            } while (!path.contains(pos = cameFrom.get(pos)));
            throw new RuntimeException("Path messed up");
        }
        return path.reversed();
    }

    private static boolean validPosition(class_2338 blockPos, class_1937 world) {
        return BbPathfinding.validPosition(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), world);
    }

    private static boolean validPosition(int x, int y, int z, class_1937 world) {
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                class_2680 blockStateBelow = world.method_8320(new class_2338(x + xo, y - 1, z + zo));
                class_2680 blockStateAt = world.method_8320(new class_2338(x + xo, y, z + zo));
                if (blockStateBelow.method_26164(class_3481.field_15467) && blockStateAt.method_26164(class_3481.field_51989)) continue;
                return false;
            }
        }
        return true;
    }
}

