/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.basic_nerual_network;

import uk.co.cablepost.bodkin_boats.ai.basic_nerual_network.Neuron;
import uk.co.cablepost.bodkin_boats.ai.basic_nerual_network.NnActivationFunc;
import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.TrainEvToBucket;

public class NeuralNetwork {
    final Neuron[][] layers;
    public double[][] calculatedValues;
    int mutationChanceCompletely = 100;
    int mutationChanceSlight = 25;

    public NeuralNetwork(int inputLayer, int[] hiddenLayers, int outputLayer) {
        int i;
        this.calculatedValues = new double[hiddenLayers.length + 2][];
        this.calculatedValues[0] = new double[inputLayer];
        this.calculatedValues[this.calculatedValues.length - 1] = new double[outputLayer];
        this.layers = new Neuron[hiddenLayers.length + 1][];
        for (i = 0; i < hiddenLayers.length; ++i) {
            this.layers[i] = new Neuron[hiddenLayers[i]];
            this.calculatedValues[i + 1] = new double[hiddenLayers[i]];
        }
        this.layers[hiddenLayers.length] = new Neuron[outputLayer];
        for (i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                double[] weights = i == 0 ? new double[inputLayer] : new double[this.layers[i - 1].length];
                for (int k = 0; k < weights.length; ++k) {
                    weights[k] = TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0;
                }
                this.layers[i][j] = new Neuron(weights, TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0, i == hiddenLayers.length ? NnActivationFunc.Sigmoid : NnActivationFunc.Relu);
            }
        }
    }

    public NeuralNetwork(NeuralNetwork copyFrom) {
        int i;
        this.calculatedValues = new double[copyFrom.calculatedValues.length][];
        for (i = 0; i < this.calculatedValues.length; ++i) {
            this.calculatedValues[i] = new double[copyFrom.calculatedValues[i].length];
        }
        this.layers = new Neuron[copyFrom.layers.length][];
        for (i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Neuron[copyFrom.layers[i].length];
            for (int j = 0; j < this.layers[i].length; ++j) {
                this.layers[i][j] = new Neuron(copyFrom.layers[i][j]);
            }
        }
    }

    public double[] calc(double[] input) {
        this.calculatedValues[0] = input;
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                this.calculatedValues[i + 1][j] = this.layers[i][j].calc(this.calculatedValues[i]);
            }
        }
        return this.calculatedValues[this.calculatedValues.length - 1];
    }

    public void mutate() {
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                for (int k = 0; k < this.layers[i][j].weights.length; ++k) {
                    if (TrainEvToBucket.RANDOM.nextInt(this.mutationChanceCompletely) < 1) {
                        this.layers[i][j].weights[k] = TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0;
                        continue;
                    }
                    if (TrainEvToBucket.RANDOM.nextInt(this.mutationChanceSlight) >= 1) continue;
                    this.layers[i][j].weights[k] = Math.clamp(this.layers[i][j].weights[k] + (TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0) * 0.05, -1.0, 1.0);
                }
                if (TrainEvToBucket.RANDOM.nextInt(this.mutationChanceCompletely) < 1) {
                    this.layers[i][j].bias = TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0;
                    continue;
                }
                if (TrainEvToBucket.RANDOM.nextInt(this.mutationChanceSlight) >= 1) continue;
                this.layers[i][j].bias = Math.clamp(this.layers[i][j].bias + (TrainEvToBucket.RANDOM.nextDouble() * 2.0 - 1.0) * 0.05, -1.0, 1.0);
            }
        }
    }
}

