/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.basic_nerual_network;

import uk.co.cablepost.bodkin_boats.ai.basic_nerual_network.NnActivationFunc;

class Neuron {
    public double[] weights;
    public double bias;
    public NnActivationFunc activationFunc;

    public Neuron(double[] weights, double bias, NnActivationFunc activationFunc) {
        this.weights = weights;
        this.bias = bias;
        this.activationFunc = activationFunc;
    }

    public Neuron(Neuron copyFrom) {
        this.weights = (double[])copyFrom.weights.clone();
        this.bias = copyFrom.bias;
        this.activationFunc = copyFrom.activationFunc;
    }

    public double calc(double[] inputs) {
        double val = 0.0;
        for (int i = 0; i < inputs.length; ++i) {
            val += inputs[i] * this.weights[i];
        }
        val -= this.bias;
        if (this.activationFunc == NnActivationFunc.Relu) {
            if (val < 0.0) {
                val = 0.0;
            }
            return val;
        }
        if (this.activationFunc == NnActivationFunc.Sigmoid) {
            if (val < -10.0) {
                return 0.0;
            }
            if (val > 10.0) {
                return 1.0;
            }
            return 1.0 / (1.0 + Math.exp(-val));
        }
        throw new RuntimeException("Unknown activation func: " + String.valueOf((Object)this.activationFunc));
    }
}

