/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.BucketHelper;
import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.BucketValue;
import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.State;
import uk.co.cablepost.bodkin_boats.mixin.BoatEntityAccess;

public class UseEvToBucket {
    private static final Gson GSON = new Gson();
    public static final BucketValue[] BUCKETS = UseEvToBucket.loadTrainingData();

    public static State getStateOfBoat(class_1690 boatEntity, class_243 waypoint) {
        double rotationRadians = Math.toRadians(boatEntity.method_36454());
        double fx = Math.cos(rotationRadians);
        double fy = Math.sin(rotationRadians);
        double length = Math.hypot(waypoint.field_1352 - boatEntity.method_23317(), waypoint.field_1350 - boatEntity.method_23321());
        float angleToWaypoint = 0.0f;
        if (length > 0.0) {
            double dx = waypoint.field_1352 - boatEntity.method_23317();
            double dy = waypoint.field_1350 - boatEntity.method_23321();
            double dot = fx * (dx /= length) + fy * (dy /= length);
            double cross = fx * dy - fy * dx;
            angleToWaypoint = (float)Math.atan2(cross, dot);
            angleToWaypoint -= 1.5707964f;
            while ((double)angleToWaypoint < -Math.PI) {
                angleToWaypoint += (float)Math.PI * 2;
            }
            while ((double)angleToWaypoint > Math.PI) {
                angleToWaypoint -= (float)Math.PI * 2;
            }
        }
        double cos = Math.cos(-rotationRadians);
        double sin = Math.sin(-rotationRadians);
        class_243 velocity = boatEntity.method_18798();
        float localVelX = (float)(velocity.field_1352 * cos - velocity.field_1350 * sin);
        float localVelY = (float)(velocity.field_1352 * sin + velocity.field_1350 * cos);
        return new State((float)length, angleToWaypoint, localVelX, localVelY, (float)Math.toRadians(((BoatEntityAccess)boatEntity).getYawVelocity()));
    }

    public static boolean[] getAction(class_1690 boatEntity, class_243 waypoint) {
        State state = UseEvToBucket.getStateOfBoat(boatEntity, waypoint);
        if (state.velYaw() > 2.0f) {
            return new boolean[]{true, true, true, false};
        }
        if (state.velYaw() < -2.0f) {
            return new boolean[]{true, true, false, true};
        }
        int bucketIndex = BucketHelper.getBucketIndexForState(state);
        if (BUCKETS == null || bucketIndex >= BUCKETS.length || BUCKETS[bucketIndex] == null) {
            return new boolean[]{true, false, false, false};
        }
        return BUCKETS[bucketIndex].action();
    }

    public static BucketValue[] loadTrainingData() {
        BucketValue[] bucketValueArray;
        File folder = new File(Paths.get("train_ev_to_bucket_data", new String[0]).toAbsolutePath().toString());
        File file = new File(folder, "2025-08-13_21.10.51.json");
        if (!file.exists()) {
            return null;
        }
        FileReader reader = new FileReader(file);
        try {
            Type type = new TypeToken<BucketValue[]>(){}.getType();
            bucketValueArray = (BucketValue[])GSON.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Error reading file: " + file.getAbsolutePath());
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return bucketValueArray;
    }
}

