/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.world_data;

import net.minecraft.class_10;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import uk.co.cablepost.bodkin_boats.ai.world_data.IWGetWorldDataView;

public class GetWorldData {
    public static float raycast01(IWGetWorldDataView iwGetWorldDataView, class_2338 blockPos, float rotation, int maxDis) {
        int dis = GetWorldData.raycast(iwGetWorldDataView, blockPos, rotation, maxDis);
        return 1.0f - (float)dis / (float)maxDis;
    }

    public static int raycast(IWGetWorldDataView iwGetWorldDataView, class_2338 blockPos, float rotation, int maxDis) {
        for (int i = 0; i <= maxDis; ++i) {
            float slip = GetWorldData.slipAtRelativePosition(iwGetWorldDataView, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), rotation, 0, -i);
            if (!(slip < 0.7f)) continue;
            return i;
        }
        return maxDis;
    }

    public static float[][] getMinimap(IWGetWorldDataView iwGetWorldDataView, class_2338 blockPos, float rotation, int radius, int skipBlocks) {
        float[][] minimap = new float[radius * 2 + 1][radius * 2 + 1];
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                minimap[x + radius][z + radius] = GetWorldData.slipAtRelativePosition(iwGetWorldDataView, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), rotation, x * (skipBlocks + 1), z * (skipBlocks + 1));
            }
        }
        return minimap;
    }

    private static float slipAtRelativePosition(IWGetWorldDataView iwGetWorldDataView, double posX, int blockY, double posZ, double bodyYaw, int relativeX, int relativeZ) {
        double rot = Math.toRadians(-bodyYaw + 180.0);
        class_2338 pos = new class_2338((int)Math.round(posX += Math.cos(rot) * (double)relativeX + Math.sin(rot) * (double)relativeZ), blockY - 1, (int)Math.round(posZ += Math.sin(rot) * (double)(-relativeX) + Math.cos(rot) * (double)relativeZ));
        return iwGetWorldDataView.getBlockSlip(pos);
    }

    public static float getBlockSlipValue(class_1937 world, class_2338 pos) {
        if (GetWorldData.isAir(world, pos.method_10069(0, 1, 0)) && !GetWorldData.isAir(world, pos.method_10069(0, 0, 0))) {
            return GetWorldData.mapSlipperinessValues(world.method_8320(pos).method_26204().method_9499());
        }
        return 0.0f;
    }

    private static float mapSlipperinessValues(float x) {
        return (float)Math.pow(x, 8.0);
    }

    private static boolean isAir(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_26164(class_3481.field_24076) || blockState.method_26164(class_3481.field_15493) || blockState.method_27852(class_2246.field_10589) || blockState.method_27852(class_2246.field_10167) || blockState.method_27852(class_2246.field_10425) || blockState.method_27852(class_2246.field_10025) || blockState.method_27852(class_2246.field_10546) || blockState.method_27852(class_2246.field_31037) || blockState.method_27852(class_2246.field_10477) && blockState.method_26171(class_10.field_50);
    }
}

