/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.misc;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.commons.net.ntp.TimeStamp;

public class NtpTimeSync {
    private static final String SERVER_NAME = "pool.ntp.org";
    private static volatile Long offset = 0L;

    public static void init() throws Exception {
        for (int i = 1; i <= 5; ++i) {
            try {
                System.out.println("Attempt " + i + " at getting time from NTP server");
                NTPUDPClient client = new NTPUDPClient();
                client.setDefaultTimeout(10000);
                InetAddress inetAddress = InetAddress.getByName(SERVER_NAME);
                TimeInfo timeInfo = client.getTime(inetAddress);
                timeInfo.computeDetails();
                if (timeInfo.getOffset() != null) {
                    offset = timeInfo.getOffset();
                } else {
                    System.err.println("[Bodkin Boats NTP Time Sync] Failed to fetch offset. Using system time.");
                    offset = 0L;
                }
                TimeStamp systemNtpTime = TimeStamp.getCurrentTime();
                System.out.println("[Bodkin Boats NTP Time Sync] System time:\t" + String.valueOf(systemNtpTime) + "  " + systemNtpTime.toDateString());
                long currentTime = System.currentTimeMillis();
                TimeStamp atomicNtpTime = TimeStamp.getNtpTime((long)(currentTime + offset));
                System.out.println("[Bodkin Boats NTP Time Sync] Atomic time:\t" + String.valueOf(atomicNtpTime) + "  " + atomicNtpTime.toDateString());
                System.out.println("[Bodkin Boats NTP Time Sync] Offset:\t" + offset + "ms");
                return;
            }
            catch (Exception e) {
                System.out.println("[Bodkin Boats NTP Time Sync] Failed to get time from NTP server");
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
        }
        throw new RuntimeException("[Bodkin Boats NTP Time Sync] Failed to get time from NTP server on all attempts");
    }

    public static long getTrueTime() {
        return System.currentTimeMillis() + offset;
    }
}

