/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.music;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1545;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.entities.fireball_power_up.FireballPowerUpEntity;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.music.MusicLoopTypes;
import uk.co.cablepost.bodkin_boats.music.MusicSoundInstance;
import uk.co.cablepost.bodkin_boats.track.BbRacingScoreboard;
import uk.co.cablepost.bodkin_boats.track.ClientCheckpointTracker;
import uk.co.cablepost.bodkin_boats.track.LatestCheckpointForPlayer;

public class MusicSystem {
    private static final Map<Integer, Integer> TIME_PER_LOOP = Map.of(1, 3000, 2, 3000, 3, 3000, 4, 6000, 6, 7579, 8, 1, 10, 36571);
    private static final float LAST_LAP_PITCH_SHIFT = 1.2f;
    private static final Map<Integer, Integer> BEATS_PER_LOOP = Map.of(1, 4, 2, 4, 3, 4, 4, 16, 6, 24, 8, 32, 10, 64);
    public static int set = 1;
    private static long timeSinceLastLoop = 0L;
    private static long timeSinceLastBeat = 0L;
    private static int loopCounter = 0;
    private static int lap = 0;
    private static boolean lastLap = false;
    private static boolean finishedRace = false;
    public static MusicLoopTypes LAST_SECTION = MusicLoopTypes.Fireball;
    public static boolean queuedRandomPowerUpDecideSound = false;
    public static List<MusicSoundInstance> MUSIC_SOUND_INSTANCES = new ArrayList<MusicSoundInstance>();
    private static class_3414 SET_1_LOOP_1;
    private static class_3414 SET_1_LOOP_2;
    private static class_3414 SET_1_LOOP_3;
    private static class_3414 SET_1_LOOP_4;
    private static class_3414 SET_1_LOOP_5;
    private static class_3414 SET_1_LOOP_6;
    private static class_3414 SET_1_LOOP_7;
    private static class_3414 SET_1_LOOP_8;
    private static class_3414 SET_2_LOOP_1;
    private static final class_3414[] SET_3;
    private static final class_3414[] SET_4;
    private static class_3414 SET_6_SWING_BASE;
    private static class_3414 SET_6_KICKER;
    private static class_3414 SET_6_SPACE_FILLER_A;
    private static class_3414 SET_6_SPACE_FILLER_B;
    private static class_3414 SET_6_SPACE_FILLER_C;
    private static class_3414 SET_6_LEAD_A;
    private static class_3414 SET_6_LEAD_A_ENDING;
    private static class_3414 SET_6_LEAD_B;
    private static class_3414 SET_6_LEAD_B_ENDING;
    private static class_3414 SET_6_LEAD_C;
    private static class_3414 SET_6_LEAD_C_ENDING;
    private static class_3414 SET_8_INTRO;
    private static class_3414 SET_8_LAP_1_PART_1;
    private static class_3414 SET_8_LAP_1_PART_2;
    private static class_3414 SET_8_LAP_1_PART_3;
    private static class_3414 SET_8_LAP_1_PART_4;
    private static class_3414 SET_8_LAP_2_PART_1;
    private static class_3414 SET_8_LAP_2_PART_2;
    private static class_3414 SET_8_LAP_2_PART_3;
    private static class_3414 SET_8_LAP_2_PART_4;
    private static class_3414 SET_8_LAP_3_PART_1;
    private static class_3414 SET_8_LAP_3_PART_2;
    private static class_3414 SET_8_LAP_3_PART_3;
    private static class_3414 SET_8_LAP_3_PART_4;
    private static class_3414 SET_8_LAP_4_PART_1;
    private static class_3414 SET_8_LAP_4_PART_2;
    private static class_3414 SET_8_LAP_4_PART_3;
    private static class_3414 SET_8_LAP_4_PART_4;
    private static class_3414 SET_8_LAP_5_PART_1;
    private static class_3414 SET_8_LAP_5_PART_2;
    private static class_3414 SET_8_LAP_5_PART_3;
    private static class_3414 SET_8_LAP_5_PART_4;
    private static class_3414 SET_8_LAP_6_PART_1;
    private static class_3414 SET_8_LAP_6_PART_2;
    private static class_3414 SET_8_LAP_6_PART_3;
    private static class_3414 SET_8_LAP_6_PART_4;
    private static class_3414 SET_10_LOOP_A;
    private static class_3414 SET_10_LOOP_B;
    private static class_3414 SET_10_LOOP_C;

    private static int getTimePerLoop() {
        if (set == 8) {
            if (lap == 0 || lap == 1) {
                return 2182;
            }
            if (lap == 2) {
                return 2000;
            }
            if (lap == 3) {
                return 1714;
            }
            if (lap == 4) {
                return 1548;
            }
            if (lap == 5) {
                return 1412;
            }
            return 1200;
        }
        int timePerLoop = TIME_PER_LOOP.get(set);
        if (lastLap) {
            timePerLoop = (int)((float)timePerLoop / 1.2f);
        }
        return timePerLoop;
    }

    private static float getPitch() {
        if (set == 8) {
            return 1.0f;
        }
        if (lastLap) {
            return 1.2f;
        }
        return 1.0f;
    }

    public static void init() {
        int i;
        SET_1_LOOP_1 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_1"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_1")));
        SET_1_LOOP_2 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_2"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_2")));
        SET_1_LOOP_3 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_3"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_3")));
        SET_1_LOOP_4 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_4"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_4")));
        SET_1_LOOP_5 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_5"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_5")));
        SET_1_LOOP_6 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_6"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_6")));
        SET_1_LOOP_7 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_7"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_7")));
        SET_1_LOOP_8 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_8"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_1_loop_8")));
        SET_2_LOOP_1 = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_2_loop_1"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_2_loop_1")));
        for (i = 0; i < SET_3.length; ++i) {
            MusicSystem.SET_3[i] = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)("set_3_loop_" + (i + 1))), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)("set_3_loop_" + (i + 1)))));
        }
        for (i = 0; i < SET_4.length; ++i) {
            MusicSystem.SET_4[i] = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)("set_4_loop_" + (i + 1))), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)("set_4_loop_" + (i + 1)))));
        }
        SET_6_SWING_BASE = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_swing_base"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_swing_base")));
        SET_6_KICKER = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_kicker"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_kicker")));
        SET_6_SPACE_FILLER_A = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_a"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_a")));
        SET_6_SPACE_FILLER_B = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_b"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_b")));
        SET_6_SPACE_FILLER_C = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_c"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_space_filler_c")));
        SET_6_LEAD_A = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_a"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_a")));
        SET_6_LEAD_A_ENDING = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_a_ending"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_a_ending")));
        SET_6_LEAD_B = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_b"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_b")));
        SET_6_LEAD_B_ENDING = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_b_ending"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_b_ending")));
        SET_6_LEAD_C = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_c"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_c")));
        SET_6_LEAD_C_ENDING = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_c_ending"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_6_lead_c_ending")));
        SET_8_INTRO = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_8_intro"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_8_intro")));
        SET_8_LAP_1_PART_1 = MusicSystem.registerSoundEvent("set_8_l1_p1");
        SET_8_LAP_1_PART_2 = MusicSystem.registerSoundEvent("set_8_l1_p2");
        SET_8_LAP_1_PART_3 = MusicSystem.registerSoundEvent("set_8_l1_p3");
        SET_8_LAP_1_PART_4 = MusicSystem.registerSoundEvent("set_8_l1_p4");
        SET_8_LAP_2_PART_1 = MusicSystem.registerSoundEvent("set_8_l2_p1");
        SET_8_LAP_2_PART_2 = MusicSystem.registerSoundEvent("set_8_l2_p2");
        SET_8_LAP_2_PART_3 = MusicSystem.registerSoundEvent("set_8_l2_p3");
        SET_8_LAP_2_PART_4 = MusicSystem.registerSoundEvent("set_8_l2_p4");
        SET_8_LAP_3_PART_1 = MusicSystem.registerSoundEvent("set_8_l3_p1");
        SET_8_LAP_3_PART_2 = MusicSystem.registerSoundEvent("set_8_l3_p2");
        SET_8_LAP_3_PART_3 = MusicSystem.registerSoundEvent("set_8_l3_p3");
        SET_8_LAP_3_PART_4 = MusicSystem.registerSoundEvent("set_8_l3_p4");
        SET_8_LAP_4_PART_1 = MusicSystem.registerSoundEvent("set_8_l4_p1");
        SET_8_LAP_4_PART_2 = MusicSystem.registerSoundEvent("set_8_l4_p2");
        SET_8_LAP_4_PART_3 = MusicSystem.registerSoundEvent("set_8_l4_p3");
        SET_8_LAP_4_PART_4 = MusicSystem.registerSoundEvent("set_8_l4_p4");
        SET_8_LAP_5_PART_1 = MusicSystem.registerSoundEvent("set_8_l5_p1");
        SET_8_LAP_5_PART_2 = MusicSystem.registerSoundEvent("set_8_l5_p2");
        SET_8_LAP_5_PART_3 = MusicSystem.registerSoundEvent("set_8_l5_p3");
        SET_8_LAP_5_PART_4 = MusicSystem.registerSoundEvent("set_8_l5_p4");
        SET_8_LAP_6_PART_1 = MusicSystem.registerSoundEvent("set_8_l6_p1");
        SET_8_LAP_6_PART_2 = MusicSystem.registerSoundEvent("set_8_l6_p2");
        SET_8_LAP_6_PART_3 = MusicSystem.registerSoundEvent("set_8_l6_p3");
        SET_8_LAP_6_PART_4 = MusicSystem.registerSoundEvent("set_8_l6_p4");
        SET_10_LOOP_A = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_a"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_a")));
        SET_10_LOOP_B = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_b"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_b")));
        SET_10_LOOP_C = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_c"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"set_10_loop_c")));
    }

    private static class_3414 registerSoundEvent(String name) {
        class_2960 id = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)name);
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
    }

    public static void playAllSoundsInSetVeryQuiet() {
        if (set == 6) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_SWING_BASE, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_KICKER, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_SPACE_FILLER_A, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_SPACE_FILLER_B, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_SPACE_FILLER_C, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_A, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_A_ENDING, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_B, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_B_ENDING, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_C, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_6_LEAD_C_ENDING, (float)1.0f, (float)0.001f));
        }
        if (set == 8) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_1_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_1_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_1_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_1_PART_4, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_2_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_2_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_2_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_2_PART_4, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_3_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_3_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_3_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_3_PART_4, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_4_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_4_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_4_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_4_PART_4, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_5_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_5_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_5_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_5_PART_4, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_6_PART_1, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_6_PART_2, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_6_PART_3, (float)1.0f, (float)0.001f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)SET_8_LAP_6_PART_4, (float)1.0f, (float)0.001f));
        }
    }

    public static void update(int raceState, @NotNull class_638 clientWorld, @NotNull class_746 player) {
        if (raceState != 0) {
            timeSinceLastLoop = 0L;
            timeSinceLastBeat = 0L;
            loopCounter = 0;
            lastLap = false;
            lap = 0;
            finishedRace = false;
            MusicSystem.doQueuedSounds(player);
            return;
        }
        long now = NtpTimeSync.getTrueTime();
        if (!TIME_PER_LOOP.containsKey(set)) {
            return;
        }
        if (now - timeSinceLastLoop > (long)MusicSystem.getTimePerLoop()) {
            timeSinceLastLoop = now;
            timeSinceLastBeat = now;
            MusicSystem.doQueuedSounds(player);
            MusicSystem.doLoop(raceState, clientWorld, player);
            MusicSystem.doBeat(clientWorld, player, true);
            ++loopCounter;
        } else if ((float)(now - timeSinceLastBeat) > (float)MusicSystem.getTimePerLoop() / (float)BEATS_PER_LOOP.get(set).intValue()) {
            timeSinceLastBeat = now;
            MusicSystem.doQueuedSounds(player);
            MusicSystem.doBeat(clientWorld, player, false);
        }
    }

    private static void doLoop(int raceState, @NotNull class_638 clientWorld, @NotNull class_746 player) {
        MUSIC_SOUND_INSTANCES.clear();
        if (raceState == 0) {
            Optional<LatestCheckpointForPlayer> mostRecentCheckpointForSelf = BbRacingScoreboard.getLatestCheckpointForSelf();
            mostRecentCheckpointForSelf.ifPresent(latestCheckpointForPlayer -> {
                lap = latestCheckpointForPlayer.lap;
            });
            if (!lastLap && BodkinBoatsClient.MAX_LAPS > 1 && mostRecentCheckpointForSelf.isPresent() && lap == BodkinBoatsClient.MAX_LAPS) {
                lastLap = true;
                player.method_43496(class_2561.method_30163((String)"Final lap!"));
            } else if (lastLap && mostRecentCheckpointForSelf.isPresent() && mostRecentCheckpointForSelf.get().lap > BodkinBoatsClient.MAX_LAPS) {
                finishedRace = true;
            }
        }
        if (finishedRace) {
            return;
        }
        boolean isEveryOtherLoop = loopCounter % 2 == 0;
        boolean isEveryForthLoop = loopCounter % 4 == 0;
        boolean isEveryEighthLoop = loopCounter % 8 == 0;
        boolean isEverySixteenthLoop = loopCounter % 16 == 0;
        boolean gotBlaze = player.method_6059(BodkinBoats.INVERSION_EFFECT);
        boolean gotShieldOrGhost = player.method_6059(BodkinBoats.SHIELD_EFFECT) || player.method_6059(BodkinBoats.GHOST_EFFECT);
        boolean isWarping = player.method_6059(BodkinBoats.WARP_EFFECT);
        List<class_1657> otherPlayers = MusicSystem.getPlayerEntitiesForMusic(clientWorld, player);
        List<class_1545> blazes = MusicSystem.getBlazesForMusic(clientWorld);
        List<FireballPowerUpEntity> fireballs = MusicSystem.getFireballsForMusic(clientWorld);
        if (set == 1) {
            if (isEveryForthLoop) {
                MusicSystem.playOnEntity((class_1297)player, SET_1_LOOP_8, 0.3f);
            } else {
                MusicSystem.playOnEntity((class_1297)player, SET_1_LOOP_1, 0.3f);
            }
            if (gotBlaze) {
                MusicSystem.playOnEntity((class_1297)player, SET_1_LOOP_3, 1.5f);
                MusicSystem.playOnEntity((class_1297)player, SET_1_LOOP_4, 1.6f);
            }
            if (gotShieldOrGhost) {
                MusicSystem.playOnEntity((class_1297)player, SET_1_LOOP_2, 1.5f);
            }
            for (class_1657 otherPlayer : otherPlayers) {
                if (isEveryOtherLoop) {
                    MusicSystem.playOnEntity((class_1297)otherPlayer, SET_1_LOOP_2, 1.5f);
                    continue;
                }
                MusicSystem.playOnEntity((class_1297)otherPlayer, SET_1_LOOP_7, 1.5f);
            }
            if (!gotBlaze) {
                for (class_1545 blaze : blazes) {
                    MusicSystem.playOnEntity((class_1297)blaze, SET_1_LOOP_3, 1.5f);
                    if (isEveryEighthLoop) {
                        MusicSystem.playOnEntity((class_1297)blaze, SET_1_LOOP_4, 1.6f);
                        continue;
                    }
                    if (!isEveryForthLoop) continue;
                    MusicSystem.playOnEntity((class_1297)blaze, SET_1_LOOP_5, 1.6f);
                }
            }
            for (FireballPowerUpEntity fireball : fireballs) {
                MusicSystem.playOnEntity(fireball, SET_1_LOOP_2, 1.5f);
                MusicSystem.playOnEntity(fireball, SET_1_LOOP_6, 2.0f);
            }
        } else if (set == 2) {
            for (class_1657 otherPlayer : otherPlayers) {
                MusicSystem.playOnEntity((class_1297)otherPlayer, SET_2_LOOP_1, 1.5f);
            }
        } else if (set == 3) {
            for (class_1657 otherPlayer : otherPlayers) {
                MusicSystem.playOnEntity((class_1297)otherPlayer, SET_3[9], 1.0f);
            }
            if (gotShieldOrGhost) {
                MusicSystem.playOnEntity((class_1297)player, SET_3[11], 1.0f);
            }
            if (gotBlaze) {
                MusicSystem.playOnEntity((class_1297)player, SET_3[10], 1.0f);
            }
            if (isWarping) {
                MusicSystem.playOnEntity((class_1297)player, SET_3[12], 1.0f);
            }
            for (FireballPowerUpEntity fireball : fireballs) {
                MusicSystem.playOnEntity(fireball, SET_3[10], 1.0f);
            }
            for (class_1545 blaze : blazes) {
                MusicSystem.playOnEntity((class_1297)blaze, SET_3[10], 1.0f);
            }
            if (isEveryOtherLoop) {
                MusicSystem.playOnEntity((class_1297)player, SET_3[0], 1.0f);
                MusicSystem.playOnEntity((class_1297)player, SET_3[1], 1.0f);
                for (class_1657 otherPlayer : otherPlayers) {
                    MusicSystem.playOnEntity((class_1297)otherPlayer, SET_3[2], 1.0f);
                    if (isEveryForthLoop) {
                        MusicSystem.playOnEntity((class_1297)otherPlayer, SET_3[5], 1.0f);
                    }
                    if (!isEveryEighthLoop) continue;
                    MusicSystem.playOnEntity((class_1297)otherPlayer, SET_3[8], 1.0f);
                }
                for (FireballPowerUpEntity fireball : fireballs) {
                    MusicSystem.playOnEntity(fireball, SET_3[3], 1.0f);
                    if (!isEveryForthLoop) continue;
                    MusicSystem.playOnEntity(fireball, SET_3[7], 1.0f);
                }
                for (class_1545 blaze : blazes) {
                    MusicSystem.playOnEntity((class_1297)blaze, SET_3[4], 1.0f);
                    if (!isEveryForthLoop) continue;
                    MusicSystem.playOnEntity((class_1297)blaze, SET_3[6], 1.0f);
                }
            }
        } else if (set == 4) {
            class Set4 {
                Set4() {
                }

                public static int getLoop(int instrument, int stage) {
                    return (instrument - 1) * 4 + stage - 1;
                }
            }
            int i;
            int stage;
            if (loopCounter % 16 == 0 || loopCounter % 16 == 2 || loopCounter % 16 == 4 || loopCounter % 16 == 6) {
                stage = 1;
            } else if (loopCounter % 16 == 1 || loopCounter % 16 == 3 || loopCounter % 16 == 5 || loopCounter % 16 == 7) {
                stage = 2;
            } else if (loopCounter % 16 == 8 || loopCounter % 16 == 10 || loopCounter % 16 == 12 || loopCounter % 16 == 14) {
                stage = 3;
            } else if (loopCounter % 16 == 9 || loopCounter % 16 == 11 || loopCounter % 16 == 13 || loopCounter % 16 == 15) {
                stage = 4;
            } else {
                System.out.println("[Set 4] tried to calculate invalid stage");
                stage = 1;
            }
            if (stage == 1 || stage == 3) {
                MusicSystem.playOnEntity((class_1297)player, SET_4[24], 0.5f);
            } else {
                MusicSystem.playOnEntity((class_1297)player, SET_4[25], 0.5f);
            }
            if (loopCounter > 4) {
                MusicSystem.playOnEntity((class_1297)player, SET_4[Set4.getLoop(6, stage)], 0.8f);
            }
            for (i = 0; i < otherPlayers.size(); ++i) {
                MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[Set4.getLoop(1, stage)], MusicLoopTypes.OtherPlayer, 1.5f, MusicSystem.getPitch()));
            }
            for (i = 0; i < 20; ++i) {
                MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[Set4.getLoop(2, stage)], MusicLoopTypes.Blaze, 1.5f, MusicSystem.getPitch()));
                MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[28], MusicLoopTypes.Fireball, 1.5f, MusicSystem.getPitch()));
            }
            MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[Set4.getLoop(3, stage)], MusicLoopTypes.AttachedBlaze, 4.0f, MusicSystem.getPitch()));
            MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[Set4.getLoop(4, stage)], MusicLoopTypes.AttachedShield, 4.0f, MusicSystem.getPitch()));
            MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_4[Set4.getLoop(5, stage)], MusicLoopTypes.AttachedWarp, 4.0f, MusicSystem.getPitch()));
            for (MusicSoundInstance musicSoundInstance : MUSIC_SOUND_INSTANCES) {
                class_310.method_1551().method_1483().method_4873((class_1113)musicSoundInstance);
            }
            if (gotBlaze) {
                MusicSystem.playOnEntity((class_1297)player, SET_4[Set4.getLoop(3, stage)], 4.0f);
            }
            if (gotShieldOrGhost) {
                MusicSystem.playOnEntity((class_1297)player, SET_4[Set4.getLoop(4, stage)], 4.0f);
            }
            if (isWarping) {
                MusicSystem.playOnEntity((class_1297)player, SET_4[Set4.getLoop(5, stage)], 1.8f);
            }
        } else if (set == 6) {
            MusicSystem.playOnEntity((class_1297)player, SET_6_KICKER, 1.0f);
            MusicSystem.playOnEntity((class_1297)player, SET_6_SWING_BASE, 1.0f);
            if (loopCounter % 8 == 0 || loopCounter % 8 == 4) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_A, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_A, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            } else if (loopCounter % 8 == 1 || loopCounter % 8 == 5) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_A_ENDING, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_A, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            } else if (loopCounter % 8 == 2) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_B, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_B, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            } else if (loopCounter % 8 == 3) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_B_ENDING, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_B, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            } else if (loopCounter % 8 == 6) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_C, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_C, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            } else if (loopCounter % 8 == 7) {
                MusicSystem.playOnEntity((class_1297)player, SET_6_LEAD_C_ENDING, 1.0f);
                for (int i = 0; i < otherPlayers.size(); ++i) {
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_6_SPACE_FILLER_C, MusicLoopTypes.OtherPlayer, 3.0f, MusicSystem.getPitch()));
                }
            }
        } else if (set == 8) {
            if (lap == 0 || lap == 1) {
                if (loopCounter % 4 == 0) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_1_PART_1, 1.0f);
                } else if (loopCounter % 4 == 1) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_1_PART_2, 1.0f);
                } else if (loopCounter % 4 == 2) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_1_PART_3, 1.0f);
                } else {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_1_PART_4, 1.0f);
                }
            } else if (lap == 2) {
                if (loopCounter % 4 == 0) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_2_PART_1, 1.0f);
                } else if (loopCounter % 4 == 1) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_2_PART_2, 1.0f);
                } else if (loopCounter % 4 == 2) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_2_PART_3, 1.0f);
                } else {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_2_PART_4, 1.0f);
                }
            } else if (lap == 3) {
                if (loopCounter % 4 == 0) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_3_PART_1, 1.0f);
                } else if (loopCounter % 4 == 1) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_3_PART_2, 1.0f);
                } else if (loopCounter % 4 == 2) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_3_PART_3, 1.0f);
                } else {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_3_PART_4, 1.0f);
                }
            } else if (lap == 4) {
                if (loopCounter % 4 == 0) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_4_PART_1, 1.0f);
                } else if (loopCounter % 4 == 1) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_4_PART_2, 1.0f);
                } else if (loopCounter % 4 == 2) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_4_PART_3, 1.0f);
                } else {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_4_PART_4, 1.0f);
                }
            } else if (lap == 5) {
                if (loopCounter % 4 == 0) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_5_PART_1, 1.0f);
                } else if (loopCounter % 4 == 1) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_5_PART_2, 1.0f);
                } else if (loopCounter % 4 == 2) {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_5_PART_3, 1.0f);
                } else {
                    MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_5_PART_4, 1.0f);
                }
            } else if (loopCounter % 4 == 0) {
                MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_6_PART_1, 1.0f);
            } else if (loopCounter % 4 == 1) {
                MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_6_PART_2, 1.0f);
            } else if (loopCounter % 4 == 2) {
                MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_6_PART_3, 1.0f);
            } else {
                MusicSystem.playOnEntity((class_1297)player, SET_8_LAP_6_PART_4, 1.0f);
            }
        } else if (set == 10) {
            // empty if block
        }
        for (MusicSoundInstance musicSoundInstance : MUSIC_SOUND_INSTANCES) {
            class_310.method_1551().method_1483().method_4873((class_1113)musicSoundInstance);
        }
    }

    private static void doBeat(@NotNull class_638 clientWorld, @NotNull class_746 player, boolean startOfNewLoop) {
        if (finishedRace) {
            return;
        }
        List<class_1657> otherPlayers = MusicSystem.getPlayerEntitiesForMusic(clientWorld, player);
        List<class_1545> blazes = MusicSystem.getBlazesForMusic(clientWorld);
        List<FireballPowerUpEntity> fireballs = MusicSystem.getFireballsForMusic(clientWorld);
        boolean gotBlaze = player.method_6059(BodkinBoats.INVERSION_EFFECT);
        boolean gotShieldOrGhost = player.method_6059(BodkinBoats.SHIELD_EFFECT) || player.method_6059(BodkinBoats.GHOST_EFFECT);
        boolean isWarping = player.method_6059(BodkinBoats.WARP_EFFECT);
        if (set == 4) {
            for (class_1657 otherPlayer : otherPlayers) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)otherPlayer, MusicLoopTypes.OtherPlayer);
            }
            for (class_1545 blaze : blazes) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)blaze, MusicLoopTypes.Blaze);
            }
            for (FireballPowerUpEntity fireball : fireballs) {
                MusicSystem.attachToEntityIfNotAlready(fireball, MusicLoopTypes.Fireball);
            }
            if (gotBlaze) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.AttachedWarp);
            } else {
                MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.AttachedWarp);
            }
            if (gotShieldOrGhost) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.AttachedShield);
            } else {
                MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.AttachedShield);
            }
            if (isWarping) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.AttachedWarp);
            } else {
                MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.AttachedWarp);
            }
        } else if (set == 6) {
            for (class_1657 otherPlayer : otherPlayers) {
                MusicSystem.attachToEntityIfNotAlready((class_1297)otherPlayer, MusicLoopTypes.OtherPlayer);
            }
        } else if (set == 10) {
            boolean switchingSection;
            MusicLoopTypes section = LAST_SECTION;
            MusicLoopTypes newSection = ClientCheckpointTracker.lastCheckpointIndex < 3 ? MusicLoopTypes.SectionA : (ClientCheckpointTracker.lastCheckpointIndex < 4 ? MusicLoopTypes.SectionB : (ClientCheckpointTracker.lastCheckpointIndex < 9 ? MusicLoopTypes.SectionC : (ClientCheckpointTracker.lastCheckpointIndex < 10 ? MusicLoopTypes.SectionB : MusicLoopTypes.SectionA)));
            boolean bl = switchingSection = newSection != section && BodkinBoatsClient.BOAT_ON_GROUND;
            if (switchingSection || startOfNewLoop) {
                if (switchingSection) {
                    LAST_SECTION = section = newSection;
                }
                timeSinceLastLoop = NtpTimeSync.getTrueTime();
                if (section == MusicLoopTypes.SectionA) {
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionB);
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionC);
                    MUSIC_SOUND_INSTANCES.clear();
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_10_LOOP_A, MusicLoopTypes.SectionA, 1.0f, MusicSystem.getPitch()));
                    for (MusicSoundInstance musicSoundInstance : MUSIC_SOUND_INSTANCES) {
                        class_310.method_1551().method_1483().method_4873((class_1113)musicSoundInstance);
                    }
                    MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.SectionA);
                } else if (section == MusicLoopTypes.SectionB) {
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionA);
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionC);
                    MUSIC_SOUND_INSTANCES.clear();
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_10_LOOP_B, MusicLoopTypes.SectionB, 1.0f, MusicSystem.getPitch()));
                    for (MusicSoundInstance musicSoundInstance : MUSIC_SOUND_INSTANCES) {
                        class_310.method_1551().method_1483().method_4873((class_1113)musicSoundInstance);
                    }
                    MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.SectionB);
                } else {
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionA);
                    MusicSystem.detachAllOfType((class_1297)player, MusicLoopTypes.SectionB);
                    MUSIC_SOUND_INSTANCES.clear();
                    MUSIC_SOUND_INSTANCES.add(new MusicSoundInstance(SET_10_LOOP_C, MusicLoopTypes.SectionC, 1.0f, MusicSystem.getPitch()));
                    for (MusicSoundInstance musicSoundInstance : MUSIC_SOUND_INSTANCES) {
                        class_310.method_1551().method_1483().method_4873((class_1113)musicSoundInstance);
                    }
                    MusicSystem.attachToEntityIfNotAlready((class_1297)player, MusicLoopTypes.SectionC);
                }
            }
        }
    }

    private static void doQueuedSounds(@NotNull class_746 player) {
        if (queuedRandomPowerUpDecideSound) {
            queuedRandomPowerUpDecideSound = false;
            MusicSystem.playSfxOnEntity((class_1297)player, BodkinBoats.QUESTION_MARK_SPIN_END_SOUND, 0.5f);
        }
    }

    private static List<class_1657> getPlayerEntitiesForMusic(@NotNull class_638 clientWorld, @NotNull class_746 player) {
        ArrayList<class_1657> playerEntities = new ArrayList<class_1657>();
        for (class_1297 entity : clientWorld.method_18112()) {
            class_1657 playerEntity;
            if (!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).equals((Object)player) || !(playerEntity.method_5854() instanceof class_1690)) continue;
            playerEntities.add(playerEntity);
        }
        return playerEntities;
    }

    private static List<class_1545> getBlazesForMusic(@NotNull class_638 clientWorld) {
        ArrayList<class_1545> blazeEntities = new ArrayList<class_1545>();
        for (class_1297 entity : clientWorld.method_18112()) {
            if (!(entity instanceof class_1545)) continue;
            class_1545 blazeEntity = (class_1545)entity;
            blazeEntities.add(blazeEntity);
        }
        return blazeEntities;
    }

    private static List<FireballPowerUpEntity> getFireballsForMusic(@NotNull class_638 clientWorld) {
        ArrayList<FireballPowerUpEntity> fireballPowerUpEntities = new ArrayList<FireballPowerUpEntity>();
        for (class_1297 entity : clientWorld.method_18112()) {
            if (!(entity instanceof FireballPowerUpEntity)) continue;
            FireballPowerUpEntity fireballPowerUpEntity = (FireballPowerUpEntity)entity;
            fireballPowerUpEntities.add(fireballPowerUpEntity);
        }
        return fireballPowerUpEntities;
    }

    private static void playOnEntity(class_1297 entity, class_3414 soundEvent, float volume) {
        if (entity.equals((Object)class_310.method_1551().field_1724)) {
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(soundEvent.method_14833(), class_3419.field_15247, volume, MusicSystem.getPitch(), class_1113.method_43221(), false, 0, class_1113.class_1114.field_5476, 0.0, 0.0, 0.0, true));
        } else {
            entity.method_37908().method_43129((class_1657)class_310.method_1551().field_1724, entity, soundEvent, class_3419.field_15247, volume * 3.0f, 1.0f);
        }
    }

    private static void attachToEntityIfNotAlready(class_1297 entity, MusicLoopTypes musicLoopType) {
        if (MUSIC_SOUND_INSTANCES.stream().noneMatch(x -> x.entityId != null && x.entityId.intValue() == entity.method_5628() && x.musicLoopType.equals((Object)musicLoopType))) {
            Optional<MusicSoundInstance> musicSoundInstanceOptional = MUSIC_SOUND_INSTANCES.stream().filter(x -> x.entityId == null && x.musicLoopType.equals((Object)musicLoopType)).findFirst();
            musicSoundInstanceOptional.ifPresent(musicSoundInstance -> {
                musicSoundInstance.entityId = entity.method_5628();
            });
        }
    }

    private static void detachAllOfType(class_1297 entity, MusicLoopTypes musicLoopType) {
        Optional<MusicSoundInstance> musicSoundInstanceOptional = MUSIC_SOUND_INSTANCES.stream().filter(x -> x.entityId != null && x.entityId.intValue() == entity.method_5628() && x.musicLoopType.equals((Object)musicLoopType)).findFirst();
        musicSoundInstanceOptional.ifPresent(musicSoundInstance -> {
            musicSoundInstance.entityId = null;
        });
    }

    private static void playSfxOnEntity(class_1297 entity, class_3414 soundEvent, float volume) {
        entity.method_37908().method_43129((class_1657)class_310.method_1551().field_1724, entity, soundEvent, class_3419.field_15254, volume * 3.0f, MusicSystem.getPitch());
    }

    static {
        SET_3 = new class_3414[13];
        SET_4 = new class_3414[29];
    }
}

