/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.race_results;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import uk.co.cablepost.bodkin_boats.race_results.RaceResultPlayerObject;
import uk.co.cablepost.bodkin_boats.race_results.RaceResultsPhase;
import uk.co.cablepost.bodkin_boats.race_results.SeasonStandingObject;

@Environment(value=EnvType.CLIENT)
public class RaceResultsOverlay {
    public static List<RaceResultPlayerObject> PLAYERS = null;
    public static List<SeasonStandingObject> SEASON_STANDINGS = null;
    private static float TIMER = 0.0f;
    protected static RaceResultsPhase PHASE = RaceResultsPhase.PAYERS_IN;
    private static final class_2960 GUI_SCORE_PLATE_TITLE_TEXTURE = class_2960.method_60655((String)"racing_scoreboard", (String)"textures/gui/score_plate_title.png");
    private static final class_2960 GUI_SCORE_PLATE_TEXTURE = class_2960.method_60655((String)"racing_scoreboard", (String)"textures/gui/score_plate.png");

    public static void render(class_332 context, class_9779 tickDeltaManager, class_746 player) {
        boolean allIn;
        int titleX;
        int TOTAL_WIDTH;
        int PLATE_WIDTH;
        if (PLAYERS == null || PLAYERS.isEmpty() || SEASON_STANDINGS == null || SEASON_STANDINGS.isEmpty()) {
            return;
        }
        int holdTime = 500;
        class_310 client = class_310.method_1551();
        float tickDelta = tickDeltaManager.method_60637(true);
        TIMER += tickDelta;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)context.method_51421() / 2.0f, 12.0f, 0.0f);
        if (PHASE == RaceResultsPhase.PAYERS_IN || PHASE == RaceResultsPhase.PLAYERS_HOLD || PHASE == RaceResultsPhase.PLAYERS_OUT) {
            PLATE_WIDTH = 100;
            TOTAL_WIDTH = PLATE_WIDTH * 5;
            titleX = Math.min(RaceResultsOverlay.PLAYERS.getFirst().x + 105, 0);
            if (PHASE == RaceResultsPhase.PLAYERS_OUT) {
                titleX = RaceResultsOverlay.PLAYERS.getFirst().x + 5;
            }
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2, 0, PLATE_WIDTH, "Name", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2 + PLATE_WIDTH, 0, PLATE_WIDTH, "Grid Pos", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2 + PLATE_WIDTH * 2, 0, PLATE_WIDTH, "Finish Pos", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2 + PLATE_WIDTH * 3, 0, PLATE_WIDTH, "Points", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2 + PLATE_WIDTH * 4, 0, PLATE_WIDTH, "Fastest Lap", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            allIn = true;
            for (RaceResultPlayerObject raceResultPlayerObject : PLAYERS) {
                if (PHASE == RaceResultsPhase.PAYERS_IN) {
                    if (raceResultPlayerObject.x <= -5) {
                        raceResultPlayerObject.x += 5;
                        allIn = false;
                    } else {
                        raceResultPlayerObject.x = 0;
                    }
                } else if (PHASE == RaceResultsPhase.PLAYERS_OUT) {
                    if (raceResultPlayerObject.x <= 1500) {
                        raceResultPlayerObject.x += 5;
                        allIn = false;
                    } else {
                        raceResultPlayerObject.x = 1500;
                    }
                }
                RaceResultsOverlay.renderPlate(context, raceResultPlayerObject.x - TOTAL_WIDTH / 2, raceResultPlayerObject.y, PLATE_WIDTH, raceResultPlayerObject.name, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
                RaceResultsOverlay.renderPlate(context, raceResultPlayerObject.x - TOTAL_WIDTH / 2 + PLATE_WIDTH, raceResultPlayerObject.y, PLATE_WIDTH, raceResultPlayerObject.gridPosition, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
                RaceResultsOverlay.renderPlate(context, raceResultPlayerObject.x - TOTAL_WIDTH / 2 + PLATE_WIDTH * 2, raceResultPlayerObject.y, PLATE_WIDTH, raceResultPlayerObject.finishPosition, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
                RaceResultsOverlay.renderPlate(context, raceResultPlayerObject.x - TOTAL_WIDTH / 2 + PLATE_WIDTH * 3, raceResultPlayerObject.y, PLATE_WIDTH, raceResultPlayerObject.points, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
                RaceResultsOverlay.renderPlate(context, raceResultPlayerObject.x - TOTAL_WIDTH / 2 + PLATE_WIDTH * 4, raceResultPlayerObject.y, PLATE_WIDTH, raceResultPlayerObject.fastestLap, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
            }
            if (PHASE == RaceResultsPhase.PAYERS_IN && allIn) {
                PHASE = RaceResultsPhase.PLAYERS_HOLD;
                TIMER = 0.0f;
            } else if (PHASE == RaceResultsPhase.PLAYERS_HOLD && TIMER > (float)holdTime) {
                PHASE = RaceResultsPhase.PLAYERS_OUT;
                TIMER = 0.0f;
            } else if (PHASE == RaceResultsPhase.PLAYERS_OUT && allIn) {
                PHASE = RaceResultsPhase.STANDINGS_IN;
                TIMER = 0.0f;
            }
        }
        if (PHASE == RaceResultsPhase.STANDINGS_IN || PHASE == RaceResultsPhase.STANDINGS_HOLD || PHASE == RaceResultsPhase.STANDINGS_OUT) {
            PLATE_WIDTH = 120;
            TOTAL_WIDTH = PLATE_WIDTH * 2;
            titleX = Math.min(RaceResultsOverlay.SEASON_STANDINGS.getFirst().x + 105, 0);
            if (PHASE == RaceResultsPhase.STANDINGS_OUT) {
                titleX = RaceResultsOverlay.SEASON_STANDINGS.getFirst().x + 5;
            }
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2, 0, PLATE_WIDTH, "Name", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            RaceResultsOverlay.renderPlate(context, titleX - TOTAL_WIDTH / 2 + PLATE_WIDTH, 0, PLATE_WIDTH, "Points", 0xFFFF00, GUI_SCORE_PLATE_TITLE_TEXTURE);
            allIn = true;
            for (SeasonStandingObject seasonStandingObject : SEASON_STANDINGS) {
                if (PHASE == RaceResultsPhase.STANDINGS_IN) {
                    if (seasonStandingObject.x <= -5) {
                        seasonStandingObject.x += 5;
                        allIn = false;
                    } else {
                        seasonStandingObject.x = 0;
                    }
                } else if (PHASE == RaceResultsPhase.STANDINGS_OUT) {
                    if (seasonStandingObject.x <= 1500) {
                        seasonStandingObject.x += 5;
                        allIn = false;
                    } else {
                        seasonStandingObject.x = 1500;
                    }
                }
                RaceResultsOverlay.renderPlate(context, seasonStandingObject.x - TOTAL_WIDTH / 2, seasonStandingObject.y, PLATE_WIDTH, seasonStandingObject.name, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
                RaceResultsOverlay.renderPlate(context, seasonStandingObject.x - TOTAL_WIDTH / 2 + PLATE_WIDTH, seasonStandingObject.y, PLATE_WIDTH, seasonStandingObject.points, 0xFFFFFF, GUI_SCORE_PLATE_TEXTURE);
            }
            if (PHASE == RaceResultsPhase.STANDINGS_IN && allIn) {
                PHASE = RaceResultsPhase.STANDINGS_HOLD;
                TIMER = 0.0f;
            } else if (PHASE == RaceResultsPhase.STANDINGS_HOLD && TIMER > (float)holdTime) {
                PHASE = RaceResultsPhase.STANDINGS_OUT;
                TIMER = 0.0f;
            } else if (PHASE == RaceResultsPhase.STANDINGS_OUT && allIn) {
                PHASE = RaceResultsPhase.PLAYERS_OUT;
                TIMER = 0.0f;
                PLAYERS = new ArrayList<RaceResultPlayerObject>();
                SEASON_STANDINGS = new ArrayList<SeasonStandingObject>();
            }
        }
        context.method_51448().method_22909();
        if (PHASE == RaceResultsPhase.PLAYERS_HOLD || PHASE == RaceResultsPhase.STANDINGS_HOLD) {
            context.method_51448().method_22903();
            float width = TIMER / (float)holdTime * (float)context.method_51421();
            context.method_51737(0, 0, (int)width, 2, 0, -256);
            context.method_51448().method_22909();
        }
    }

    private static void renderPlate(class_332 context, int x, int y, int width, String textStr, int color, class_2960 texture) {
        class_310 client = class_310.method_1551();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 0.0f);
        RenderSystem.enableBlend();
        context.method_25290(texture, 0, 0, 0.0f, 0.0f, width, 12, width, 12);
        class_2561 text = class_2561.method_30163((String)textStr);
        context.method_51439(client.field_1772, text, width / 2 - client.field_1772.method_27525((class_5348)text) / 2, 2, color, true);
        context.method_51448().method_22909();
    }

    public static void fetchRaceResults(String season, String race) {
        int i;
        JsonElement root;
        JsonParser jp;
        int responseCode;
        HttpURLConnection conn;
        URL url;
        String urlString;
        try {
            urlString = "https://files.cablepost.co.uk/bodkinBoats/get_race.php?season=" + season + "&race=" + race;
            url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                jp = new JsonParser();
                root = jp.parse((Reader)new InputStreamReader(conn.getInputStream()));
                JsonObject rootObj = root.getAsJsonObject();
                JsonArray playersJson = rootObj.get("players").getAsJsonArray();
                PLAYERS = new ArrayList<RaceResultPlayerObject>();
                for (i = 0; i < playersJson.size(); ++i) {
                    RaceResultPlayerObject playerObject = new RaceResultPlayerObject();
                    playerObject.name = playersJson.get(i).getAsJsonObject().get("name").getAsString();
                    playerObject.gridPosition = playersJson.get(i).getAsJsonObject().get("gridPosition").getAsString();
                    playerObject.finishPosition = playersJson.get(i).getAsJsonObject().get("finishPositionStr").getAsString();
                    playerObject.points = playersJson.get(i).getAsJsonObject().get("points").getAsString();
                    playerObject.fastestLap = playersJson.get(i).getAsJsonObject().get("fastestLapStr").getAsString();
                    PLAYERS.add(playerObject);
                }
                PLAYERS.sort(Comparator.comparing(RaceResultPlayerObject::getFinishPositionForSorting));
                for (i = 0; i < PLAYERS.size(); ++i) {
                    RaceResultsOverlay.PLAYERS.get((int)i).x = -1500 - i * 100;
                    RaceResultsOverlay.PLAYERS.get((int)i).y = i * 12 + 12;
                }
            } else {
                System.out.println("Failed to get JSON. Response Code: " + responseCode);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            urlString = "https://files.cablepost.co.uk/bodkinBoats/get_season_standings.php?season=" + season + "&full_json=1";
            url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                jp = new JsonParser();
                root = jp.parse((Reader)new InputStreamReader(conn.getInputStream()));
                JsonObject rootobj = root.getAsJsonObject();
                JsonArray seasonStandingsJson = rootobj.get("standings").getAsJsonArray();
                SEASON_STANDINGS = new ArrayList<SeasonStandingObject>();
                for (i = 0; i < seasonStandingsJson.size(); ++i) {
                    SeasonStandingObject seasonStandingObject = new SeasonStandingObject();
                    seasonStandingObject.name = seasonStandingsJson.get(i).getAsJsonObject().get("name").getAsString();
                    seasonStandingObject.points = seasonStandingsJson.get(i).getAsJsonObject().get("points").getAsString();
                    SEASON_STANDINGS.add(seasonStandingObject);
                }
                SEASON_STANDINGS.sort(Comparator.comparing(SeasonStandingObject::getPointsForSorting));
                for (i = 0; i < SEASON_STANDINGS.size(); ++i) {
                    RaceResultsOverlay.SEASON_STANDINGS.get((int)i).x = -1500 - i * 100;
                    RaceResultsOverlay.SEASON_STANDINGS.get((int)i).y = i * 12 + 12;
                }
            } else {
                System.out.println("Failed to get JSON. Response Code: " + responseCode);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TIMER = 0.0f;
        PHASE = RaceResultsPhase.PAYERS_IN;
    }
}

