/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1690;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.network.CheckpointReachedPayloadS2C;
import uk.co.cablepost.bodkin_boats.track.CheckpointReachedKeyModel;
import uk.co.cablepost.bodkin_boats.track.LatestCheckpointForPlayer;
import uk.co.cablepost.bodkin_boats.track.PlayerNameAndUuid;
import uk.co.cablepost.bodkin_boats.track.RaceReport;
import uk.co.cablepost.racing_scoreboard.RacingScoreboardClient;
import uk.co.cablepost.racing_scoreboard.RacingScoreboardEntry;

public class BbRacingScoreboard {
    public static Map<CheckpointReachedKeyModel, Long> CHECKPOINTS_REACHED = new HashMap<CheckpointReachedKeyModel, Long>();
    public static long GO_TIMESTAMP = 0L;

    static Map<String, LatestCheckpointForPlayer> getMostRecentCheckpoints() {
        HashMap<String, LatestCheckpointForPlayer> toRet = new HashMap<String, LatestCheckpointForPlayer>();
        for (Map.Entry<CheckpointReachedKeyModel, Long> entry : CHECKPOINTS_REACHED.entrySet()) {
            LatestCheckpointForPlayer data = BbRacingScoreboard.checkpointReachedKeyModelToLatestCheckpointForPlayer(entry);
            if (!toRet.containsKey(entry.getKey().playerName())) {
                toRet.put(entry.getKey().playerName(), data);
                continue;
            }
            LatestCheckpointForPlayer currentData = (LatestCheckpointForPlayer)toRet.get(entry.getKey().playerName());
            if (currentData.timestamp >= data.timestamp) continue;
            toRet.put(entry.getKey().playerName(), data);
        }
        return toRet;
    }

    public static Optional<LatestCheckpointForPlayer> getCheckpointForPlayer(String playerName, int lap, int checkpoint) {
        Optional<Map.Entry> v = CHECKPOINTS_REACHED.entrySet().stream().filter(x -> ((CheckpointReachedKeyModel)x.getKey()).playerName().equals(playerName) && ((CheckpointReachedKeyModel)x.getKey()).lap() == lap && ((CheckpointReachedKeyModel)x.getKey()).checkpoint() == checkpoint).findFirst();
        if (v.isEmpty()) {
            return Optional.empty();
        }
        LatestCheckpointForPlayer data = new LatestCheckpointForPlayer();
        data.uuid = ((CheckpointReachedKeyModel)v.get().getKey()).player();
        data.name = ((CheckpointReachedKeyModel)v.get().getKey()).playerName();
        data.lap = ((CheckpointReachedKeyModel)v.get().getKey()).lap();
        data.checkpoint = ((CheckpointReachedKeyModel)v.get().getKey()).checkpoint();
        data.timestamp = (Long)v.get().getValue();
        return Optional.of(data);
    }

    public static boolean isAhead(LatestCheckpointForPlayer a, LatestCheckpointForPlayer b) {
        if (a.lap > b.lap) {
            return true;
        }
        if (a.lap < b.lap) {
            return false;
        }
        if (a.checkpoint > b.checkpoint) {
            return true;
        }
        if (a.checkpoint < b.checkpoint) {
            return false;
        }
        return a.timestamp <= b.timestamp;
    }

    public static int getPosition(UUID playerUuid) {
        List<LatestCheckpointForPlayer> mostRecentCheckpointsOrdered = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
        int i = 0;
        for (LatestCheckpointForPlayer checkpointReached : mostRecentCheckpointsOrdered) {
            ++i;
            if (!checkpointReached.uuid.equals(playerUuid)) continue;
            return i;
        }
        return 0;
    }

    public static Optional<LatestCheckpointForPlayer> getLatestCheckpointForPosition(int position) {
        List<LatestCheckpointForPlayer> mostRecentCheckpointsOrdered = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
        int i = 0;
        for (LatestCheckpointForPlayer checkpointReached : mostRecentCheckpointsOrdered) {
            if (++i != position) continue;
            return Optional.of(checkpointReached);
        }
        return Optional.empty();
    }

    public static void renderScoreboard(class_332 context) {
        if (BodkinBoatsClient.RACE_STATE != -1 && BodkinBoatsClient.RACE_STATE != 7 && !Objects.equals(BodkinBoatsClient.TRACK_NAME, "Football") && !Objects.equals(BodkinBoatsClient.TRACK_NAME, "Slither")) {
            class_746 clientPlayer;
            RacingScoreboardClient.currentTitle = true;
            RacingScoreboardClient.scoreboardTitle = class_2561.method_30163((String)"Bodkin Boats");
            RacingScoreboardClient.trackName = class_2561.method_30163((String)(BodkinBoatsClient.MAX_LAPS + (BodkinBoatsClient.MAX_LAPS == 1 ? " lap" : " laps")));
            RacingScoreboardClient.replaceSelfTime = false;
            RacingScoreboardClient.doTopThreeColors = true;
            RacingScoreboardClient.showPlayerNames = true;
            List<LatestCheckpointForPlayer> mostRecentCheckpointsOrdered = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
            Optional<LatestCheckpointForPlayer> mostRecentCheckpointForSelf = mostRecentCheckpointsOrdered.stream().filter(x -> {
                assert (class_310.method_1551().field_1724 != null);
                return x.uuid.equals(class_310.method_1551().field_1724.method_5667());
            }).findFirst();
            if (mostRecentCheckpointForSelf.isEmpty()) {
                mostRecentCheckpointForSelf = mostRecentCheckpointsOrdered.stream().findFirst();
            }
            if (mostRecentCheckpointForSelf.isPresent() && mostRecentCheckpointForSelf.get().lap > 0) {
                RacingScoreboardClient.trackName = class_2561.method_30163((String)("Lap: " + Math.min(mostRecentCheckpointForSelf.get().lap, BodkinBoatsClient.MAX_LAPS) + " / " + BodkinBoatsClient.MAX_LAPS));
            }
            Optional<Object> mostRecentCheckpointToCompareTo = Optional.empty();
            class_746 class_7462 = class_310.method_1551().field_1724;
            mostRecentCheckpointToCompareTo = class_7462 instanceof class_746 && (clientPlayer = class_7462).method_5854() instanceof class_1690 ? mostRecentCheckpointsOrdered.stream().filter(x -> x.uuid.equals(class_310.method_1551().field_1724.method_5667())).findFirst() : mostRecentCheckpointsOrdered.stream().findFirst();
            int i = 0;
            for (LatestCheckpointForPlayer checkpointReached : mostRecentCheckpointsOrdered) {
                ++i;
                String playerName = checkpointReached.name.trim();
                RacingScoreboardEntry entry = new RacingScoreboardEntry();
                entry.current = true;
                entry.fastest = false;
                entry.finished = checkpointReached.lap >= BodkinBoatsClient.MAX_LAPS + 1;
                entry.position = i;
                entry.pits = 0;
                entry.team = class_2561.method_30163((String)" ");
                entry.time = class_2561.method_30163((String)"");
                if (mostRecentCheckpointToCompareTo.isPresent()) {
                    if (((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).name.equals(checkpointReached.name) || checkpointReached.lap == 0 || ((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).lap == 0) {
                        entry.time = class_2561.method_30163((String)"");
                    } else {
                        boolean compareToIsAhead = BbRacingScoreboard.isAhead((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get(), checkpointReached);
                        if (compareToIsAhead) {
                            Optional<LatestCheckpointForPlayer> compareToCheckpoint = BbRacingScoreboard.getCheckpointForPlayer(((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).name, checkpointReached.lap, checkpointReached.checkpoint);
                            if (compareToCheckpoint.isPresent()) {
                                long timeSinceCompareToWasAtCheckpoint = Math.abs(compareToCheckpoint.get().timestamp - ((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).timestamp);
                                timestampToUse = compareToCheckpoint.get().timestamp;
                                entry.time = class_2561.method_43470((String)("+" + (double)(Math.abs(timestampToUse - checkpointReached.timestamp) + timeSinceCompareToWasAtCheckpoint) / 1000.0)).method_27694(s -> s.method_10977(class_124.field_1060));
                            } else {
                                entry.time = class_2561.method_30163((String)"???");
                            }
                        } else {
                            Optional<LatestCheckpointForPlayer> compareFromCheckpoint = BbRacingScoreboard.getCheckpointForPlayer(checkpointReached.name, ((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).lap, ((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).checkpoint);
                            if (compareFromCheckpoint.isPresent()) {
                                long timeSinceCompareFromWasAtCheckpoint = Math.abs(compareFromCheckpoint.get().timestamp - checkpointReached.timestamp);
                                timestampToUse = compareFromCheckpoint.get().timestamp;
                                double diff = (double)(Math.abs(((LatestCheckpointForPlayer)mostRecentCheckpointToCompareTo.get()).timestamp - timestampToUse) + timeSinceCompareFromWasAtCheckpoint) / 1000.0;
                                entry.time = class_2561.method_43470((String)("-" + diff)).method_27694(s -> s.method_10977(class_124.field_1061));
                            } else {
                                entry.time = class_2561.method_30163((String)"???");
                            }
                        }
                    }
                }
                entry.targetX = context.method_51421();
                entry.targetY = 12 + i * 12;
                if (RacingScoreboardClient.racingScoreboardEntries.containsKey(playerName)) {
                    RacingScoreboardEntry existing = (RacingScoreboardEntry)RacingScoreboardClient.racingScoreboardEntries.get(playerName);
                    entry.x = existing.x;
                    entry.y = existing.y;
                } else {
                    entry.x = context.method_51421() + 400;
                    entry.y = 0;
                }
                entry.player = class_2561.method_30163((String)playerName);
                RacingScoreboardClient.racingScoreboardEntries.put(playerName, entry);
            }
        }
    }

    @NotNull
    public static Stream<LatestCheckpointForPlayer> getLatestCheckpointForPlayerStream() {
        Map<String, LatestCheckpointForPlayer> mostRecentCheckpoints = BbRacingScoreboard.getMostRecentCheckpoints();
        return mostRecentCheckpoints.values().stream().sorted((x, y) -> {
            if (x.lap > y.lap) {
                return -1;
            }
            if (x.lap < y.lap) {
                return 1;
            }
            if (x.checkpoint > y.checkpoint) {
                return -1;
            }
            if (x.checkpoint < y.checkpoint) {
                return 1;
            }
            if (x.timestamp < y.timestamp) {
                return -1;
            }
            if (x.timestamp > y.timestamp) {
                return 1;
            }
            return 0;
        });
    }

    public static void addCheckpointReached(CheckpointReachedPayloadS2C payload) {
        CHECKPOINTS_REACHED.put(new CheckpointReachedKeyModel(UUID.fromString(payload.playerUuidStr()), payload.playerName(), payload.lap(), payload.checkpoint()), payload.timestamp());
    }

    public static void clear() {
        CHECKPOINTS_REACHED.clear();
        GO_TIMESTAMP = 0L;
    }

    private static String generateRaceReportJson() {
        RaceReport raceReport = new RaceReport();
        raceReport.goTimestamp = GO_TIMESTAMP;
        raceReport.maxLaps = BodkinBoatsClient.MAX_LAPS;
        List checkpointsReachedSorted = CHECKPOINTS_REACHED.entrySet().stream().sorted(Map.Entry.comparingByValue()).toList();
        for (Map.Entry<CheckpointReachedKeyModel, Long> entry : checkpointsReachedSorted) {
            if (((CheckpointReachedKeyModel)entry.getKey()).lap() == 0) {
                PlayerNameAndUuid playerNameAndUuid = new PlayerNameAndUuid();
                playerNameAndUuid.name = entry.getKey().playerName();
                playerNameAndUuid.uuid = entry.getKey().player();
                raceReport.grid.add(playerNameAndUuid);
                continue;
            }
            raceReport.checkpoints.add(BbRacingScoreboard.checkpointReachedKeyModelToLatestCheckpointForPlayer(entry));
        }
        return new Gson().toJson((Object)raceReport);
    }

    public static void saveRaceReport() {
        if (CHECKPOINTS_REACHED.isEmpty()) {
            return;
        }
        if (Objects.equals(BodkinBoatsClient.TRACK_NAME, "Football") || Objects.equals(BodkinBoatsClient.TRACK_NAME, "Slither")) {
            return;
        }
        String report = BbRacingScoreboard.generateRaceReportJson();
        File folder = new File(class_310.method_1551().field_1697, "race_reports");
        folder.mkdir();
        File file = new File(folder, class_156.method_44893() + ".json");
        class_156.method_27958().execute(() -> {
            try (PrintWriter out = new PrintWriter(file);){
                out.println(report);
                if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_43496(class_2561.method_30163((String)"Saved race report to:"));
                    class_5250 link = class_2561.method_43470((String)file.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
                    class_310.method_1551().field_1724.method_43496((class_2561)link);
                }
            }
            catch (IOException ex) {
                System.out.println("Failed to save race report: " + ex.getMessage());
            }
        });
    }

    private static LatestCheckpointForPlayer checkpointReachedKeyModelToLatestCheckpointForPlayer(Map.Entry<CheckpointReachedKeyModel, Long> entry) {
        LatestCheckpointForPlayer data = new LatestCheckpointForPlayer();
        data.uuid = entry.getKey().player();
        data.name = entry.getKey().playerName();
        data.lap = entry.getKey().lap();
        data.checkpoint = entry.getKey().checkpoint();
        data.timestamp = entry.getValue();
        return data;
    }

    public static Optional<LatestCheckpointForPlayer> getPlayerAhead(boolean onlyOnline) {
        if (class_310.method_1551().field_1724 == null || BodkinBoatsClient.RACE_STATE != 0) {
            return Optional.empty();
        }
        int position = BbRacingScoreboard.getPosition(class_310.method_1551().field_1724.method_5667());
        for (int i = position - 1; i >= 0; --i) {
            boolean online;
            Optional<LatestCheckpointForPlayer> toRet = BbRacingScoreboard.getLatestCheckpointForPosition(i);
            if (!onlyOnline || toRet.isEmpty()) {
                return toRet;
            }
            boolean bl = online = class_310.method_1551().method_1562() != null && class_310.method_1551().method_1562().method_2871(toRet.get().uuid) != null;
            if (!online) continue;
            return toRet;
        }
        return Optional.empty();
    }

    public static Optional<LatestCheckpointForPlayer> getLatestCheckpointForPlayer(UUID playerUuid) {
        if (class_310.method_1551().field_1724 == null || BodkinBoatsClient.RACE_STATE != 0) {
            return Optional.empty();
        }
        List<LatestCheckpointForPlayer> mostRecentCheckpointsOrdered = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
        for (LatestCheckpointForPlayer checkpointReached : mostRecentCheckpointsOrdered) {
            if (!checkpointReached.uuid.equals(playerUuid)) continue;
            return Optional.of(checkpointReached);
        }
        return Optional.empty();
    }

    public static Optional<LatestCheckpointForPlayer> getLatestCheckpointForSelf() {
        List<LatestCheckpointForPlayer> mostRecentCheckpointsOrdered = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
        return mostRecentCheckpointsOrdered.stream().filter(x -> {
            assert (class_310.method_1551().field_1724 != null);
            return x.uuid.equals(class_310.method_1551().field_1724.method_5667());
        }).findFirst();
    }
}

