/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9779;
import net.minecraft.class_9817;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.entities.towable.TowableEntity;
import uk.co.cablepost.bodkin_boats.entities.towable.TowablePackageDestination;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.mixin.BoatEntityAccess;
import uk.co.cablepost.bodkin_boats.track.ClientEquippedPowerUpHandler;
import uk.co.cablepost.bodkin_boats.track.HonkData;
import uk.co.cablepost.bodkin_boats.track.HornHandler;

@Environment(value=EnvType.CLIENT)
public class Hud {
    private static final class_2960 SPEEDOMETER_BG = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/speedometer_bg.png");
    private static final class_2960 SPEEDOMETER_NEEDLE = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/speedometer_needle.png");
    private static final class_2960 EXTRA_BG = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/extra_bg.png");
    private static final class_2960 ROTATION_ARROW = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/rotation_arrow.png");
    private static final class_2960 INPUT_ARROW_ON = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/input_arrow_on.png");
    private static final class_2960 INPUT_ARROW_OFF = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"textures/gui/input_arrow_off.png");

    public static void renderHudInBoat(class_332 context, class_9779 tickDeltaManager, class_1690 boatEntity, class_746 player) {
        Hud.renderHornBar(context, boatEntity);
        Hud.renderLeashed(context, boatEntity, player);
        if (class_310.method_1551().field_1690.field_1842 || BodkinBoatsClient.RACE_STATE == 4 || player.method_6059(BodkinBoats.LOADING_SCREEN_EFFECT)) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), (float)context.method_51443() - 60.0f, 0.0f);
        Hud.renderSpeedometer(context, boatEntity);
        context.method_51448().method_22903();
        context.method_51448().method_46416(80.0f, 30.0f, 0.0f);
        Hud.renderDriftAngle(context, boatEntity);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_46416(-80.0f, 30.0f, 0.0f);
        Hud.renderInputs(context, boatEntity);
        context.method_51448().method_22909();
        context.method_51448().method_22909();
        if (BodkinBoatsClient.TRACK_NAME.equals("Football") && BodkinBoatsClient.RACE_STATE != -1) {
            Hud.renderFootball(context, player);
        }
        if (BodkinBoatsClient.RACE_STATE == 10) {
            Hud.renderSlither(context, player);
        }
        if (BodkinBoatsClient.RACE_STATE == 11) {
            Hud.renderPackageDelivery(context, player);
        }
    }

    private static void renderSpeedometer(class_332 context, class_1690 boatEntity) {
        context.method_51448().method_22903();
        context.method_51448().method_22905(0.1f, 0.1f, 0.1f);
        RenderSystem.enableBlend();
        context.method_25290(SPEEDOMETER_BG, -512, -512, 0.0f, 0.0f, 1024, 1024, 1024, 1024);
        int segments = 25;
        for (int i = 0; i < segments; ++i) {
            context.method_51448().method_22903();
            context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(135.0f + (float)(i * 270) / (float)(segments - 1)));
            context.method_51448().method_46416(420.0f, 0.0f, 0.0f);
            context.method_51737(0, -10, 50, 10, 0, i > 13 ? -16722698 : -1);
            context.method_51448().method_22909();
        }
        double rawSpeed = boatEntity.method_18798().method_1033();
        context.method_51448().method_22903();
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(-135.0f + (float)(rawSpeed * 75.0)));
        context.method_25290(SPEEDOMETER_NEEDLE, -512, -512, 0.0f, 0.0f, 1024, 1024, 1024, 1024);
        context.method_51448().method_22909();
        String speedTxt = Math.round(rawSpeed * 71.8) + " kph";
        context.method_51448().method_22903();
        context.method_51448().method_22905(10.0f, 10.0f, 10.0f);
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)speedTxt), -((int)((float)class_310.method_1551().field_1772.method_1727(speedTxt) / 2.0f)), 25, 0xFFFFFF, false);
        context.method_51448().method_22909();
        context.method_51448().method_22909();
    }

    private static void renderDriftAngle(class_332 context, class_1690 boatEntity) {
        context.method_51448().method_22903();
        context.method_51448().method_22903();
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(45.0f));
        context.method_51448().method_22905(0.25f, 0.25f, 0.25f);
        RenderSystem.enableBlend();
        context.method_25290(EXTRA_BG, -64, -64, 0.0f, 0.0f, 128, 128, 128, 128);
        context.method_51448().method_22909();
        class_243 boatVel = boatEntity.method_18798();
        class_243 rotVec = boatEntity.method_5720();
        double dotProduct = boatVel.method_1026(rotVec);
        class_243 crossProduct = boatVel.method_1036(rotVec);
        double driftAngle = Math.toDegrees(Math.acos(dotProduct / boatVel.method_1033() * rotVec.method_1033()));
        context.method_51448().method_22903();
        context.method_51448().method_22905(0.033f, 0.035f, 0.035f);
        context.method_51448().method_46416(0.0f, -20.0f, 1000.0f);
        context.method_51448().method_22907(class_7833.field_40714.rotationDegrees(60.0f));
        context.method_25290(ROTATION_ARROW, -512, -512, 0.0f, 0.0f, 1024, 1024, crossProduct.field_1351 < 0.0 ? -1024 : 1024, 1024);
        context.method_51448().method_22909();
        String yawSpeedTxt = "" + Math.round(driftAngle);
        context.method_51448().method_22903();
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)yawSpeedTxt), -((int)((float)class_310.method_1551().field_1772.method_1727(yawSpeedTxt) / 2.0f)), -5, 0xFFFFFF, false);
        context.method_51448().method_22909();
        context.method_51448().method_22909();
    }

    private static void renderInputs(class_332 context, class_1690 boatEntity) {
        context.method_51448().method_22903();
        context.method_51448().method_22903();
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(45.0f));
        context.method_51448().method_22905(0.25f, 0.25f, 0.25f);
        RenderSystem.enableBlend();
        context.method_25290(EXTRA_BG, -64, -64, 0.0f, 0.0f, 128, 128, 128, 128);
        context.method_51448().method_22909();
        boolean pressingForward = ((BoatEntityAccess)boatEntity).getPressingForward();
        boolean pressingBack = ((BoatEntityAccess)boatEntity).getPressingBack();
        boolean pressingLeft = ((BoatEntityAccess)boatEntity).getPressingLeft();
        boolean pressingRight = ((BoatEntityAccess)boatEntity).getPressingRight();
        boolean[] inputs = new boolean[]{pressingForward, pressingLeft, pressingBack, pressingRight};
        for (int i = 0; i < inputs.length; ++i) {
            context.method_51448().method_22903();
            context.method_51448().method_22905(0.09f, 0.09f, 0.09f);
            context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(-90.0f * (float)(i + 1)));
            context.method_51448().method_46416(128.0f, 0.0f, 0.0f);
            context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            context.method_25290(inputs[i] ? INPUT_ARROW_ON : INPUT_ARROW_OFF, -64, -64, 0.0f, 0.0f, 128, 128, 128, 128);
            context.method_51448().method_22909();
        }
        context.method_51448().method_22909();
    }

    private static void renderHornBar(class_332 context, class_1690 boatEntity) {
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), 100.0f, 0.0f);
        context.method_51448().method_22905(0.1f, 0.1f, 0.1f);
        HonkData honkData = HornHandler.HORN_PER_BOAT_ID.getOrDefault(boatEntity.method_5628(), new HonkData());
        if (honkData.honkBar > 500) {
            int honkBar2 = (honkData.honkBar - 500) * 2;
            context.method_51737(-500, 0, 500, 40, 0, -16777216);
            if (honkData.honkBar > 750) {
                context.method_51737(-500, 0, honkBar2 - 500, 40, 0, -65536);
            } else {
                context.method_51737(-500, 0, honkBar2 - 500, 40, 0, -256);
            }
        }
        context.method_51448().method_22909();
    }

    public static void renderReadyCheck(class_332 context, class_746 clientPlayer) {
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22905(0.5f, 0.5f, 0.5f);
        context.method_51448().method_46416(0.0f, 5.0f, 0.0f);
        context.method_51737(0, -3, 300, 12, 0, 0x55000000);
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)"Ready check, type /ready to ready up"), 10, 0, 0xFFFFFF, false);
        for (class_1657 player : clientPlayer.method_37908().method_18456()) {
            int readyColor;
            String readyStatus;
            context.method_51448().method_46416(0.0f, 16.0f, 0.0f);
            if (player.method_23317() >= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10263() + 0.5f - 2.5f) && player.method_23317() <= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10263() + 0.5f + 2.5f) && player.method_23318() >= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10264() + 0.5f - 2.5f) && player.method_23318() <= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10264() + 0.5f + 2.5f) && player.method_23321() >= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10260() + 0.5f - 2.5f) && player.method_23321() <= (double)((float)BodkinBoatsClient.MEDIA_ROOM.method_10260() + 0.5f + 2.5f)) {
                readyStatus = "Not participating - in media room";
                readyColor = -16776961;
            } else if (player.field_5960) {
                readyStatus = "Not participating - spectator";
                readyColor = -16776961;
            } else if (player.method_6059(BodkinBoats.READY_EFFECT)) {
                readyStatus = "Ready";
                readyColor = -16711936;
            } else {
                readyStatus = "Not ready";
                readyColor = -65536;
            }
            context.method_51737(0, -3, 300, 12, 0, 0x55000000);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)(Objects.requireNonNull(player.method_5476()).getString() + ":")), 10, 0, readyColor, false);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)readyStatus), 120, 0, readyColor, false);
        }
        context.method_51448().method_22909();
    }

    private static void renderLeashed(class_332 context, class_1690 boatEntity, class_746 player) {
        boolean someoneElseLeashedOnToYou = false;
        boolean somthingElseLeashedOnToYou = false;
        for (class_1297 entity : ((class_638)boatEntity.method_37908()).method_18112()) {
            class_9817 leashable;
            class_1297 lh;
            if (!(entity instanceof class_9817) || (lh = (leashable = (class_9817)entity).method_60952()) == null || lh.method_5628() != player.method_5628() && lh.method_5628() != boatEntity.method_5628()) continue;
            if (entity instanceof class_1690 || entity instanceof class_1657) {
                someoneElseLeashedOnToYou = true;
                continue;
            }
            somthingElseLeashedOnToYou = true;
        }
        if (boatEntity.method_60953() || somthingElseLeashedOnToYou) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), 150.0f, 0.0f);
            text = class_2561.method_30163((String)"Honk to detach");
            context.method_51439(class_310.method_1551().field_1772, text, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f)), 25, 16332041, true);
            context.method_51448().method_22909();
        } else if (someoneElseLeashedOnToYou) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), 150.0f, 0.0f);
            text = class_2561.method_30163((String)"Someone has latched on yo you!");
            context.method_51439(class_310.method_1551().field_1772, text, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f)), 0, 7812361, true);
            text = class_2561.method_30163((String)"HOLD Honk to detach");
            context.method_51439(class_310.method_1551().field_1772, text, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f)), 25, 16332041, true);
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 100.0f, 0.0f);
            context.method_51448().method_22905(0.2f, 0.2f, 0.2f);
            HonkData honkData = HornHandler.HORN_PER_BOAT_ID.getOrDefault(boatEntity.method_5628(), new HonkData());
            context.method_51737(-500, 0, 500, 40, 0, -16777216);
            context.method_51737(-500, 0, Math.round((float)honkData.honkBar * 2.3f) - 500, 40, 0, -256);
            context.method_51448().method_22909();
            context.method_51448().method_22909();
        }
    }

    private static void renderFootball(class_332 context, class_746 player) {
        class_266 objective = player.method_37908().method_8428().method_1170("goals");
        if (objective == null) {
            return;
        }
        class_268 redTeam = player.method_37908().method_8428().method_1153("Red");
        class_268 blueTeam = player.method_37908().method_8428().method_1153("Blue");
        if (redTeam == null || blueTeam == null) {
            return;
        }
        int redScore = 0;
        int blueScore = 0;
        for (class_1657 p : player.method_37908().method_18456()) {
            class_9014 s = p.method_7327().method_1180((class_9015)p, objective);
            if (Objects.equals(p.method_5781(), redTeam)) {
                redScore += s.method_55409();
            }
            if (!Objects.equals(p.method_5781(), blueTeam)) continue;
            blueScore += s.method_55409();
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), 15.0f, 0.0f);
        context.method_51448().method_22905(2.0f, 2.0f, 2.0f);
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)("" + redScore)), -10 - (int)((float)class_310.method_1551().field_1772.method_1727("" + redScore) / 2.0f), 0, 0xFF0000, false);
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)"-"), -((int)((float)class_310.method_1551().field_1772.method_1727("-") / 2.0f)), 0, 0xAAAAAA, false);
        context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)("" + blueScore)), 10 - (int)((float)class_310.method_1551().field_1772.method_1727("" + blueScore) / 2.0f), 0, 255, false);
        context.method_51448().method_22905(0.25f, 0.25f, 0.25f);
        class_2561 txt = class_2561.method_30163((String)("First to " + BodkinBoatsClient.MAX_LAPS + " goals wins"));
        context.method_51439(class_310.method_1551().field_1772, txt, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)txt) / 2.0f)), -20, 0xFFFFFF, false);
        context.method_51448().method_22909();
    }

    private static void renderSlither(class_332 context, class_746 player) {
        if (ClientEquippedPowerUpHandler.QUESTION_MARK_SPINNING != null) {
            return;
        }
        class_266 objective = player.method_37908().method_8428().method_1170("score");
        if (objective == null) {
            return;
        }
        class_9014 score = player.method_7327().method_1180((class_9015)player, objective);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP == null ? 10.0f : 30.0f, 0.0f);
        class_2561 txt = class_2561.method_30163((String)("Score: " + score.method_55409()));
        context.method_51439(class_310.method_1551().field_1772, txt, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)txt) / 2.0f)), 0, 34816, false);
        long endTime = BodkinBoatsClient.RACE_STATE_TIMESTAMP + 900000L;
        long timeRemaining = endTime - NtpTimeSync.getTrueTime();
        if (timeRemaining < 0L) {
            timeRemaining = 0L;
        }
        int secondsRemaining = (int)(timeRemaining / 1000L);
        String timeRemainingStr = "" + secondsRemaining;
        if (secondsRemaining > 60) {
            timeRemainingStr = secondsRemaining / 60 + ":" + String.format("%02d", secondsRemaining % 60);
        }
        class_2561 txt2 = class_2561.method_30163((String)("Time remaining: " + timeRemainingStr));
        context.method_51439(class_310.method_1551().field_1772, txt2, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)txt2) / 2.0f)), 15, 0xFFAA00, false);
        context.method_51448().method_22909();
    }

    private static void renderPackageDelivery(class_332 context, class_746 player) {
        if (ClientEquippedPowerUpHandler.QUESTION_MARK_SPINNING != null) {
            return;
        }
        class_266 objective = player.method_37908().method_8428().method_1170("score");
        if (objective == null) {
            return;
        }
        class_9014 score = player.method_7327().method_1180((class_9015)player, objective);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)((int)((float)context.method_51421() / 2.0f)), ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP == null ? 10.0f : 30.0f, 0.0f);
        class_2561 txt = class_2561.method_30163((String)("Score: " + score.method_55409()));
        context.method_51439(class_310.method_1551().field_1772, txt, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)txt) / 2.0f)), 0, 34816, false);
        long endTime = BodkinBoatsClient.RACE_STATE_TIMESTAMP + 900000L;
        long timeRemaining = endTime - NtpTimeSync.getTrueTime();
        if (timeRemaining < 0L) {
            timeRemaining = 0L;
        }
        int secondsRemaining = (int)(timeRemaining / 1000L);
        String timeRemainingStr = "" + secondsRemaining;
        if (secondsRemaining > 60) {
            timeRemainingStr = secondsRemaining / 60 + ":" + String.format("%02d", secondsRemaining % 60);
        }
        class_2561 txt2 = class_2561.method_30163((String)("Time remaining: " + timeRemainingStr));
        context.method_51439(class_310.method_1551().field_1772, txt2, -((int)((float)class_310.method_1551().field_1772.method_27525((class_5348)txt2) / 2.0f)), 15, 0xFFAA00, false);
        context.method_51448().method_22909();
        class_1297 class_12972 = player.method_5854();
        if (class_12972 instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            context.method_51448().method_22903();
            for (class_1297 otherEntity : boat.method_37908().method_8335((class_1297)boat, boat.method_5829().method_1014(100.0))) {
                TowableEntity towableEntity;
                class_1297 lh;
                if (!(otherEntity instanceof TowableEntity) || (lh = (towableEntity = (TowableEntity)otherEntity).method_60952()) == null || lh.method_5628() != player.method_5628() && lh.method_5628() != boat.method_5628()) continue;
                TowablePackageDestination towablePackageDestination = TowablePackageDestination.values()[towableEntity.getPackageDestinationFlag()];
                class_2561 destinationName = class_2561.method_30163((String)("Deliver to: " + towablePackageDestination.name));
                context.method_51439(class_310.method_1551().field_1772, destinationName, 50, 100, 0xFFAA00, false);
                context.method_51448().method_46416(100.0f, 0.0f, 0.0f);
            }
            context.method_51448().method_22909();
        }
    }
}

