/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import uk.co.cablepost.bodkin_boats.misc.Vec3dAndYaw;
import uk.co.cablepost.bodkin_boats.track.MovingPlatformPhase;

public class MovingPlatform {
    public List<MovingPlatformPhase> phases;
    public class_2248 block;
    public float sizeX;
    public float sizeY;
    public float sizeZ;
    public static final Codec<MovingPlatform> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MovingPlatformPhase.CODEC.listOf().fieldOf("phases").forGetter(MovingPlatform::getPhases), (App)class_5699.field_41759.fieldOf("block").forGetter(MovingPlatform::getBlockId), (App)class_5699.field_34387.fieldOf("size_x").forGetter(MovingPlatform::getSizeX), (App)class_5699.field_34387.fieldOf("size_y").forGetter(MovingPlatform::getSizeY), (App)class_5699.field_34387.fieldOf("size_z").forGetter(MovingPlatform::getSizeZ)).apply((Applicative)instance, MovingPlatform::new));

    public MovingPlatform(List<MovingPlatformPhase> phases, String blockId, float sizeX, float sizeY, float sizeZ) {
        this.phases = phases;
        this.block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockId));
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public List<MovingPlatformPhase> getPhases() {
        return this.phases;
    }

    public String getBlockId() {
        return class_7923.field_41175.method_10221((Object)this.block).toString();
    }

    public float getSizeX() {
        return this.sizeX;
    }

    public float getSizeY() {
        return this.sizeY;
    }

    public float getSizeZ() {
        return this.sizeZ;
    }

    public Vec3dAndYaw getCurrentPosAndYaw(long now) {
        int loopTime = this.phases.getLast().getTime();
        if (loopTime == 0) {
            return new Vec3dAndYaw(this.phases.getLast().pos, this.phases.getLast().yaw);
        }
        int intoLoop = (int)(now % (long)loopTime);
        if (loopTime <= intoLoop) {
            return new Vec3dAndYaw(this.phases.getLast().pos, this.phases.getLast().yaw);
        }
        int phaseIndex = 0;
        for (MovingPlatformPhase phase : this.phases) {
            if (phase.time > intoLoop) break;
            ++phaseIndex;
        }
        MovingPlatformPhase previousPhase = this.phases.get(--phaseIndex);
        MovingPlatformPhase nextPhase = this.phases.get(phaseIndex + 1);
        double phaseLerp = ((double)intoLoop - (double)previousPhase.time) / ((double)nextPhase.time - (double)previousPhase.time);
        return new Vec3dAndYaw(new class_243(class_3532.method_16436((double)phaseLerp, (double)previousPhase.getPos().field_1352, (double)nextPhase.getPos().field_1352), class_3532.method_16436((double)phaseLerp, (double)previousPhase.getPos().field_1351, (double)nextPhase.getPos().field_1351), class_3532.method_16436((double)phaseLerp, (double)previousPhase.getPos().field_1350, (double)nextPhase.getPos().field_1350)), (float)class_3532.method_16436((double)phaseLerp, (double)previousPhase.getYaw(), (double)nextPhase.getYaw()));
    }
}

