/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.world_data;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import uk.co.cablepost.bodkin_boats.ai.world_data.GetWorldData;
import uk.co.cablepost.bodkin_boats.ai.world_data.IWGetWorldDataView;

public class GetWorldDataCache
implements IWGetWorldDataView {
    int minX;
    int minZ;
    int maxX;
    int maxZ;
    int yLevel;
    float[] data;

    public GetWorldDataCache(class_1937 world, int minX, int minZ, int maxX, int maxZ, int yLevel) {
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.yLevel = yLevel;
        this.data = new float[(maxX - minX + 1) * (maxZ - minZ + 1)];
        int i = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int index = this.positionToIndex(x, z);
                if (index % 1000 == 0) {
                    System.out.println("Caching block: " + i + "/" + this.data.length);
                }
                ++i;
                try {
                    this.data[index] = GetWorldData.getBlockSlipValue(world, new class_2338(x, yLevel - 1, z));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Unable to cache blocks");
                    throw e;
                }
            }
        }
        System.out.println("Finished caching blocks.");
    }

    private int positionToIndex(int x, int z) {
        if (x > this.maxX || x < this.minX || z > this.maxZ || z < this.minZ) {
            return -1;
        }
        int width = this.maxX - this.minX + 1;
        return (z - this.minZ) * width + (x - this.minX);
    }

    @Override
    public float getBlockSlip(class_2338 blockPos) {
        int index = this.positionToIndex(blockPos.method_10263(), blockPos.method_10260());
        if (index == -1) {
            return 0.0f;
        }
        return this.data[index];
    }
}

