/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.blender;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.misc.RgbColor;

public class BlenderWebSocketClient {
    private WebSocketClient client;
    private final String serverUri = "ws://localhost:8765";
    private final Gson gson = new Gson();
    private final BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private final Map<Integer, Boolean> entityPresentLastTick = new HashMap<Integer, Boolean>();
    private Thread senderThread;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public void connect() {
        try {
            URI uri = URI.create("ws://localhost:8765");
            this.client = new WebSocketClient(uri){

                public void onOpen(ServerHandshake handshake) {
                    System.out.println("Connected to Blender WebSocket server");
                    BlenderWebSocketClient.this.running.set(true);
                    BlenderWebSocketClient.this.startSenderThread();
                }

                public void onMessage(String message) {
                    System.out.println("Received from Blender: " + message);
                }

                public void onClose(int code, String reason, boolean remote) {
                    System.out.println("Disconnected from Blender: " + reason);
                    BlenderWebSocketClient.this.running.set(false);
                }

                public void onError(Exception ex) {
                    System.err.println("WebSocket error: " + ex.getMessage());
                }
            };
            this.client.connect();
        }
        catch (Exception e) {
            System.err.println("Failed to connect to Blender: " + e.getMessage());
        }
    }

    private void startSenderThread() {
        this.senderThread = new Thread(() -> {
            while (this.running.get() || !this.messageQueue.isEmpty()) {
                try {
                    String message = this.messageQueue.poll(1L, TimeUnit.SECONDS);
                    if (message == null || this.client == null || !this.client.isOpen()) continue;
                    this.client.send(message);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    System.err.println("Error sending message: " + e.getMessage());
                }
            }
        });
        this.senderThread.setName("BlenderWebSocket-Sender");
        this.senderThread.setDaemon(true);
        this.senderThread.start();
    }

    public void onTick(List<class_1297> entities) {
        if (!this.running.get()) {
            return;
        }
        for (class_1297 entity : entities) {
            String message;
            if (!this.shouldTrackEntity(entity)) continue;
            JsonObject entityData = this.createEntityJson(entity);
            if (entityData != null && !this.messageQueue.offer(message = this.gson.toJson((JsonElement)entityData))) {
                System.err.println("Message queue is full, dropping entity data");
            }
            this.entityPresentLastTick.put(entity.method_5628(), true);
        }
        Iterator<Object> iterator = this.entityPresentLastTick.keySet().iterator();
        while (iterator.hasNext()) {
            int presentLast = (Integer)iterator.next();
            if (!this.entityPresentLastTick.get(presentLast).booleanValue() || !entities.stream().noneMatch(x -> x.method_5628() == presentLast)) continue;
            JsonObject data = new JsonObject();
            data.addProperty("id", (Number)presentLast);
            JsonArray position = new JsonArray();
            position.add((Number)0);
            position.add((Number)-1000);
            position.add((Number)0);
            JsonArray rotation = new JsonArray();
            rotation.add((Number)0);
            rotation.add((Number)0);
            rotation.add((Number)0);
            data.add("position", (JsonElement)position);
            data.add("rotation", (JsonElement)rotation);
            data.addProperty("extra", "");
            data.addProperty("timestamp", (Number)((double)NtpTimeSync.getTrueTime() / 1000.0));
            this.entityPresentLastTick.put(presentLast, false);
        }
    }

    private JsonObject createEntityJson(class_1297 entity) {
        try {
            int entityId = entity.method_5628();
            String entityType = this.getEntityType(entity);
            class_243 pos = entity.method_19538();
            JsonObject data = new JsonObject();
            data.addProperty("id", (Number)entityId);
            data.addProperty("type", entityType);
            JsonArray position = new JsonArray();
            position.add((Number)(pos.field_1352 - 0.5));
            if (entityType.equals("boat")) {
                position.add((Number)(pos.field_1351 - 0.5));
            } else {
                position.add((Number)pos.field_1351);
            }
            position.add((Number)(-pos.field_1350 + 0.5));
            data.add("position", (JsonElement)position);
            JsonArray rotation = new JsonArray();
            rotation.add((Number)0);
            if (entityType.equals("boat")) {
                rotation.add((Number)Math.toRadians(-entity.method_36454() + 180.0f));
            } else {
                rotation.add((Number)Math.toRadians(-entity.method_36454()));
            }
            rotation.add((Number)0);
            data.add("rotation", (JsonElement)rotation);
            JsonObject extraData = this.getExtraEntityData(entity);
            data.add("extra", (JsonElement)extraData);
            data.addProperty("timestamp", (Number)((double)NtpTimeSync.getTrueTime() / 1000.0));
            return data;
        }
        catch (Exception e) {
            System.err.println("Error creating entity JSON: " + e.getMessage());
            return null;
        }
    }

    private String getEntityType(class_1297 entity) {
        if (entity instanceof class_1690) {
            return "boat";
        }
        return "default";
    }

    private JsonObject getExtraEntityData(class_1297 entity) {
        class_1690 boatEntity;
        class_1309 class_13092;
        JsonObject data = new JsonObject();
        if (entity instanceof class_1690 && (class_13092 = (boatEntity = (class_1690)entity).method_5642()) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_13092;
            float ghostAmt = BodkinBoatsClient.getGhostAmount((class_1309)playerEntity);
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            float alpha = 1.0f - ghostAmt * 0.7f;
            data.addProperty("A", (Number)Float.valueOf(alpha));
            if (BodkinBoatsClient.BOAT_COLOR.containsKey(playerEntity.method_5667())) {
                RgbColor rgbColor = BodkinBoatsClient.BOAT_COLOR.get(playerEntity.method_5667());
                red = 0.04f + rgbColor.red() * 0.96f;
                green = 0.04f + rgbColor.green() * 0.96f;
                blue = 0.04f + rgbColor.blue() * 0.96f;
                data.addProperty("R", (Number)Float.valueOf(red));
                data.addProperty("G", (Number)Float.valueOf(green));
                data.addProperty("B", (Number)Float.valueOf(blue));
            }
            if (!this.entityPresentLastTick.getOrDefault(entity.method_5628(), false).booleanValue()) {
                String username = Objects.requireNonNull(playerEntity.method_5476()).method_10858(32);
                data.addProperty("Username", username);
                data.addProperty("HeadPitch", (Number)Float.valueOf(-Math.clamp(playerEntity.method_36455(), -90.0f, 5.0f)));
                data.addProperty("HeadYaw", (Number)Float.valueOf(-playerEntity.method_5791() + boatEntity.method_36454()));
            }
        }
        return data;
    }

    public void onEntityUpdate(class_1297 entity) {
        JsonObject entityData;
        if (this.shouldTrackEntity(entity) && (entityData = this.createEntityJson(entity)) != null) {
            String message = this.gson.toJson((JsonElement)entityData);
            this.messageQueue.offer(message);
        }
    }

    private boolean shouldTrackEntity(class_1297 entity) {
        return entity instanceof class_1690;
    }

    public void disconnect() {
        try {
            this.running.set(false);
            if (this.senderThread != null && this.senderThread.isAlive()) {
                this.senderThread.interrupt();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error disconnecting: " + e.getMessage());
        }
    }
}

