/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.track.MovingPlatform;
import uk.co.cablepost.bodkin_boats.track.MovingPlatformPhase;

public record MovingPlatformsPayload(byte[] movingPlatformsBytes) implements class_8710
{
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"moving_platforms_packet");
    public static final class_8710.class_9154<MovingPlatformsPayload> PACKET_ID = new class_8710.class_9154(IDENTIFIER);
    public static final class_9139<class_9129, MovingPlatformsPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48987, MovingPlatformsPayload::movingPlatformsBytes, MovingPlatformsPayload::new);

    public static byte[] toBytes(List<MovingPlatform> movingPlatformList) {
        int size = 4;
        for (MovingPlatform platform : movingPlatformList) {
            size += 4;
            size += platform.phases.size() * 32;
            size += 4 + platform.getBlockId().getBytes().length;
            size += 12;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(movingPlatformList.size());
        for (MovingPlatform platform : movingPlatformList) {
            buffer.putInt(platform.phases.size());
            for (MovingPlatformPhase phase : platform.phases) {
                buffer.putDouble(phase.getPos().field_1352);
                buffer.putDouble(phase.getPos().field_1351);
                buffer.putDouble(phase.getPos().field_1350);
                buffer.putFloat(phase.getYaw());
                buffer.putInt(phase.getTime());
            }
            byte[] blockIdBytes = platform.getBlockId().getBytes();
            buffer.putInt(blockIdBytes.length);
            buffer.put(blockIdBytes);
            buffer.putFloat(platform.getSizeX());
            buffer.putFloat(platform.getSizeY());
            buffer.putFloat(platform.getSizeZ());
        }
        return buffer.array();
    }

    public static List<MovingPlatform> fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int platformCount = buffer.getInt();
        ArrayList<MovingPlatform> movingPlatformList = new ArrayList<MovingPlatform>();
        for (int i = 0; i < platformCount; ++i) {
            int phaseCount = buffer.getInt();
            ArrayList<MovingPlatformPhase> phases = new ArrayList<MovingPlatformPhase>();
            for (int j = 0; j < phaseCount; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                double z = buffer.getDouble();
                float yaw = buffer.getFloat();
                int time = buffer.getInt();
                phases.add(new MovingPlatformPhase(new class_243(x, y, z), yaw, time));
            }
            int blockIdLength = buffer.getInt();
            byte[] blockIdBytes = new byte[blockIdLength];
            buffer.get(blockIdBytes);
            String blockId = new String(blockIdBytes);
            float sizeX = buffer.getFloat();
            float sizeY = buffer.getFloat();
            float sizeZ = buffer.getFloat();
            movingPlatformList.add(new MovingPlatform(phases, blockId, sizeX, sizeY, sizeZ));
        }
        return movingPlatformList;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }
}

