/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1690;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7472;
import net.minecraft.class_8710;
import org.joml.Matrix4f;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.network.CheckpointReachedPayload;
import uk.co.cablepost.bodkin_boats.network.SubmitTtTimePayload;
import uk.co.cablepost.bodkin_boats.screens.time_trial.TimeTrialCompletedScreen;
import uk.co.cablepost.bodkin_boats.track.BbTtScoreboard;
import uk.co.cablepost.bodkin_boats.track.Checkpoint;

@Environment(value=EnvType.CLIENT)
public class ClientCheckpointTracker {
    public static List<Checkpoint> CHECKPOINTS = new ArrayList<Checkpoint>();
    public static int lastCheckpointIndex = 0;
    public static int lap = 0;

    public static void renderCheckpoints(WorldRenderContext worldRenderContext) {
        for (Checkpoint checkpoint : CHECKPOINTS) {
            BodkinBoatsClient.renderBlockOutline(worldRenderContext, checkpoint.pos, checkpoint.index % 3 == 1 ? 1.0f : 0.0f, checkpoint.index % 3 == 2 ? 1.0f : 0.0f, checkpoint.index % 3 == 0 ? 1.0f : 0.0f, checkpoint.scale);
            class_2561 text = class_2561.method_30163((String)("Checkpoint " + checkpoint.index));
            class_4587 matrices = worldRenderContext.matrixStack();
            class_4597 vertexConsumers = worldRenderContext.consumers();
            if (matrices == null || vertexConsumers == null) continue;
            matrices.method_22903();
            matrices.method_22904(-worldRenderContext.camera().method_19326().field_1352, -worldRenderContext.camera().method_19326().field_1351, -worldRenderContext.camera().method_19326().field_1350);
            matrices.method_46416((float)checkpoint.pos.method_10263(), (float)(checkpoint.pos.method_10264() + 5), (float)checkpoint.pos.method_10260());
            matrices.method_22907(worldRenderContext.camera().method_23767());
            matrices.method_22905(0.08f, -0.08f, 0.08f);
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            float f = class_310.method_1551().field_1690.method_19343(0.25f);
            int j = (int)(f * 255.0f) << 24;
            class_327 textRenderer = class_310.method_1551().field_1772;
            float g = -textRenderer.method_27525((class_5348)text) / 2;
            textRenderer.method_30882(text, g, 0.0f, -1, false, matrix4f, vertexConsumers, class_327.class_6415.field_33993, j, 255);
            matrices.method_22909();
        }
    }

    public static void setCheckpoints(List<Checkpoint> checkpoints) {
        CHECKPOINTS = checkpoints;
        lastCheckpointIndex = 0;
        lap = 0;
    }

    public static void clear() {
        ClientCheckpointTracker.setCheckpoints(new ArrayList<Checkpoint>());
    }

    public static void doCheckpointChecking(class_1690 boat) {
        if (CHECKPOINTS.isEmpty() || class_310.method_1551().field_1724 == null) {
            return;
        }
        int nextCheckpointIndex = lastCheckpointIndex + 1;
        if (BodkinBoatsClient.RACE_STATE != 7 && nextCheckpointIndex >= CHECKPOINTS.size()) {
            nextCheckpointIndex = 1;
        }
        int nextCheckpointIndex2 = nextCheckpointIndex;
        Optional<Checkpoint> optionalCheckpoint = CHECKPOINTS.stream().filter(x -> x.index == nextCheckpointIndex2).findFirst();
        if (optionalCheckpoint.isEmpty() && BodkinBoatsClient.RACE_STATE == 7) {
            return;
        }
        Checkpoint checkpoint = optionalCheckpoint.get();
        if (boat.method_19538().field_1352 >= (double)((float)checkpoint.getX() - checkpoint.scale / 2.0f) && boat.method_19538().field_1352 <= (double)((float)checkpoint.getX() + checkpoint.scale / 2.0f) && boat.method_19538().field_1350 >= (double)((float)checkpoint.getZ() - checkpoint.scale / 2.0f) && boat.method_19538().field_1350 <= (double)((float)checkpoint.getZ() + checkpoint.scale / 2.0f)) {
            if (BodkinBoatsClient.RACE_STATE == 7) {
                BbTtScoreboard.onCheckpoint(lastCheckpointIndex + 1, lap);
            }
            lastCheckpointIndex = nextCheckpointIndex;
            if (BodkinBoatsClient.RACE_STATE == 7) {
                if (lastCheckpointIndex == CHECKPOINTS.size()) {
                    ClientPlayNetworking.send((class_8710)new SubmitTtTimePayload(BbTtScoreboard.timestamps.get(lap).getLast() - BbTtScoreboard.timestamps.get(lap).getFirst()));
                    lastCheckpointIndex = 0;
                    if (++lap >= 2) {
                        class_310.method_1551().field_1724.field_3944.method_52787((class_2596)new class_7472("reset"));
                    } else {
                        class_310.method_1551().method_1507((class_437)new TimeTrialCompletedScreen());
                    }
                }
            } else if (nextCheckpointIndex == 1 && ++lap <= BodkinBoatsClient.MAX_LAPS && BodkinBoatsClient.RACE_STATE == 0) {
                class_310.method_1551().field_1724.method_43496(class_2561.method_30163((String)("Lap: " + lap + " / " + BodkinBoatsClient.MAX_LAPS)));
            }
            if (BodkinBoatsClient.RACE_STATE == 0) {
                ClientPlayNetworking.send((class_8710)new CheckpointReachedPayload(lap, lastCheckpointIndex, NtpTimeSync.getTrueTime()));
            }
            if (BodkinBoatsClient.RACE_STATE == -1) {
                BbTtScoreboard.onCheckpoint(lastCheckpointIndex, lap);
            }
        }
    }
}

