/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1634;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.network.RemovePowerUpCollectablePayload;
import uk.co.cablepost.bodkin_boats.track.BbRacingScoreboard;
import uk.co.cablepost.bodkin_boats.track.ClientEquippedPowerUpHandler;
import uk.co.cablepost.bodkin_boats.track.LatestCheckpointForPlayer;
import uk.co.cablepost.bodkin_boats.track.PowerUpCollectable;
import uk.co.cablepost.bodkin_boats.track.PowerUpType;

@Environment(value=EnvType.CLIENT)
public class ClientPowerUpCollectableTracker {
    public static List<PowerUpCollectable> POWER_UP_COLLECTABLES = new ArrayList<PowerUpCollectable>();
    public static float ROTATION = 0.0f;

    public static void add(PowerUpCollectable powerUpCollectable) {
        ClientPowerUpCollectableTracker.remove(powerUpCollectable.pos);
        POWER_UP_COLLECTABLES.add(powerUpCollectable);
    }

    public static void remove(class_2338 blockPos) {
        POWER_UP_COLLECTABLES.removeIf(x -> x.getBlockPos().equals((Object)blockPos));
    }

    public static void clear() {
        POWER_UP_COLLECTABLES.clear();
    }

    public static void doCollectableChecking(class_1690 boat) {
        if (ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP != null || ClientEquippedPowerUpHandler.QUESTION_MARK_SPINNING != null || class_310.method_1551().field_1724 == null) {
            return;
        }
        for (PowerUpCollectable powerUpCollectable : POWER_UP_COLLECTABLES) {
            if (!(boat.method_19538().field_1352 >= (double)((float)powerUpCollectable.getX() - 2.0f)) || !(boat.method_19538().field_1352 <= (double)((float)powerUpCollectable.getX() + 3.0f)) || !(boat.method_19538().field_1351 >= (double)((float)powerUpCollectable.getY() - 2.0f)) || !(boat.method_19538().field_1351 <= (double)((float)powerUpCollectable.getY() + 3.0f)) || !(boat.method_19538().field_1350 >= (double)((float)powerUpCollectable.getZ() - 2.0f)) || !(boat.method_19538().field_1350 <= (double)((float)powerUpCollectable.getZ() + 3.0f))) continue;
            ClientPowerUpCollectableTracker.equipPowerUp(PowerUpType.fromString(powerUpCollectable.type), boat);
            ClientPowerUpCollectableTracker.remove(powerUpCollectable.pos);
            ClientPlayNetworking.send((class_8710)new RemovePowerUpCollectablePayload(powerUpCollectable.pos, 0));
            return;
        }
        for (class_1297 entity : boat.method_37908().method_8335((class_1297)boat, boat.method_5829().method_1014(1.0))) {
            class_1688 abstractMinecartEntity;
            if (!(entity instanceof class_1688) || !(abstractMinecartEntity = (class_1688)entity).method_7519().method_26164(class_3481.field_15503)) continue;
            ClientPowerUpCollectableTracker.equipPowerUp(PowerUpType.QUESTION_MARK, boat);
            ClientPlayNetworking.send((class_8710)new RemovePowerUpCollectablePayload(new class_2338(0, 0, 0), entity.method_5628()));
            return;
        }
    }

    static void equipPowerUp(PowerUpType powerUpType, class_1690 boat) {
        ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP = powerUpType;
        if (ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP.equals((Object)PowerUpType.QUESTION_MARK)) {
            ClientEquippedPowerUpHandler.EQUIPPED_POWER_UP = null;
            ClientEquippedPowerUpHandler.QUESTION_MARK_SPIN_ROT = 0.0f;
            ClientEquippedPowerUpHandler.QUESTION_MARK_SPIN_SPEED = 15.01f;
            ClientEquippedPowerUpHandler.QUESTION_MARK_SPINNING = ClientPowerUpCollectableTracker.determinePowerUpToGive();
            for (int i = 0; i < ClientEquippedPowerUpHandler.QUESTION_MARK_SPIN_ITEMS.length; ++i) {
                assert (class_310.method_1551().field_1724 != null);
                ClientEquippedPowerUpHandler.QUESTION_MARK_SPIN_ITEMS[i] = PowerUpType.getRandom(class_310.method_1551().field_1724.method_59922());
            }
        }
        boat.method_37908().method_8486(boat.method_23317(), boat.method_23318(), boat.method_23321(), class_3417.field_15197, class_3419.field_15254, 1.5f, 1.0f, true);
    }

    public static PowerUpType determinePowerUpToGive() {
        PowerUpType[] pool;
        class_746 player = class_310.method_1551().field_1724;
        if (BodkinBoatsClient.RACE_STATE != 8 && BodkinBoatsClient.RACE_STATE != 10 && BodkinBoatsClient.RACE_STATE != 0 || player == null) {
            return PowerUpType.WIND_CHARGE;
        }
        if (BodkinBoatsClient.RACE_STATE == 8) {
            pool = new PowerUpType[]{PowerUpType.SHIELD, player.method_59922().method_43057() < 0.2f ? PowerUpType.BLAZE : PowerUpType.TURTLE, PowerUpType.WIND_CHARGE, PowerUpType.FIREBALL};
        } else if (BodkinBoatsClient.RACE_STATE == 10) {
            pool = new PowerUpType[]{player.method_59922().method_43057() < 0.2f ? PowerUpType.BLAZE : PowerUpType.TURTLE, player.method_59922().method_43057() < 0.4f ? PowerUpType.GHOST : PowerUpType.FIREBALL, PowerUpType.WIND_CHARGE, PowerUpType.FIREBALL};
        } else {
            List vexesInWorld = player.method_37908().method_8390(class_1634.class, class_238.method_30048((class_243)class_243.field_1353, (double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MAX_VALUE), class_1301.field_6155);
            int position = BbRacingScoreboard.getPosition(player.method_5667());
            List<LatestCheckpointForPlayer> latestCheckpoints = BbRacingScoreboard.getLatestCheckpointForPlayerStream().toList();
            pool = position == 1 ? new PowerUpType[]{PowerUpType.SHIELD, player.method_59922().method_43057() < 0.3f ? PowerUpType.BLAZE : PowerUpType.TURTLE, PowerUpType.WIND_CHARGE, PowerUpType.GHOST, PowerUpType.LEAD} : (position == BbRacingScoreboard.getMostRecentCheckpoints().size() && (latestCheckpoints.get((int)(position - 1)).checkpoint < latestCheckpoints.get((int)(position - 2)).checkpoint - 1 || latestCheckpoints.get((int)(position - 1)).lap < latestCheckpoints.get((int)(position - 2)).lap) ? new PowerUpType[]{PowerUpType.WARP, PowerUpType.WIND_CHARGE, PowerUpType.FIREBALL, vexesInWorld.isEmpty() && player.method_59922().method_43057() < 0.3f ? PowerUpType.VEX : PowerUpType.WIND_CHARGE} : (position <= 3 ? new PowerUpType[]{PowerUpType.SHIELD, player.method_59922().method_43057() < 0.3f ? PowerUpType.BLAZE : PowerUpType.TURTLE, PowerUpType.WIND_CHARGE, PowerUpType.FIREBALL, PowerUpType.GHOST, PowerUpType.LEAD} : new PowerUpType[]{PowerUpType.SHIELD, player.method_59922().method_43057() < 0.3f ? PowerUpType.BLAZE : PowerUpType.TURTLE, PowerUpType.WIND_CHARGE, PowerUpType.FIREBALL, vexesInWorld.isEmpty() && player.method_59922().method_43057() < 0.3f ? PowerUpType.VEX : PowerUpType.WIND_CHARGE, player.method_59922().method_43057() < 0.3f ? PowerUpType.GHOST : PowerUpType.WIND_CHARGE, PowerUpType.LEAD}));
        }
        return pool[player.method_59922().method_43048(pool.length)];
    }

    public static void renderPowerUpCollectables(WorldRenderContext worldRenderContext) {
        class_4587 matrixStack;
        if ((ROTATION += 1.0f) > 36000.0f) {
            ROTATION = 0.0f;
        }
        if ((matrixStack = worldRenderContext.matrixStack()) == null) {
            return;
        }
        for (PowerUpCollectable collectable : POWER_UP_COLLECTABLES) {
            PowerUpType powerUpType = PowerUpType.fromString(collectable.type);
            ClientPowerUpCollectableTracker.renderPowerUpCollectable(worldRenderContext, powerUpType, collectable.pos.method_46558(), true);
        }
    }

    public static void renderPowerUpCollectable(WorldRenderContext worldRenderContext, PowerUpType powerUpType, class_243 pos, boolean subtractCamera) {
        class_4587 matrixStack = Objects.requireNonNull(worldRenderContext.matrixStack());
        class_4597 vertexConsumerProvider = worldRenderContext.consumers();
        class_638 clientWorld = Objects.requireNonNull(worldRenderContext.world());
        ClientPowerUpCollectableTracker.renderPowerUpCollectable(matrixStack, vertexConsumerProvider, clientWorld, powerUpType, pos, subtractCamera);
    }

    public static void renderPowerUpCollectable(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_638 clientWorld, PowerUpType powerUpType, class_243 pos, boolean subtractCamera) {
        BodkinBoatsClient.renderItem(matrixStack, vertexConsumerProvider, clientWorld, pos, ClientPowerUpCollectableTracker.getPowerUpItemStack(powerUpType), 2.0f, ROTATION, subtractCamera);
        int color = ClientPowerUpCollectableTracker.getPowerUpColor(powerUpType);
        BodkinBoatsClient.renderPowerUpBand(matrixStack, vertexConsumerProvider, pos, color, ROTATION, subtractCamera);
    }

    private static class_1799 getPowerUpItemStack(PowerUpType powerUpType) {
        class_1799 itemStack = new class_1799((class_1935)powerUpType.getItem());
        itemStack.method_57365(class_1802.field_8137.method_57347());
        return itemStack;
    }

    private static int getPowerUpColor(PowerUpType powerUpType) {
        int color;
        if (powerUpType.equals((Object)PowerUpType.QUESTION_MARK)) {
            float phase = ROTATION % 360.0f;
            int[] colors = new int[]{-65536, -33024, -256, -8388864, -16711936, -16711681, -16776961, -7667457, -65281};
            int segment = (int)(phase / 40.0f);
            float t = phase % 40.0f / 40.0f;
            if (segment >= colors.length) {
                segment = 0;
            }
            int color1 = colors[segment];
            int color2 = colors[(segment + 1) % colors.length];
            color = class_5253.class_5254.method_48780((float)t, (int)color1, (int)color2);
        } else {
            color = powerUpType.getColor();
        }
        return color;
    }
}

