/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.physics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import org.dyn4j.collision.CollisionItem;
import org.dyn4j.collision.CollisionPair;
import org.dyn4j.dynamics.ContinuousDetectionMode;
import org.dyn4j.dynamics.PhysicsBody;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.world.World;
import org.dyn4j.world.WorldCollisionData;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.misc.Vec3dAndYaw;
import uk.co.cablepost.bodkin_boats.mixin.BoatEntityAccess;
import uk.co.cablepost.bodkin_boats.physics.PhysicsBoat;
import uk.co.cablepost.bodkin_boats.track.ClientMovingPlatformsHandler;
import uk.co.cablepost.bodkin_boats.track.MovingPlatform;

public class BoatPhysics {
    public static Map<Integer, Long> lastCollision = new HashMap<Integer, Long>();

    public static void init() {
    }

    public static Optional<MovingPlatform> getOnMovingPlatform(class_1690 boat, float upCheck) {
        if (!boat.method_37908().method_8608()) {
            return Optional.empty();
        }
        World world = new World();
        world.setGravity(0.0, 0.0);
        world.getSettings().setContinuousDetectionMode(ContinuousDetectionMode.ALL);
        PhysicsBoat physicsBoat = new PhysicsBoat(boat.method_23317(), boat.method_23321(), Math.toRadians(boat.method_36454()), boat.method_18798().method_10216(), boat.method_18798().method_10215(), Math.toRadians(((BoatEntityAccess)boat).getYawVelocity()), false, -1, boat.method_5628(), boat.method_47885() == class_1690.class_1692.field_7725, boat.method_47885() == class_1690.class_1692.field_7729);
        world.addBody((PhysicsBody)physicsBoat);
        int movingPlatformIndex = -1;
        for (MovingPlatform movingPlatform : ClientMovingPlatformsHandler.movingPlatforms) {
            ++movingPlatformIndex;
            Vec3dAndYaw vec3dAndYaw = movingPlatform.getCurrentPosAndYaw(BodkinBoats.TICK_TIME_STAMP);
            if (boat.method_19538().field_1351 > vec3dAndYaw.vec3d().field_1351 + (double)movingPlatform.sizeY / 2.0 + (double)upCheck || boat.method_19538().field_1351 < vec3dAndYaw.vec3d().field_1351 + (double)movingPlatform.sizeY / 2.0 - 0.5) continue;
            PhysicsBoat movingPlatformBody = new PhysicsBoat(vec3dAndYaw.vec3d().field_1352, vec3dAndYaw.vec3d().field_1350, Math.toRadians(-vec3dAndYaw.yaw() % 360.0f), 0.0, 0.0, 0.0, true, movingPlatformIndex, -1, false, false);
            movingPlatformBody.removeAllFixtures();
            movingPlatformBody.addFixture((Convex)Geometry.createRectangle((double)movingPlatform.sizeX, (double)movingPlatform.sizeZ), 100.0, 0.0, 0.4);
            movingPlatformBody.updateMass();
            world.addBody((PhysicsBody)movingPlatformBody);
        }
        world.step(1);
        Iterator it = world.getCollisionDataIterator();
        while (it.hasNext()) {
            WorldCollisionData collisionData = (WorldCollisionData)it.next();
            if (!(collisionData.getPenetration().getDepth() > 0.0)) continue;
            if (((PhysicsBoat)collisionData.getBody1()).movingPlatformIndex != -1) {
                return Optional.of(ClientMovingPlatformsHandler.movingPlatforms.get(((PhysicsBoat)collisionData.getBody1()).movingPlatformIndex));
            }
            if (((PhysicsBoat)collisionData.getBody2()).movingPlatformIndex == -1) continue;
            return Optional.of(ClientMovingPlatformsHandler.movingPlatforms.get(((PhysicsBoat)collisionData.getBody2()).movingPlatformIndex));
        }
        return Optional.empty();
    }

    public static void doBoatPhysics(class_1690 boat, class_1297 passenger, float move01, float vel01) {
        class_1309 livingEntity;
        World world = new World();
        world.setGravity(0.0, 0.0);
        world.getSettings().setContinuousDetectionMode(ContinuousDetectionMode.ALL);
        PhysicsBoat physicsBoat = new PhysicsBoat(boat.method_23317(), boat.method_23321(), Math.toRadians(boat.method_36454()), boat.method_18798().method_10216(), boat.method_18798().method_10215(), Math.toRadians(((BoatEntityAccess)boat).getYawVelocity()), false, -1, boat.method_5628(), boat.method_47885() == class_1690.class_1692.field_7725, boat.method_47885() == class_1690.class_1692.field_7729);
        world.addBody((PhysicsBody)physicsBoat);
        if (!(passenger instanceof class_1309) || !(livingEntity = (class_1309)passenger).method_6059(BodkinBoats.GHOST_EFFECT)) {
            List otherBoats = boat.method_37908().method_8333((class_1297)boat, boat.method_5829().method_1009(15.0, (double)-0.01f, 15.0), x -> x instanceof class_1690);
            for (Object otherBoat : otherBoats) {
                class_1657 otherBoatPlayerEntity;
                class_1297 class_12972;
                if (otherBoat.method_5703(x -> x instanceof class_1657) && (class_12972 = otherBoat.method_31483()) instanceof class_1657 && ((otherBoatPlayerEntity = (class_1657)class_12972).method_6059(BodkinBoats.WARP_EFFECT) || otherBoatPlayerEntity.method_6059(BodkinBoats.GHOST_EFFECT))) continue;
                world.addBody((PhysicsBody)new PhysicsBoat(otherBoat.method_23317(), otherBoat.method_23321(), Math.toRadians(otherBoat.method_36454()), otherBoat.method_18798().method_10216(), otherBoat.method_18798().method_10215(), Math.toRadians(((BoatEntityAccess)otherBoat).getYawVelocity()), true, -1, otherBoat.method_5628(), ((class_1690)otherBoat).method_47885() == class_1690.class_1692.field_7725, boat.method_47885() == class_1690.class_1692.field_7729));
                if (!(otherBoat.method_18798().method_1027() > 1.0)) continue;
                world.addBody((PhysicsBody)new PhysicsBoat(otherBoat.method_23317() + otherBoat.method_18798().method_10216() * -0.3, otherBoat.method_23321() + otherBoat.method_18798().method_10215() * -0.3, Math.toRadians(otherBoat.method_36454()), otherBoat.method_18798().method_10216(), otherBoat.method_18798().method_10215(), Math.toRadians(((BoatEntityAccess)otherBoat).getYawVelocity()), true, -1, otherBoat.method_5628(), ((class_1690)otherBoat).method_47885() == class_1690.class_1692.field_7725, boat.method_47885() == class_1690.class_1692.field_7729));
                world.addBody((PhysicsBody)new PhysicsBoat(otherBoat.method_23317() + otherBoat.method_18798().method_10216() * -0.6, otherBoat.method_23321() + otherBoat.method_18798().method_10215() * -0.6, Math.toRadians(otherBoat.method_36454()), otherBoat.method_18798().method_10216(), otherBoat.method_18798().method_10215(), Math.toRadians(((BoatEntityAccess)otherBoat).getYawVelocity()), true, -1, otherBoat.method_5628(), ((class_1690)otherBoat).method_47885() == class_1690.class_1692.field_7725, boat.method_47885() == class_1690.class_1692.field_7729));
            }
            int movingPlatformIndex = -1;
            if (boat.method_37908().method_8608()) {
                for (MovingPlatform movingPlatform : ClientMovingPlatformsHandler.movingPlatforms) {
                    ++movingPlatformIndex;
                    Vec3dAndYaw vec3dAndYaw = movingPlatform.getCurrentPosAndYaw(BodkinBoats.TICK_TIME_STAMP);
                    Vec3dAndYaw nextVec3dAndYaw = movingPlatform.getCurrentPosAndYaw(BodkinBoats.TICK_TIME_STAMP + 150L);
                    if (boat.method_19538().field_1351 > vec3dAndYaw.vec3d().field_1351 + (double)movingPlatform.sizeY / 2.0 - 0.5 || boat.method_19538().field_1351 < vec3dAndYaw.vec3d().field_1351 - (double)movingPlatform.sizeY / 2.0) continue;
                    PhysicsBoat movingPlatformBody = new PhysicsBoat(vec3dAndYaw.vec3d().field_1352, vec3dAndYaw.vec3d().field_1350, Math.toRadians(-vec3dAndYaw.yaw() % 360.0f), nextVec3dAndYaw.vec3d().field_1352 - vec3dAndYaw.vec3d().field_1352, nextVec3dAndYaw.vec3d().field_1350 - vec3dAndYaw.vec3d().field_1350, Math.toRadians(nextVec3dAndYaw.yaw() - vec3dAndYaw.yaw()), true, movingPlatformIndex, -1, false, false);
                    movingPlatformBody.removeAllFixtures();
                    movingPlatformBody.addFixture((Convex)Geometry.createRectangle((double)movingPlatform.sizeX, (double)movingPlatform.sizeZ), 100.0, 0.0, 0.4);
                    movingPlatformBody.updateMass();
                    world.addBody((PhysicsBody)movingPlatformBody);
                }
            }
        }
        world.step(1);
        Iterator it = world.getCollisionDataIterator();
        while (it.hasNext()) {
            double depth;
            WorldCollisionData collisionData = (WorldCollisionData)it.next();
            CollisionPair collisionPair = collisionData.getPair();
            PhysicsBoat bodyA = (PhysicsBoat)((CollisionItem)collisionPair.getFirst()).getBody();
            PhysicsBoat bodyB = (PhysicsBoat)((CollisionItem)collisionPair.getSecond()).getBody();
            if (bodyA != physicsBoat && bodyB != physicsBoat || (depth = collisionData.getPenetration().getDepth()) <= 0.0) continue;
            Vector2 move = collisionData.getPenetration().getNormal().product(depth);
            boat.method_5784(class_1313.field_6308, new class_243(-move.x * (double)move01, 0.0, -move.y * (double)move01));
            double collisionSpeed = boat.method_18798().method_1027();
            if (lastCollision.getOrDefault(boat.method_5628(), 0L) < BodkinBoats.TICK_TIME_STAMP - 100L) {
                if (collisionSpeed > (double)0.2f && depth > (double)0.1f) {
                    boat.method_37908().method_8486(boat.method_23317(), boat.method_23318(), boat.method_23321(), BodkinBoats.LARGE_COLLISION_SOUND, class_3419.field_15254, 1.0f, 0.5f, true);
                } else if (collisionSpeed > (double)0.02f) {
                    boat.method_37908().method_8486(boat.method_23317(), boat.method_23318(), boat.method_23321(), BodkinBoats.SMALL_COLLISION_SOUND, class_3419.field_15254, 1.0f, 0.7f, true);
                }
            }
            lastCollision.put(boat.method_5628(), BodkinBoats.TICK_TIME_STAMP);
        }
        Vector2 newVel = physicsBoat.getLinearVelocity();
        Vector2 changeInPos = physicsBoat.getChangeInPosition();
        double velX = BoatPhysics.linearInterpolation(boat.method_18798().field_1352, newVel.x, vel01);
        double velZ = BoatPhysics.linearInterpolation(boat.method_18798().field_1350, newVel.y, vel01);
        boat.method_18800(velX, boat.method_18798().field_1351, velZ);
        ((BoatEntityAccess)boat).setYawVelocity((float)BoatPhysics.linearInterpolation(((BoatEntityAccess)boat).getYawVelocity(), Math.toDegrees(physicsBoat.getAngularVelocity()), 0.2f));
    }

    static double linearInterpolation(double a, double b, double f) {
        return a * (1.0 - f) + b * f;
    }
}

