/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1472;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.entities.fireball_power_up.FireballPowerUpEntity;
import uk.co.cablepost.bodkin_boats.misc.PitchAndYaw;
import uk.co.cablepost.bodkin_boats.network.ToTrackPayload;
import uk.co.cablepost.bodkin_boats.track.BbRacingScoreboard;
import uk.co.cablepost.bodkin_boats.track.LatestCheckpointForPlayer;
import uk.co.cablepost.bodkin_boats.track.MediaRoomScreen;
import uk.co.cablepost.bodkin_boats.track.TrackCamera;

@Environment(value=EnvType.CLIENT)
public class TrackCameraSystem {
    public static boolean trackFirst = false;
    public static boolean trackInteresting = true;
    public static UUID playerToTrack = null;
    public static Vector3f positionToTrack = null;
    public static TrackCamera trackCamera;
    public static int updatePlayerToTrackToFirstCounter;
    public static int raceGridPersonCycleCounter;
    public static int updateStaticCameraToLookThoughOnIdleCounter;
    public static int staticCameraToLookThoughOnIdle;
    public static int updateStaticCameraToLookThoughForPreviewCounter;
    public static int staticCameraToLookThoughForPreview;
    public static int updatePlayerToTrackToInterestingCounter;
    public static int changeTrackCameraCooldown;

    public static void onToTrackPacket(ToTrackPayload payload, class_638 clientWorld) {
        UUID payloadUuid = UUID.fromString(payload.playerUuid());
        if (playerToTrack != null && playerToTrack.equals(payloadUuid) && (clientWorld == null || clientWorld.method_18470(playerToTrack) == null)) {
            positionToTrack = payload.position();
        }
    }

    public static void updatePlayerToTrackToFirst() {
        List<class_742> players;
        List<LatestCheckpointForPlayer> scoreboardList;
        Object first;
        class_638 class_6382;
        if (class_310.method_1551().field_1687 == null) {
            playerToTrack = null;
            return;
        }
        if (++updatePlayerToTrackToFirstCounter % 40 == 39) {
            ++raceGridPersonCycleCounter;
        }
        Stream<LatestCheckpointForPlayer> scoreboard = BbRacingScoreboard.getLatestCheckpointForPlayerStream();
        if (BodkinBoatsClient.RACE_STATE == 0 && (class_6382 = class_310.method_1551().field_1687) instanceof class_638) {
            class_638 clientWorld = class_6382;
            first = scoreboard.filter(x -> x.lap <= BodkinBoatsClient.MAX_LAPS && clientWorld.method_18470(x.uuid) != null).findFirst();
            if (((Optional)first).isEmpty()) {
                playerToTrack = null;
                return;
            }
            playerToTrack = ((LatestCheckpointForPlayer)((Optional)first).get()).uuid;
            return;
        }
        if (BodkinBoatsClient.RACE_STATE == 8 && (first = class_310.method_1551().field_1687) instanceof class_638) {
            class_638 clientWorld = first;
            for (class_1297 e : clientWorld.method_18112()) {
                if (!(e instanceof class_1472)) continue;
                class_1472 sheepEntity = (class_1472)e;
                playerToTrack = e.method_5667();
                return;
            }
        }
        if (!((scoreboardList = scoreboard.toList()).isEmpty() || playerToTrack != null && class_310.method_1551().field_1687.method_18470(playerToTrack) != null && updatePlayerToTrackToFirstCounter % 40 != 39)) {
            LatestCheckpointForPlayer player = scoreboardList.get(raceGridPersonCycleCounter % scoreboardList.size());
            playerToTrack = player.uuid;
        }
        if ((players = class_310.method_1551().field_1687.method_18456().stream().filter(pl -> pl.method_5854() instanceof class_1690).toList()).isEmpty()) {
            playerToTrack = null;
            return;
        }
        class_742 player = players.get(raceGridPersonCycleCounter % players.size());
        playerToTrack = player.method_5667();
    }

    public static void updatePlayerToTrackToInteresting() {
        if (class_310.method_1551().field_1687 == null) {
            playerToTrack = null;
            updatePlayerToTrackToInterestingCounter = 999;
            return;
        }
        if (++updatePlayerToTrackToInterestingCounter <= 40) {
            return;
        }
        updatePlayerToTrackToInterestingCounter = 0;
        int mostInterestingScore = 0;
        List<class_742> players = class_310.method_1551().field_1687.method_18456().stream().filter(pl -> pl.method_5854() instanceof class_1690).toList();
        if (players.isEmpty()) {
            TrackCameraSystem.updatePlayerToTrackToFirst();
            return;
        }
        for (class_742 player : players) {
            class_638 class_6382;
            List vexEntities;
            List fireballEntities;
            List boatEntities;
            class_1690 boat = (class_1690)player.method_5854();
            if (boat == null) continue;
            int score = 0;
            if (boat.method_18798().method_1033() > (double)0.1f) {
                ++score;
            }
            if (Math.abs(boat.method_18798().field_1351) > 0.5) {
                ++score;
            }
            if (boat.method_60953()) {
                score += 2;
            }
            if (player.method_6059(BodkinBoats.VEXING_EFFECT)) {
                score += 2;
            }
            if ((boatEntities = player.method_37908().method_8390(class_1690.class, boat.method_5829().method_1014(4.0), class_1301.field_6155)).size() > 1) {
                ++score;
            }
            if (!(fireballEntities = player.method_37908().method_8390(FireballPowerUpEntity.class, boat.method_5829().method_1014(8.0), class_1301.field_6155)).isEmpty()) {
                ++score;
            }
            if (!(vexEntities = player.method_37908().method_8390(class_1634.class, boat.method_5829().method_1014(8.0), class_1301.field_6155)).isEmpty()) {
                score += 3;
            }
            if (BodkinBoatsClient.RACE_STATE == 0 && (class_6382 = class_310.method_1551().field_1687) instanceof class_638) {
                class_638 clientWorld = class_6382;
                Stream<LatestCheckpointForPlayer> scoreboard = BbRacingScoreboard.getLatestCheckpointForPlayerStream();
                Optional<LatestCheckpointForPlayer> first = scoreboard.filter(x -> x.lap <= BodkinBoatsClient.MAX_LAPS && clientWorld.method_18470(x.uuid) != null).findFirst();
                if (first.isPresent() && first.get().uuid.equals(player.method_5667())) {
                    ++score;
                }
            }
            if (score < mostInterestingScore) continue;
            playerToTrack = player.method_5667();
            mostInterestingScore = score;
        }
    }

    public static TrackCamera getTrackCamera(class_310 client) {
        Object playerEntity;
        class_638 clientWorld;
        Object object;
        if (positionToTrack == null) {
            List<TrackCamera> staticCameras;
            if (++updateStaticCameraToLookThoughOnIdleCounter > 80) {
                updateStaticCameraToLookThoughOnIdleCounter = 0;
                ++staticCameraToLookThoughOnIdle;
            }
            if ((staticCameras = BodkinBoatsClient.TRACK_CAMERAS.stream().filter(cam -> cam.fixedYaw() && !cam.getMediaRoom()).toList()).isEmpty()) {
                return null;
            }
            return staticCameras.get(staticCameraToLookThoughOnIdle % staticCameras.size());
        }
        if (++changeTrackCameraCooldown < 20) {
            return trackCamera;
        }
        changeTrackCameraCooldown = 0;
        if (playerToTrack != null && (object = class_310.method_1551().field_1687) instanceof class_638 && (object = (clientWorld = object).method_18470(playerToTrack)) instanceof class_1657 && (object = (playerEntity = object).method_5854()) instanceof class_1690) {
            class_1690 boatEntity = (class_1690)object;
            List boatsAheadAndToLeft = boatEntity.method_37908().method_8390(class_1690.class, boatEntity.method_5829().method_997(BodkinBoats.rotateOffset(new class_243(-9.0, 0.0, 9.0), boatEntity.method_36455(), boatEntity.method_36454())).method_1014(20.0), class_1301.field_6155);
            if (boatsAheadAndToLeft.size() > 1 && boatEntity.method_59922().method_43057() < 0.1f) {
                TrackCamera trackCamera1 = new TrackCamera(class_2338.field_10980, 0.0f, 0.0f, 60, 1);
                trackCamera1.cameraFixedTo = playerToTrack;
                trackCamera1.cameraFixedToOffset = new class_243((double)-0.8f, (double)0.7f, -0.5);
                changeTrackCameraCooldown = -30;
                return trackCamera1;
            }
            List boatsAheadAndToRight = boatEntity.method_37908().method_8390(class_1690.class, boatEntity.method_5829().method_997(BodkinBoats.rotateOffset(new class_243(9.0, 0.0, 9.0), boatEntity.method_36455(), boatEntity.method_36454())).method_1014(20.0), class_1301.field_6155);
            if (boatsAheadAndToRight.size() > 1 && boatEntity.method_59922().method_43057() < 0.1f) {
                TrackCamera trackCamera1 = new TrackCamera(class_2338.field_10980, 0.0f, 0.0f, 60, 1);
                trackCamera1.cameraFixedTo = playerToTrack;
                trackCamera1.cameraFixedToOffset = new class_243((double)0.8f, (double)0.7f, -0.5);
                changeTrackCameraCooldown = -30;
                return trackCamera1;
            }
            if (boatEntity.method_60953() && boatEntity.method_59922().method_43057() < 0.2f) {
                TrackCamera trackCamera1 = new TrackCamera(class_2338.field_10980, 0.0f, 15.0f, 60, 1);
                trackCamera1.cameraFixedTo = playerToTrack;
                trackCamera1.cameraFixedToOffset = new class_243(0.0, (double)1.2f, (double)-0.1f);
                changeTrackCameraCooldown = -30;
                return trackCamera1;
            }
            List fireballEntitiesBehind = boatEntity.method_37908().method_8390(FireballPowerUpEntity.class, boatEntity.method_5829().method_997(BodkinBoats.rotateOffset(new class_243(0.0, 0.0, -9.0), boatEntity.method_36455(), boatEntity.method_36454())).method_1014(20.0), class_1301.field_6155);
            List vexEntitiesBehind = boatEntity.method_37908().method_8390(class_1634.class, boatEntity.method_5829().method_997(BodkinBoats.rotateOffset(new class_243(0.0, 0.0, -9.0), boatEntity.method_36455(), boatEntity.method_36454())).method_1014(20.0), class_1301.field_6155);
            if (!(fireballEntitiesBehind.isEmpty() && vexEntitiesBehind.isEmpty() || !(boatEntity.method_59922().method_43057() < 0.4f))) {
                TrackCamera trackCamera1 = new TrackCamera(class_2338.field_10980, 180.0f, 20.0f, 60, 1);
                trackCamera1.cameraFixedTo = playerToTrack;
                trackCamera1.cameraFixedToOffset = new class_243(0.0, (double)0.9f, (double)-0.6f);
                changeTrackCameraCooldown = -60;
                return trackCamera1;
            }
        }
        TrackCamera toRet = null;
        double closestDistance = Double.MAX_VALUE;
        for (TrackCamera trackCamera : BodkinBoatsClient.TRACK_CAMERAS) {
            boolean fixed;
            if (trackCamera.getMediaRoom()) continue;
            class_243 camPos = trackCamera.pos.method_46558();
            double distance = camPos.method_1028((double)TrackCameraSystem.positionToTrack.x, (double)TrackCameraSystem.positionToTrack.y, (double)TrackCameraSystem.positionToTrack.z);
            boolean bl = fixed = trackCamera.fixedPitch() && trackCamera.fixedYaw();
            if (!(distance < closestDistance) || BodkinBoatsClient.RACE_STATE != 4 && BodkinBoatsClient.RACE_STATE != 3 && BodkinBoatsClient.RACE_STATE != 2 && BodkinBoatsClient.RACE_STATE != 1 && fixed && !TrackCameraSystem.inFrame(client, trackCamera)) continue;
            closestDistance = distance;
            toRet = trackCamera;
        }
        return toRet;
    }

    public static void onTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || BodkinBoatsClient.TRACK_CAMERAS == null || BodkinBoatsClient.TRACK_CAMERAS.isEmpty()) {
            return;
        }
        if (++updateStaticCameraToLookThoughForPreviewCounter > 24) {
            updateStaticCameraToLookThoughForPreviewCounter = 0;
            ++staticCameraToLookThoughForPreview;
        }
        if (trackFirst) {
            TrackCameraSystem.updatePlayerToTrackToFirst();
        } else if (trackInteresting) {
            TrackCameraSystem.updatePlayerToTrackToInteresting();
        }
        if (playerToTrack != null) {
            class_638 playerEntity;
            class_638 clientWorld;
            class_638 class_6382 = class_310.method_1551().field_1687;
            if (class_6382 instanceof class_638 && (class_6382 = (clientWorld = class_6382).method_18470(playerToTrack)) instanceof class_1657 && (class_6382 = (playerEntity = class_6382).method_5854()) instanceof class_1690) {
                class_1690 boatEntity = (class_1690)class_6382;
                class_243 pos = boatEntity.method_30950(0.0f);
                positionToTrack = new Vector3f((float)pos.field_1352, (float)pos.field_1351 + 1.0f, (float)pos.field_1350);
            } else {
                class_638 class_6383 = class_310.method_1551().field_1687;
                if (class_6383 instanceof class_638) {
                    class_638 clientWorld2 = class_6383;
                    for (class_1297 e : clientWorld2.method_18112()) {
                        class_1297 class_12972;
                        class_1472 sheepEntity;
                        if (!(e instanceof class_1472) || !(sheepEntity = (class_1472)e).method_5667().equals(playerToTrack) || !((class_12972 = sheepEntity.method_5854()) instanceof class_1690)) continue;
                        class_1690 boatEntity = (class_1690)class_12972;
                        class_243 pos = boatEntity.method_30950(0.0f);
                        positionToTrack = new Vector3f((float)pos.field_1352 + 0.5f, (float)pos.field_1351, (float)pos.field_1350 + 0.5f);
                        break;
                    }
                }
            }
        } else {
            positionToTrack = null;
        }
        TrackCamera trackCameraBefore = trackCamera;
        trackCamera = TrackCameraSystem.getTrackCamera(client);
        if (trackCamera == null) {
            return;
        }
        if (trackCameraBefore != null && !trackCameraBefore.equals(trackCamera) && client.field_1724.method_6059(BodkinBoats.SPECTATOR_CAM_EFFECT) && !trackCamera.fixedYaw() && TrackCameraSystem.trackCamera.cameraFixedTo == null) {
            PitchAndYaw targetPitchAndYaw = BodkinBoats.getPitchAndYawTo(trackCamera.getPos().method_46558(), new class_243((double)TrackCameraSystem.positionToTrack.x, (double)TrackCameraSystem.positionToTrack.y, (double)TrackCameraSystem.positionToTrack.z));
            client.field_1724.method_36457(targetPitchAndYaw.pitch());
            client.field_1724.method_36456(targetPitchAndYaw.yaw());
            MediaRoomScreen.CAM_PITCH = targetPitchAndYaw.pitch();
            MediaRoomScreen.CAM_YAW = targetPitchAndYaw.yaw();
        }
        if (client.field_1724.method_6059(BodkinBoats.SPECTATOR_CAM_EFFECT)) {
            client.field_1690.method_41808().method_41748((Object)Math.max(30, trackCamera.getFov()));
        }
    }

    public static boolean inFrame(class_310 client, TrackCamera trackCamera) {
        class_638 playerEntity;
        class_638 clientWorld;
        Quaternionf cameraQuaternionf = new Quaternionf();
        cameraQuaternionf.rotationYXZ((float)Math.PI - trackCamera.getYaw() * ((float)Math.PI / 180), -trackCamera.getPitch() * ((float)Math.PI / 180), 0.0f);
        cameraQuaternionf = cameraQuaternionf.conjugate(new Quaternionf());
        Matrix4f cameraRotationMatrix = new Matrix4f().rotation((Quaternionfc)cameraQuaternionf);
        Matrix4f projectionMatrix = client.field_1773.method_22973((double)Math.max(30.0f, (float)trackCamera.getFov() / 2.0f));
        class_4604 cameraFrustum = new class_4604(cameraRotationMatrix, projectionMatrix);
        cameraFrustum.method_23088((double)trackCamera.getX(), (double)trackCamera.getY(), (double)trackCamera.getZ());
        Vector3f pos = positionToTrack;
        class_638 class_6382 = class_310.method_1551().field_1687;
        if (class_6382 instanceof class_638 && (class_6382 = (clientWorld = class_6382).method_18470(playerToTrack)) instanceof class_1657 && (class_6382 = (playerEntity = class_6382).method_5854()) instanceof class_1690) {
            class_1690 boatEntity = (class_1690)class_6382;
            pos = pos.add((Vector3fc)boatEntity.method_18798().method_46409().mul(2.0f));
        }
        return cameraFrustum.method_23093(new class_238((double)(pos.x - 1.0f), (double)(pos.y - 1.0f), (double)(pos.z - 1.0f), (double)(pos.x + 1.0f), (double)(pos.y + 1.0f), (double)(pos.z + 1.0f)));
    }

    public static class_243 getPos(float tickDelta) {
        class_638 playerEntity;
        class_638 clientWorld;
        class_638 class_6382;
        if (trackCamera == null) {
            return new class_243(0.0, 0.0, 0.0);
        }
        if (TrackCameraSystem.trackCamera.cameraFixedTo != null && (class_6382 = class_310.method_1551().field_1687) instanceof class_638 && (class_6382 = (clientWorld = class_6382).method_18470(TrackCameraSystem.trackCamera.cameraFixedTo)) instanceof class_1657 && (class_6382 = (playerEntity = class_6382).method_5854()) instanceof class_1690) {
            class_1690 boatEntity = (class_1690)class_6382;
            class_243 pos = boatEntity.method_30950(tickDelta);
            return pos.method_1019(BodkinBoats.rotateOffset(TrackCameraSystem.trackCamera.cameraFixedToOffset, boatEntity.method_5695(tickDelta), boatEntity.method_5705(tickDelta)));
        }
        return trackCamera.getPos().method_46558();
    }

    @Nullable
    public static PitchAndYaw getPitchAndYaw(float tickDelta, double currentPitch, double currentYaw) {
        double targetYaw;
        class_638 playerEntity;
        class_638 clientWorld;
        class_638 class_6382;
        if (playerToTrack != null && (class_6382 = class_310.method_1551().field_1687) instanceof class_638 && (class_6382 = (clientWorld = class_6382).method_18470(playerToTrack)) instanceof class_1657 && (class_6382 = (playerEntity = class_6382).method_5854()) instanceof class_1690) {
            class_1690 boatEntity = (class_1690)class_6382;
            class_243 pos = boatEntity.method_30950(tickDelta);
            positionToTrack = new Vector3f((float)pos.field_1352, (float)pos.field_1351 + 1.0f, (float)pos.field_1350);
            if (trackCamera != null && TrackCameraSystem.trackCamera.cameraFixedTo != null) {
                float pitch = boatEntity.method_5695(tickDelta) + TrackCameraSystem.trackCamera.pitch;
                float yaw = boatEntity.method_5705(tickDelta) + TrackCameraSystem.trackCamera.yaw;
                return new PitchAndYaw(pitch, yaw);
            }
        }
        if (positionToTrack == null) {
            if (trackCamera != null && trackCamera.fixedYaw() && trackCamera.fixedPitch()) {
                return new PitchAndYaw(trackCamera.getPitch(), trackCamera.getYaw());
            }
            return null;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || BodkinBoatsClient.TRACK_CAMERAS == null || BodkinBoatsClient.TRACK_CAMERAS.isEmpty() || trackCamera == null) {
            return null;
        }
        if (trackCamera.fixedPitch() && trackCamera.fixedYaw() && BodkinBoatsClient.RACE_STATE != 4 && BodkinBoatsClient.RACE_STATE != 3 && BodkinBoatsClient.RACE_STATE != 2 && BodkinBoatsClient.RACE_STATE != 1) {
            return new PitchAndYaw(trackCamera.getPitch(), trackCamera.getYaw());
        }
        float lerpAmt = 0.15f;
        PitchAndYaw targetPitchAndYaw = BodkinBoats.getPitchAndYawTo(trackCamera.getPos().method_46558(), new class_243((double)TrackCameraSystem.positionToTrack.x, (double)TrackCameraSystem.positionToTrack.y, (double)TrackCameraSystem.positionToTrack.z));
        double targetPitch = targetPitchAndYaw.pitch();
        for (targetYaw = (double)targetPitchAndYaw.yaw(); targetYaw < currentYaw - 180.0; targetYaw += 360.0) {
        }
        while (targetYaw > currentYaw + 180.0) {
            targetYaw -= 360.0;
        }
        if (Math.abs(targetYaw - currentYaw) > 90.0) {
            currentYaw = targetYaw;
        }
        if (Math.abs(targetPitch - currentPitch) > 90.0) {
            currentPitch = targetPitch;
        }
        return new PitchAndYaw((float)class_3532.method_16436((double)lerpAmt, (double)currentPitch, (double)targetPitch), (float)class_3532.method_16436((double)lerpAmt, (double)currentYaw, (double)targetYaw));
    }

    static {
        updatePlayerToTrackToFirstCounter = 0;
        raceGridPersonCycleCounter = 0;
        updateStaticCameraToLookThoughOnIdleCounter = 0;
        staticCameraToLookThoughOnIdle = 0;
        updateStaticCameraToLookThoughForPreviewCounter = 0;
        staticCameraToLookThoughForPreview = 0;
        updatePlayerToTrackToInterestingCounter = 0;
        changeTrackCameraCooldown = 0;
    }
}

