/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket;

import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.Bucket;
import uk.co.cablepost.bodkin_boats.ai.train_ev_to_bucket.State;

public class BucketHelper {
    public static Bucket[] DISTANCE_BUCKETS = new Bucket[]{Bucket.of(8.0f, Float.MAX_VALUE), Bucket.of(5.0f, 8.0f), Bucket.of(3.0f, 5.0f), Bucket.of(2.0f, 3.0f), Bucket.of(1.5f, 2.0f), Bucket.of(0.0f, 1.5f)};
    public static Bucket[] ANGLE_BUCKETS = new Bucket[]{Bucket.of(-0.62831855f, 0.0f), Bucket.of(0.62831855f, 0.0f), Bucket.of(-1.2566371f, -0.62831855f), Bucket.of(1.2566371f, 0.62831855f), Bucket.of(-1.8849558f, -1.2566371f), Bucket.of(1.8849558f, 1.2566371f), Bucket.of(-2.5132742f, -1.8849558f), Bucket.of(2.5132742f, 1.8849558f), Bucket.of(-3.4028235E38f, -2.5132742f), Bucket.of(Float.MAX_VALUE, 2.5132742f)};
    public static Bucket[] VELOCITY_BUCKETS = new Bucket[]{Bucket.of(-0.25f, -0.0f), Bucket.of(0.25f, 0.0f), Bucket.of(-0.5f, -0.25f), Bucket.of(0.5f, 0.25f), Bucket.of(-0.75f, -0.5f), Bucket.of(0.75f, 0.5f), Bucket.of(-1.0f, -0.75f), Bucket.of(1.0f, 0.75f), Bucket.of(-1.5f, -1.0f), Bucket.of(1.5f, 1.0f), Bucket.of(-2.0f, -1.5f), Bucket.of(2.0f, 1.5f), Bucket.of(-3.0f, -2.0f), Bucket.of(3.0f, 2.0f), Bucket.of(-4.0f, -3.0f), Bucket.of(4.0f, 3.0f), Bucket.of(-6.0f, -4.0f), Bucket.of(6.0f, 4.0f), Bucket.of(-3.4028235E38f, -6.0f), Bucket.of(Float.MAX_VALUE, 6.0f)};
    public static Bucket[] ANGLE_VELOCITY_BUCKETS = new Bucket[]{Bucket.of(-0.15707964f, 0.0f), Bucket.of(0.15707964f, 0.0f), Bucket.of(-0.31415927f, -0.15707964f), Bucket.of(0.31415927f, 0.15707964f), Bucket.of(-0.47123894f, -0.31415927f), Bucket.of(0.47123894f, 0.31415927f), Bucket.of(-0.62831855f, -0.47123894f), Bucket.of(0.62831855f, 0.47123894f), Bucket.of(-3.4028235E38f, -0.62831855f), Bucket.of(Float.MAX_VALUE, 0.62831855f)};
    public static int TOTAL_BUCKETS = DISTANCE_BUCKETS.length * ANGLE_BUCKETS.length * VELOCITY_BUCKETS.length * VELOCITY_BUCKETS.length * ANGLE_VELOCITY_BUCKETS.length;

    public static int getBucket(Bucket[] buckets, float value) {
        for (int i = 0; i < buckets.length; ++i) {
            if (!buckets[i].inBucket(value)) continue;
            return i;
        }
        throw new RuntimeException("Value " + value + " does not have a valid bucket");
    }

    public static float getBucketValue(Bucket[] buckets, int bucket) {
        return buckets[bucket].getMidpoint();
    }

    public static int getBucketIndexForState(State state) {
        int distanceBucket = BucketHelper.getBucket(DISTANCE_BUCKETS, state.distanceToWaypoint());
        int angleBucket = BucketHelper.getBucket(ANGLE_BUCKETS, state.angleToWaypoint());
        int velXBucket = BucketHelper.getBucket(VELOCITY_BUCKETS, state.velX());
        int velYBucket = BucketHelper.getBucket(VELOCITY_BUCKETS, state.velY());
        int yawVelBucket = BucketHelper.getBucket(ANGLE_VELOCITY_BUCKETS, state.velYaw());
        return (((distanceBucket * ANGLE_BUCKETS.length + angleBucket) * VELOCITY_BUCKETS.length + velXBucket) * VELOCITY_BUCKETS.length + velYBucket) * ANGLE_VELOCITY_BUCKETS.length + yawVelBucket;
    }

    public static State getStateFromBucketIndex(int index) {
        int yawVelBucket = index % ANGLE_VELOCITY_BUCKETS.length;
        int velYBucket = (index /= ANGLE_VELOCITY_BUCKETS.length) % VELOCITY_BUCKETS.length;
        int velXBucket = (index /= VELOCITY_BUCKETS.length) % VELOCITY_BUCKETS.length;
        int angleBucket = (index /= VELOCITY_BUCKETS.length) % ANGLE_BUCKETS.length;
        int distanceBucket = index /= ANGLE_BUCKETS.length;
        float distance = BucketHelper.getBucketValue(DISTANCE_BUCKETS, distanceBucket);
        float angle = BucketHelper.getBucketValue(ANGLE_BUCKETS, angleBucket);
        float velX = BucketHelper.getBucketValue(VELOCITY_BUCKETS, velXBucket);
        float velY = BucketHelper.getBucketValue(VELOCITY_BUCKETS, velYBucket);
        float yawVel = BucketHelper.getBucketValue(ANGLE_VELOCITY_BUCKETS, yawVelBucket);
        return new State(distance, angle, velX, velY, yawVel);
    }
}

