/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector3f;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.entities.towable.TowableEntity;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.network.BodkinBoatPayload;

public record TowableEntityPayload(int entityId, Vector3f position, Vector3f velocity, float yaw, long time) implements class_8710
{
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"towable_entity_packet");
    public static final class_8710.class_9154<TowableEntityPayload> PACKET_ID = new class_8710.class_9154(IDENTIFIER);
    public static final class_9139<class_9129, TowableEntityPayload> CODEC = class_9139.method_56906((class_9139)class_9135.field_49675, TowableEntityPayload::entityId, (class_9139)class_9135.field_48558, TowableEntityPayload::position, (class_9139)class_9135.field_48558, TowableEntityPayload::velocity, (class_9139)class_9135.field_48552, TowableEntityPayload::yaw, (class_9139)class_9135.field_48551, TowableEntityPayload::time, TowableEntityPayload::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static TowableEntityPayload getPacket(TowableEntity towableEntity) {
        class_243 vel = towableEntity.method_18798();
        return new TowableEntityPayload(towableEntity.method_5628(), new Vector3f((float)towableEntity.method_23317(), (float)towableEntity.method_23318(), (float)towableEntity.method_23321()), new Vector3f((float)vel.field_1352, (float)vel.field_1351, (float)vel.field_1350), towableEntity.method_36454(), NtpTimeSync.getTrueTime());
    }

    public static void onServerReceive(TowableEntityPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1297 entity = context.player().method_37908().method_8469(payload.entityId);
            if (entity instanceof TowableEntity) {
                TowableEntity towableEntity = (TowableEntity)entity;
                long now = NtpTimeSync.getTrueTime();
                long dif = now - payload.time();
                TowableEntityPayload.updateTowableFromPacket(payload, towableEntity, dif);
                if (entity.method_5628() == payload.entityId) {
                    for (class_3222 serverPlayerEntity : context.server().method_3760().method_14571()) {
                        if (serverPlayerEntity.equals((Object)context.player())) continue;
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)payload);
                    }
                }
            }
        });
    }

    public static void onClientReceive(TowableEntityPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            long now = NtpTimeSync.getTrueTime();
            long dif = now - payload.time();
            class_1297 entity = context.player().method_37908().method_8469(payload.entityId);
            if (entity == null) {
                return;
            }
            if (entity instanceof TowableEntity) {
                TowableEntity towableEntity = (TowableEntity)entity;
                if (towableEntity.method_5787()) {
                    return;
                }
                TowableEntityPayload.updateTowableFromPacket(payload, towableEntity, dif);
            }
        });
    }

    public static void updateTowableFromPacket(TowableEntityPayload payload, TowableEntity towableEntity, long dif) {
        if (dif < 0L || dif > 10000L) {
            dif = 0L;
        }
        class_243 class_2432 = new class_243((double)payload.position().x, (double)payload.position().y, (double)payload.position().z);
        if (towableEntity.method_19538().method_1025(class_2432) > 100.0) {
            towableEntity.method_23327(payload.position().x(), payload.position().y(), payload.position().z());
        }
        class_243 move = new class_243((double)payload.velocity().x(), (double)payload.velocity().y(), (double)payload.velocity().z()).method_1021((double)((float)dif / BodkinBoatPayload.MOVE_DIV));
        class_243 targetPos = new class_243((double)payload.position().x() + move.field_1352, (double)payload.position().y(), (double)payload.position().z() + move.field_1350);
        towableEntity.method_18799(new class_243((double)payload.velocity().x() + (targetPos.field_1352 - towableEntity.method_23317()) * (double)BodkinBoatPayload.CATCH_UP_VEL_MUL, (double)payload.velocity().y() + (targetPos.field_1351 - towableEntity.method_23318()) * (double)BodkinBoatPayload.CATCH_UP_VEL_MUL, (double)payload.velocity().z() + (targetPos.field_1350 - towableEntity.method_23321()) * (double)BodkinBoatPayload.CATCH_UP_VEL_MUL));
        towableEntity.method_36456(payload.yaw);
    }
}

