/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector3f;
import uk.co.cablepost.bodkin_boats.BodkinBoats;
import uk.co.cablepost.bodkin_boats.BodkinBoatsClient;
import uk.co.cablepost.bodkin_boats.misc.NtpTimeSync;
import uk.co.cablepost.bodkin_boats.mixin.BoatEntityAccess;
import uk.co.cablepost.bodkin_boats.network.BodkinBoatPayloadAndDif;
import uk.co.cablepost.bodkin_boats.network.ToTrackPayload;
import uk.co.cablepost.bodkin_boats.track.BrsHandler;
import uk.co.cablepost.bodkin_boats.track.HornHandler;

public record BodkinBoatPayload(int boatId, Vector3f velocity, Vector3f yawAndYawVel, Vector3f input, long time, Vector3f pos) implements class_8710
{
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)BodkinBoats.MOD_ID, (String)"bodkin_boat_packet");
    public static final class_8710.class_9154<BodkinBoatPayload> PACKET_ID = new class_8710.class_9154(IDENTIFIER);
    public static float MOVE_DIV = 100.0f;
    public static float CATCH_UP_VEL_MUL = 0.1f;
    public static float CATCH_UP_ROT_VEL_MUL = 0.1f;
    public static final class_9139<class_9129, BodkinBoatPayload> CODEC = class_9139.method_58025((class_9139)class_9135.field_49675, BodkinBoatPayload::boatId, (class_9139)class_9135.field_48558, BodkinBoatPayload::velocity, (class_9139)class_9135.field_48558, BodkinBoatPayload::yawAndYawVel, (class_9139)class_9135.field_48558, BodkinBoatPayload::input, (class_9139)class_9135.field_48551, BodkinBoatPayload::time, (class_9139)class_9135.field_48558, BodkinBoatPayload::pos, BodkinBoatPayload::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static BodkinBoatPayload getBbPacket(class_1690 thisObject, BoatEntityAccess boatEntityAccess, boolean pressingHorn, float brsState) {
        class_243 pos = thisObject.method_19538();
        class_243 vel = thisObject.method_18798();
        float pressingForwardBack = 0.0f;
        if (boatEntityAccess.getPressingForward()) {
            pressingForwardBack = 1.0f;
        } else if (boatEntityAccess.getPressingBack()) {
            pressingForwardBack = -1.0f;
        }
        BodkinBoatPayload payload = new BodkinBoatPayload(thisObject.method_5628(), new Vector3f((float)vel.method_10216(), (float)vel.method_10214(), (float)vel.method_10215()), new Vector3f(thisObject.method_36454(), ((BoatEntityAccess)thisObject).getYawVelocity(), brsState), new Vector3f((float)((boatEntityAccess.getPressingLeft() ? -1 : 0) + (boatEntityAccess.getPressingRight() ? 1 : 0)), pressingHorn ? 1.0f : 0.0f, pressingForwardBack), NtpTimeSync.getTrueTime(), new Vector3f((float)pos.method_10216(), (float)pos.method_10214(), (float)pos.method_10215()));
        return payload;
    }

    public static void onServerReceive(BodkinBoatPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1297 vehicle = context.player().method_5854();
            if (vehicle instanceof class_1690) {
                class_1690 boatEntity = (class_1690)vehicle;
                long now = NtpTimeSync.getTrueTime();
                long dif = now - payload.time();
                BodkinBoatPayload.updateBoatFromPacket(payload, boatEntity, dif);
                if (vehicle.method_5628() == payload.boatId) {
                    for (class_3222 serverPlayerEntity : context.server().method_3760().method_14571()) {
                        if (serverPlayerEntity.equals((Object)context.player())) continue;
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)payload);
                        if (!serverPlayerEntity.method_6059(BodkinBoats.SPECTATOR_CAM_EFFECT)) continue;
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new ToTrackPayload(context.player().method_5667().toString(), payload.pos));
                    }
                }
            }
        });
    }

    public static void onClientReceive(BodkinBoatPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            long now = NtpTimeSync.getTrueTime();
            long dif = now - payload.time();
            BodkinBoatsClient.LATEST_BODKIN_BOAT_PAYLOAD.put(payload.boatId(), new BodkinBoatPayloadAndDif(payload, dif));
            class_1297 entity = context.player().method_37908().method_8469(payload.boatId());
            if (entity == null) {
                return;
            }
            if (entity instanceof class_1690) {
                class_1690 boatEntity = (class_1690)entity;
                if (boatEntity.method_5787()) {
                    return;
                }
                BodkinBoatPayload.updateBoatFromPacket(payload, boatEntity, dif);
                if (BodkinBoatsClient.RACE_STATE == 10) {
                    BodkinBoatsClient.updateSlitherPositions(context.player().method_37908().method_8428(), boatEntity, entity.method_19538());
                }
            }
        });
    }

    public static void updateBoatFromPacket(BodkinBoatPayload payload, class_1690 boatEntity, long dif) {
        if (dif < 0L || dif > 10000L) {
            dif = 0L;
        }
        class_243 class_2432 = new class_243((double)payload.pos().x, (double)payload.pos().y, (double)payload.pos().z);
        if (boatEntity.method_19538().method_1025(class_2432) > 25.0) {
            boatEntity.method_23327((double)payload.pos().x(), (double)payload.pos().y(), (double)payload.pos().z());
        }
        class_243 move = new class_243((double)payload.velocity().x(), (double)payload.velocity().y(), (double)payload.velocity().z()).method_1021((double)((float)dif / MOVE_DIV));
        class_243 targetPos = new class_243((double)payload.pos().x() + move.field_1352, (double)payload.pos().y(), (double)payload.pos().z() + move.field_1350);
        boatEntity.method_18799(new class_243((double)payload.velocity().x() + (targetPos.field_1352 - boatEntity.method_23317()) * (double)CATCH_UP_VEL_MUL, (double)payload.velocity().y() + (targetPos.field_1351 - boatEntity.method_23318()) * (double)CATCH_UP_VEL_MUL, (double)payload.velocity().z() + (targetPos.field_1350 - boatEntity.method_23321()) * (double)CATCH_UP_VEL_MUL));
        if (Math.abs(boatEntity.method_36454() - payload.yawAndYawVel().x) > 360.0f) {
            boatEntity.method_36456(payload.yawAndYawVel().x);
        }
        ((BoatEntityAccess)boatEntity).setYawVelocity(payload.yawAndYawVel().y + (payload.yawAndYawVel().x - boatEntity.method_36454()) * CATCH_UP_ROT_VEL_MUL);
        ((BoatEntityAccess)boatEntity).setPressingForward(payload.input().z > 0.5f);
        ((BoatEntityAccess)boatEntity).setPressingBack(payload.input().z < -0.5f);
        ((BoatEntityAccess)boatEntity).setPressingLeft(payload.input().x < -0.5f);
        ((BoatEntityAccess)boatEntity).setPressingRight(payload.input().x > 0.5f);
        HornHandler.setHonk(payload.boatId(), payload.input.y > 0.5f);
        BrsHandler.BRS_PER_BOAT_ID.put(payload.boatId(), Float.valueOf(payload.yawAndYawVel.z));
    }
}

