/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bodkin_boats.track;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TrackCamera {
    public class_2338 pos;
    public float yaw = 999.0f;
    public float pitch = 999.0f;
    public int fov = 999;
    public int mediaRoomAsInt = 1;
    public UUID cameraFixedTo = null;
    public class_243 cameraFixedToOffset = new class_243(0.0, 0.0, 0.0);
    public static final Codec<TrackCamera> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(TrackCamera::getPos), (App)class_5699.field_40723.fieldOf("yawPitch").forGetter(TrackCamera::getYawAndPitchAsVector3f), (App)class_5699.field_33442.fieldOf("fov").forGetter(TrackCamera::getFov), (App)class_5699.field_33442.fieldOf("mediaRoom").forGetter(TrackCamera::getMediaRoomAsInt)).apply((Applicative)instance, TrackCamera::new));
    public static final class_9139<class_9129, TrackCamera> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48558, TrackCamera::getPosAsVector3f, (class_9139)class_9135.field_48558, TrackCamera::getYawAndPitchAsVector3f, (class_9139)class_9135.field_49675, TrackCamera::getFov, (class_9139)class_9135.field_49675, TrackCamera::getMediaRoomAsInt, TrackCamera::new);

    public TrackCamera(class_2338 pos, float yaw, float pitch, int fov, int mediaRoomAsInt) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
        this.fov = fov;
        this.mediaRoomAsInt = mediaRoomAsInt;
    }

    public TrackCamera(class_2338 pos, Vector3f yawAndPitchAsVector3f, int fov, int mediaRoomAsInt) {
        this.pos = pos;
        this.yaw = yawAndPitchAsVector3f.x;
        this.pitch = yawAndPitchAsVector3f.y;
        this.fov = fov;
        this.mediaRoomAsInt = mediaRoomAsInt;
    }

    public TrackCamera(Vector3f posAsVector3f, Vector3f yawAndPitchAsVector3f, int fov, int mediaRoomAsInt) {
        this.pos = new class_2338((int)posAsVector3f.x, (int)posAsVector3f.y, (int)posAsVector3f.z);
        this.yaw = yawAndPitchAsVector3f.x;
        this.pitch = yawAndPitchAsVector3f.y;
        this.fov = fov;
        this.mediaRoomAsInt = mediaRoomAsInt;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getX() {
        return this.pos.method_10263();
    }

    public int getY() {
        return this.pos.method_10264();
    }

    public int getZ() {
        return this.pos.method_10260();
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getFov() {
        if (this.fixedFov()) {
            return this.fov;
        }
        return 90;
    }

    public boolean fixedYaw() {
        return this.yaw != 999.0f;
    }

    public boolean fixedPitch() {
        return this.pitch != 999.0f;
    }

    public boolean fixedFov() {
        return this.fov != 999;
    }

    public boolean getMediaRoom() {
        return this.mediaRoomAsInt == 2;
    }

    public int getMediaRoomAsInt() {
        return this.mediaRoomAsInt;
    }

    public Vector3f getPosAsVector3f() {
        return new Vector3f((float)this.pos.method_10263(), (float)this.pos.method_10264(), (float)this.pos.method_10260());
    }

    public Vector3f getYawAndPitchAsVector3f() {
        return new Vector3f(this.yaw, this.pitch, 0.0f);
    }

    public boolean equals(@Nullable TrackCamera other) {
        if (other == null) {
            return false;
        }
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        if (this.pitch != other.pitch) {
            return false;
        }
        if (this.yaw != other.yaw) {
            return false;
        }
        if (this.cameraFixedTo == null && other.cameraFixedTo != null) {
            return false;
        }
        if (this.cameraFixedTo != null && other.cameraFixedTo == null) {
            return false;
        }
        if (this.cameraFixedTo != null && !this.cameraFixedTo.equals(other.cameraFixedTo)) {
            return false;
        }
        if (this.cameraFixedToOffset == null && other.cameraFixedToOffset != null) {
            return false;
        }
        if (this.cameraFixedToOffset != null && other.cameraFixedToOffset == null) {
            return false;
        }
        return this.cameraFixedToOffset == null || this.cameraFixedToOffset.equals((Object)other.cameraFixedToOffset);
    }
}

