/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.smokeleaf.block;

import com.styenvy.smokeleaf.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AlchemistAshCropBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty IS_DOUBLE = BooleanProperty.create((String)"is_double");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    private static final VoxelShape[] SHAPE_BY_AGE_TOP = new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public AlchemistAshCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.ALCHEMIST_ASH_SEEDS.get();
    }

    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{AGE, HALF, IS_DOUBLE});
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        boolean isUpper;
        int age = this.getAge(state);
        boolean bl = isUpper = state.getValue(HALF) == DoubleBlockHalf.UPPER;
        if (isUpper) {
            int idx = Math.max(0, Math.min(1, age - 2));
            return SHAPE_BY_AGE_TOP[idx];
        }
        return SHAPE_BY_AGE[Math.min(age, SHAPE_BY_AGE.length - 1)];
    }

    public void randomTick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        float speed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(25.0f / (speed = AlchemistAshCropBlock.getGrowthSpeed((Block)this, (BlockGetter)level, pos))) + 1) == 0) {
            this.applyAge((Level)level, pos, state, age + 1);
        }
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState below = level.getBlockState(pos.below());
            return below.is((Block)this) && below.getValue(HALF) == DoubleBlockHalf.LOWER && (Boolean)below.getValue((Property)IS_DOUBLE) != false;
        }
        BlockState below = level.getBlockState(pos.below());
        boolean onFarmland = below.getBlock() instanceof FarmBlock;
        return onFarmland && level.getRawBrightness(pos, 0) >= 8;
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getBlock() instanceof FarmBlock;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide) {
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos abovePos = pos.above();
                BlockState above = level.getBlockState(abovePos);
                if (above.is((Block)this) && above.getValue(HALF) == DoubleBlockHalf.UPPER) {
                    level.destroyBlock(abovePos, false, (Entity)player);
                }
            } else {
                BlockPos belowPos = pos.below();
                BlockState below = level.getBlockState(belowPos);
                if (below.is((Block)this) && below.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    level.destroyBlock(belowPos, false, (Entity)player);
                }
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return false;
        }
        return this.getAge(state) < this.getMaxAge();
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        int age = this.getAge(state);
        int inc = 1 + random.nextInt(2);
        int newAge = Math.min(this.getMaxAge(), age + inc);
        this.applyAge((Level)level, pos, state, newAge);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int age = this.getAge(state);
        RandomSource rnd = builder.getOptionalParameter(LootContextParams.THIS_ENTITY) != null ? Objects.requireNonNull((Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY)).getRandom() : RandomSource.create();
        drops.add(new ItemStack(this.getBaseSeedId()));
        if (age >= this.getMaxAge()) {
            int count = 1 + rnd.nextInt(2);
            drops.add(new ItemStack((ItemLike)ModItems.ALCHEMIST_ASH.get(), count));
            if (rnd.nextFloat() < 0.5f) {
                drops.add(new ItemStack(this.getBaseSeedId()));
            }
        }
        return drops;
    }

    private void applyAge(Level level, BlockPos pos, BlockState state, int newAge) {
        BlockState above;
        boolean wasDouble = (Boolean)state.getValue((Property)IS_DOUBLE);
        boolean shouldBeDouble = newAge >= 2;
        BlockState newLower = (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(shouldBeDouble));
        level.setBlock(pos, newLower, 3);
        BlockPos abovePos = pos.above();
        if (shouldBeDouble) {
            BlockState above2 = level.getBlockState(abovePos);
            if (!above2.is((Block)this) || above2.getValue(HALF) != DoubleBlockHalf.UPPER) {
                level.setBlock(abovePos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.setBlock(abovePos, (BlockState)((BlockState)above2.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (wasDouble && (above = level.getBlockState(abovePos)).is((Block)this) && above.getValue(HALF) == DoubleBlockHalf.UPPER) {
            level.setBlock(abovePos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean sameCol;
        float f = 1.0f;
        BlockPos belowPos = pos.below();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                float local = 0.0f;
                BlockPos soilPos = belowPos.offset(dx, 0, dz);
                BlockState soil = level.getBlockState(soilPos);
                if (soil.getBlock() instanceof FarmBlock) {
                    local = 1.0f;
                    if ((Integer)soil.getValue((Property)FarmBlock.MOISTURE) > 0) {
                        local = 3.0f;
                    }
                }
                if (dx != 0 || dz != 0) {
                    local /= 4.0f;
                }
                f += local;
            }
        }
        BlockPos north = pos.north();
        BlockPos south = pos.south();
        BlockPos west = pos.west();
        BlockPos east = pos.east();
        boolean sameRow = level.getBlockState(west).is(block) || level.getBlockState(east).is(block);
        boolean bl = sameCol = level.getBlockState(north).is(block) || level.getBlockState(south).is(block);
        if (sameRow && sameCol) {
            f /= 2.0f;
        }
        return f;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction dir, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (((Boolean)state.getValue((Property)IS_DOUBLE)).booleanValue()) {
            if (!(dir != Direction.UP || half != DoubleBlockHalf.LOWER || neighbor.is((Block)this) && neighbor.getValue(HALF) == DoubleBlockHalf.UPPER)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (!(dir != Direction.DOWN || half != DoubleBlockHalf.UPPER || neighbor.is((Block)this) && neighbor.getValue(HALF) == DoubleBlockHalf.LOWER)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(state, dir, neighbor, level, pos, neighborPos);
    }
}

