/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.smokeleaf.block;

import com.styenvy.smokeleaf.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrimsonEmberleafCropBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty IS_DOUBLE = BooleanProperty.create((String)"is_double");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    private static final VoxelShape[] SHAPE_BY_AGE_TOP = new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public CrimsonEmberleafCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.CRIMSON_EMBERLEAF_SEEDS.get();
    }

    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{AGE, HALF, IS_DOUBLE});
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        int age = this.getAge(state);
        if (age >= 2 && state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_BY_AGE_TOP[age - 2];
        }
        return SHAPE_BY_AGE[Math.min(age, SHAPE_BY_AGE.length - 1)];
    }

    public void randomTick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        float speed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(25.0f / (speed = CrimsonEmberleafCropBlock.getGrowthSpeed((Block)this, (BlockGetter)level, pos))) + 1) == 0) {
            this.applyAge((Level)level, pos, state, age + 1);
        }
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState below = level.getBlockState(pos.below());
            return below.is((Block)this) && below.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(state, level, pos);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction dir, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (((Boolean)state.getValue((Property)IS_DOUBLE)).booleanValue()) {
            if (!(dir != Direction.UP || half != DoubleBlockHalf.LOWER || neighbor.is((Block)this) && neighbor.getValue(HALF) == DoubleBlockHalf.UPPER)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (!(dir != Direction.DOWN || half != DoubleBlockHalf.UPPER || neighbor.is((Block)this) && neighbor.getValue(HALF) == DoubleBlockHalf.LOWER)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(state, dir, neighbor, level, pos, neighborPos);
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.is(Blocks.FARMLAND);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState other;
        if (!level.isClientSide && ((Boolean)state.getValue((Property)IS_DOUBLE)).booleanValue() && (other = level.getBlockState(otherPos = (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).is((Block)this) && other.getValue(HALF) != half) {
            level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, otherPos, Block.getId((BlockState)other));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, @NotNull BlockPos pos, BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state) {
        return state.getValue(HALF) != DoubleBlockHalf.UPPER && !this.isMaxAge(state);
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        int age = this.getAge(state);
        int newAge = Math.min(age + this.getBonemealAgeIncrease((Level)level), this.getMaxAge());
        if (newAge != age) {
            this.applyAge((Level)level, pos, state, newAge);
        }
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        RandomSource rnd;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int age = this.getAge(state);
        RandomSource randomSource = rnd = builder.getOptionalParameter(LootContextParams.THIS_ENTITY) != null ? Objects.requireNonNull((Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY)).getRandom() : RandomSource.create();
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER || !((Boolean)state.getValue((Property)IS_DOUBLE)).booleanValue()) {
            drops.add(new ItemStack(this.getBaseSeedId()));
            if (age >= this.getMaxAge()) {
                int count = 1 + rnd.nextInt(3);
                if (count > 0) {
                    drops.add(new ItemStack((ItemLike)ModItems.CRIMSON_EMBERLEAF.get(), count));
                }
                if (rnd.nextFloat() < 0.5f) {
                    drops.add(new ItemStack(this.getBaseSeedId(), rnd.nextInt(2) + 1));
                }
            }
        }
        return drops;
    }

    private void applyAge(Level level, BlockPos pos, BlockState state, int newAge) {
        boolean hasUpper;
        if ((newAge = Math.min(newAge, this.getMaxAge())) < 2) {
            level.setBlock(pos, (BlockState)((BlockState)this.getStateForAge(newAge).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        BlockPos upperPos = pos.above();
        BlockState upperState = level.getBlockState(upperPos);
        boolean bl = hasUpper = upperState.is((Block)this) && upperState.getValue(HALF) == DoubleBlockHalf.UPPER;
        if (!hasUpper) {
            if (!level.isEmptyBlock(upperPos) && !upperState.is((Block)this)) {
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    sl.scheduleTick(pos, (Block)this, 2);
                }
                return;
            }
            level.setBlock(upperPos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            level.setBlock(upperPos, (BlockState)((BlockState)upperState.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true)), 3);
        }
        level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true)), 3);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.getChunkSource().getLightEngine().checkBlock(pos);
            sl.getChunkSource().getLightEngine().checkBlock(upperPos);
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean zAdj;
        float speed = 1.0f;
        BlockPos ground = pos.below();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                float bonus = 0.0f;
                BlockState soil = level.getBlockState(ground.offset(x, 0, z));
                if (soil.is(Blocks.FARMLAND)) {
                    bonus = 1.0f;
                    if ((Integer)soil.getValue((Property)FarmBlock.MOISTURE) > 0) {
                        bonus = 3.0f;
                    }
                }
                if (x != 0 || z != 0) {
                    bonus /= 4.0f;
                }
                speed += bonus;
            }
        }
        boolean xAdj = level.getBlockState(pos.west()).is(block) || level.getBlockState(pos.east()).is(block);
        boolean bl = zAdj = level.getBlockState(pos.north()).is(block) || level.getBlockState(pos.south()).is(block);
        if (xAdj && zAdj) {
            speed /= 2.0f;
        } else {
            boolean diag;
            boolean bl2 = diag = level.getBlockState(pos.west().north()).is(block) || level.getBlockState(pos.east().north()).is(block) || level.getBlockState(pos.east().south()).is(block) || level.getBlockState(pos.west().south()).is(block);
            if (diag) {
                speed /= 2.0f;
            }
        }
        return speed;
    }
}

