/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.smokeleaf.item;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;

public class SmokeleafPotionItem
extends PotionItem {
    private final Supplier<ResourceKey<Potion>> potionKey;

    public SmokeleafPotionItem(Supplier<ResourceKey<Potion>> potionKey, Item.Properties properties) {
        super(properties);
        this.potionKey = potionKey;
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        Holder.Reference holder = BuiltInRegistries.POTION.getHolderOrThrow(this.potionKey.get());
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)holder));
        return stack;
    }

    public static ResourceKey<Potion> key(String modId, String path) {
        return ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path));
    }
}

