/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.RenderPipeline;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.managers.AsyncOcclusionTracker;
import me.cortex.nvidium.managers.SectionManager;
import me.cortex.nvidium.util.DownloadTaskStream;
import me.cortex.nvidium.util.UploadingBufferStream;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.render.viewport.frustum.Frustum;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.SpriteSet;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL11;

public class NvidiumWorldRenderer {
    private static final RenderDevice device = new RenderDevice();
    private final UploadingBufferStream uploadStream;
    private final DownloadTaskStream downloadStream;
    private final SectionManager sectionManager;
    private final RenderPipeline renderPipeline;
    private final AsyncOcclusionTracker asyncChunkTracker;
    private long max_geometry_memory;
    private long last_sample_time;

    public NvidiumWorldRenderer(AsyncOcclusionTracker asyncChunkTracker) {
        int frames = SodiumClientMod.options().advanced.cpuRenderAheadLimit + 1;
        this.uploadStream = new UploadingBufferStream(device, 32000000L);
        this.downloadStream = new DownloadTaskStream(device, frames, 8000000L);
        this.update_allowed_memory();
        this.sectionManager = new SectionManager(device, this.max_geometry_memory * 1024L * 1024L, this.uploadStream, 16, this);
        this.renderPipeline = new RenderPipeline(device, this.uploadStream, this.downloadStream, this.sectionManager);
        this.asyncChunkTracker = asyncChunkTracker;
    }

    public void enqueueRegionSort(int regionId) {
        this.renderPipeline.enqueueRegionSort(regionId);
    }

    public void delete() {
        this.uploadStream.delete();
        this.downloadStream.delete();
        this.renderPipeline.delete();
        if (this.asyncChunkTracker != null) {
            this.asyncChunkTracker.delete();
        }
        this.sectionManager.destroy();
    }

    public void reloadShaders() {
        this.renderPipeline.reloadShaders();
    }

    public void renderFrame(ChunkRenderMatrices matrices, double x, double y, double z) {
        Viewport viewport = new Viewport((Frustum)matrices.modelView(), (Vector3d)matrices.projection());
        this.renderPipeline.renderFrame(viewport, matrices, x, y, z);
        while ((long)this.sectionManager.terrainAreana.getUsedMB() > this.max_geometry_memory - 100L) {
            this.renderPipeline.removeARegion();
        }
        if (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER && System.currentTimeMillis() - this.last_sample_time > 60000L) {
            this.last_sample_time = System.currentTimeMillis();
            this.update_allowed_memory();
        }
    }

    public void renderTranslucent() {
        this.renderPipeline.renderTranslucent();
    }

    public void deleteSection(RenderSection section) {
        this.sectionManager.deleteSection(section);
    }

    public void uploadBuildResult(ChunkBuildOutput buildOutput) {
        this.sectionManager.uploadChunkBuildResult(buildOutput);
    }

    public void addDebugInfo(ArrayList<String> debugInfo) {
        debugInfo.add("Using nvidium renderer: " + Nvidium.MOD_VERSION);
        debugInfo.add("Mem" + (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER ? "" : " (fallback)") + ": " + (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER ? this.sectionManager.terrainAreana.getAllocatedMB() : this.sectionManager.terrainAreana.getUsedMB()) + "/" + this.max_geometry_memory + String.format(", F: %.2f", Float.valueOf(this.sectionManager.terrainAreana.getFragmentation() * 100.0f)));
        debugInfo.add("Regions: " + this.sectionManager.getRegionManager().regionCount() + "/" + this.sectionManager.getRegionManager().maxRegions());
        if (this.asyncChunkTracker != null) {
            debugInfo.add("A-BFS: " + this.asyncChunkTracker.getIterationTime() + " Q: " + Arrays.toString(this.asyncChunkTracker.getBuildQueueSizes()));
        }
        this.renderPipeline.addDebugInfo(debugInfo);
    }

    private void update_allowed_memory() {
        if (Nvidium.config.automatic_memory) {
            this.max_geometry_memory = (long)(GL11.glGetInteger((int)36937) / 1024) + (this.sectionManager == null ? 0L : this.sectionManager.terrainAreana.getMemoryUsed() / 0x100000L);
            this.max_geometry_memory -= 1024L;
            this.max_geometry_memory = Math.max(2048L, this.max_geometry_memory);
        } else {
            this.max_geometry_memory = Nvidium.config.max_geometry_memory;
        }
    }

    public void update(Camera camera, Viewport viewport, boolean spectator) {
        if (this.asyncChunkTracker != null) {
            this.asyncChunkTracker.update(viewport, camera, spectator);
        }
    }

    public int getAsyncFrameId() {
        if (this.asyncChunkTracker != null) {
            return this.asyncChunkTracker.getFrame();
        }
        return -1;
    }

    public List<RenderSection> getSectionsWithEntities() {
        if (this.asyncChunkTracker != null) {
            return this.asyncChunkTracker.getLatestSectionsWithEntities();
        }
        return List.of();
    }

    public SectionManager getSectionManager() {
        return this.sectionManager;
    }

    @Nullable
    public SpriteSet[] getAnimatedSpriteSet() {
        if (this.asyncChunkTracker != null) {
            return this.asyncChunkTracker.getVisibleAnimatedSprites();
        }
        return new SpriteSet[0];
    }

    public void setTransformation(int id, Matrix4fc transform) {
        this.renderPipeline.setTransformation(id, transform);
    }

    public void setOrigin(int id, int x, int y, int z) {
        this.renderPipeline.setOrigin(id, x, y, z);
    }

    public int getAsyncBfsVisibilityCount() {
        if (this.asyncChunkTracker != null) {
            return this.asyncChunkTracker.getLastVisibilityCount();
        }
        return -1;
    }

    public int getMaxGeometryMemory() {
        return (int)this.max_geometry_memory;
    }
}

