/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import it.unimi.dsi.fastutil.longs.LongArrays;
import java.nio.ByteBuffer;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryUtil;

public class SodiumResultCompatibility {
    public static RepackagedSectionOutput repackage(ChunkBuildOutput result) {
        int formatSize = 16;
        int geometryBytes = result.meshes.values().stream().mapToInt(a -> a.getVertexData().getLength()).sum();
        NativeBuffer output = new NativeBuffer(geometryBytes);
        short[] offsets = new short[8];
        Vector3i min = new Vector3i(2000);
        Vector3i max = new Vector3i(-2000);
        SodiumResultCompatibility.packageSectionGeometry(formatSize, output, offsets, result, min, max);
        min.x = Math.max(min.x, 0);
        min.y = Math.max(min.y, 0);
        min.z = Math.max(min.z, 0);
        min.x = Math.min(min.x, 15);
        min.y = Math.min(min.y, 15);
        min.z = Math.min(min.z, 15);
        max.x = Math.min(max.x, 16);
        max.y = Math.min(max.y, 16);
        max.z = Math.min(max.z, 16);
        max.x = Math.max(max.x, 0);
        max.y = Math.max(max.y, 0);
        max.z = Math.max(max.z, 0);
        Vector3i size = new Vector3i(max.x - min.x - 1, max.y - min.y - 1, max.z - min.z - 1);
        size.x = Math.min(15, Math.max(size.x, 0));
        size.y = Math.min(15, Math.max(size.y, 0));
        size.z = Math.min(15, Math.max(size.z, 0));
        RepackagedSectionOutput repackagedGeometry = new RepackagedSectionOutput(geometryBytes / formatSize / 4, output, offsets, min, size);
        return repackagedGeometry;
    }

    private static void copyQuad(long from, long too) {
        for (long i = 0L; i < 64L; i += 8L) {
            MemoryUtil.memPutLong((long)(too + i), (long)MemoryUtil.memGetLong((long)(from + i)));
        }
    }

    private static int getVertexCount(BuiltSectionMeshParts mesh) {
        return mesh.getVertexData().getLength() / 16;
    }

    private static long getVertexDataAddress(BuiltSectionMeshParts mesh) {
        return MemoryUtil.memAddress((ByteBuffer)mesh.getVertexData().getDirectBuffer());
    }

    private static void packageSectionGeometry(int formatSize, NativeBuffer output, short[] outOffsets, ChunkBuildOutput result, Vector3i min, Vector3i max) {
        int vertexCount;
        int vertexCount2;
        byte flags;
        long src;
        int vertexCount3;
        int quadCount;
        int offset = 0;
        long outPtr = MemoryUtil.memAddress((ByteBuffer)output.getDirectBuffer());
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float cpx = (float)(cameraPos.x - (double)(result.render.getChunkX() << 4));
        float cpy = (float)(cameraPos.y - (double)(result.render.getChunkY() << 4));
        float cpz = (float)(cameraPos.z - (double)(result.render.getChunkZ() << 4));
        float len = (float)Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz);
        cpx *= 1.0f / len;
        cpy *= 1.0f / len;
        cpz *= 1.0f / len;
        len = Math.min(len, 32.0f);
        cpx *= len;
        cpy *= len;
        cpz *= len;
        BuiltSectionMeshParts translucentData = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT);
        if (translucentData != null && (quadCount = (vertexCount3 = SodiumResultCompatibility.getVertexCount(translucentData)) / 4) > 0) {
            long[] sortingData = new long[quadCount];
            src = SodiumResultCompatibility.getVertexDataAddress(translucentData);
            float cx = 0.0f;
            float cy = 0.0f;
            float cz = 0.0f;
            int quadId = 0;
            for (int j = 0; j < vertexCount3; ++j) {
                long base = src + (long)j * (long)formatSize;
                flags = 4;
                MemoryUtil.memPutByte((long)(base + 6L), (byte)flags);
                float x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)base));
                float y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 2L)));
                float z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 4L)));
                SodiumResultCompatibility.updateSectionBounds(min, max, x, y, z);
                cx += x;
                cy += y;
                cz += z;
                if ((j & 3) != 3) continue;
                float dx = (cx *= 0.25f) - cpx;
                float dy = (cy *= 0.25f) - cpy;
                float dz = (cz *= 0.25f) - cpz;
                float dist = dx * dx + dy * dy + dz * dz;
                int sortDistance = (int)(dist * 4096.0f);
                long packedSortingData = (long)sortDistance << 32 | (long)quadId;
                sortingData[quadId++] = packedSortingData;
                cx = 0.0f;
                cy = 0.0f;
                cz = 0.0f;
            }
            LongArrays.radixSort((long[])sortingData);
            for (int i = 0; i < sortingData.length; ++i) {
                long data = sortingData[i];
                int srcQuadIndex = (int)(data & 0xFFFFFFFFL);
                SodiumResultCompatibility.copyQuad(src + (long)srcQuadIndex * 4L * (long)formatSize, outPtr + (long)(sortingData.length - 1 - i) * 4L * (long)formatSize);
            }
            offset += quadCount;
        }
        outOffsets[7] = (short)offset;
        BuiltSectionMeshParts solid = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.SOLID);
        BuiltSectionMeshParts cutout = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.CUTOUT);
        if (solid != null && (vertexCount2 = SodiumResultCompatibility.getVertexCount(solid)) > 0) {
            src = SodiumResultCompatibility.getVertexDataAddress(solid);
            long dst = outPtr + (long)offset * 4L * (long)formatSize;
            MemoryUtil.memCopy((long)src, (long)dst, (long)((long)vertexCount2 * (long)formatSize));
            for (int j = 0; j < vertexCount2; ++j) {
                long base = dst + (long)j * (long)formatSize;
                byte flags2 = 4;
                MemoryUtil.memPutByte((long)(base + 6L), (byte)flags2);
                SodiumResultCompatibility.updateSectionBounds(min, max, base);
            }
            offset += vertexCount2 / 4;
        }
        if (cutout != null && (vertexCount = SodiumResultCompatibility.getVertexCount(cutout)) > 0) {
            src = SodiumResultCompatibility.getVertexDataAddress(cutout);
            long dst = outPtr + (long)offset * 4L * (long)formatSize;
            MemoryUtil.memCopy((long)src, (long)dst, (long)((long)vertexCount * (long)formatSize));
            for (int j = 0; j < vertexCount; ++j) {
                long base = dst + (long)j * (long)formatSize;
                short sflags = MemoryUtil.memGetByte((long)(base + 6L));
                short mipbits = (short)((sflags & 6) >> 1);
                if (mipbits == 2 && IrisCheck.IRIS_LOADED) {
                    mipbits = 1;
                }
                flags = (byte)((sflags & 1) << 2 | mipbits);
                MemoryUtil.memPutByte((long)(base + 6L), (byte)flags);
                SodiumResultCompatibility.updateSectionBounds(min, max, base);
            }
            offset += vertexCount / 4;
        }
        for (int i = 0; i < 7; ++i) {
            outOffsets[i] = (short)(offset - outOffsets[7]);
        }
        if (offset * 4 * formatSize != output.getLength()) {
            throw new IllegalStateException("Vertex data size mismatch: expected " + output.getLength() + ", got " + offset * 4 * formatSize);
        }
    }

    private static float decodePosition(short v) {
        return (float)Short.toUnsignedInt(v) * 4.8828125E-4f - 8.0f;
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, long vertex) {
        float x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)vertex));
        float y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 2L)));
        float z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 4L)));
        SodiumResultCompatibility.updateSectionBounds(min, max, x, y, z);
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, float x, float y, float z) {
        min.x = (int)Math.min((double)min.x, Math.floor(x));
        min.y = (int)Math.min((double)min.y, Math.floor(y));
        min.z = (int)Math.min((double)min.z, Math.floor(z));
        max.x = (int)Math.max((double)max.x, Math.ceil(x));
        max.y = (int)Math.max((double)max.y, Math.ceil(y));
        max.z = (int)Math.max((double)max.z, Math.ceil(z));
    }
}

