/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.mixin.sodium;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayList;
import java.util.Collection;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererGetter;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererSetter;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.NvidiumCompactChunkVertex;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderSectionManager.class}, remap=false)
public abstract class MixinRenderSectionManager
implements INvidiumWorldRendererGetter {
    @Shadow
    @Final
    private RenderRegionManager regions;
    @Shadow
    @Final
    private Long2ReferenceMap<RenderSection> sectionByPosition;
    @Shadow
    @Final
    private int renderDistance;
    @Shadow
    @Final
    private ClientLevel level;
    @Unique
    private NvidiumWorldRenderer renderer;

    @Unique
    private static void updateNvidiumIsEnabled() {
        Nvidium.IS_ENABLED = !Nvidium.FORCE_DISABLE && Nvidium.IS_COMPATIBLE && IrisCheck.checkIrisShouldDisable();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel world, int renderDistance, CommandList commandList, CallbackInfo ci) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED) {
            if (this.renderer != null) {
                throw new IllegalStateException("Cannot have multiple world renderers");
            }
            this.renderer = new NvidiumWorldRenderer(null);
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(this.renderer);
        }
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/executor/ChunkBuilder;<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/caffeinemc/mods/sodium/client/render/chunk/vertex/format/ChunkVertexType;)V"), index=1)
    private ChunkVertexType modifyVertexType(ChunkVertexType vertexType) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED) {
            return NvidiumCompactChunkVertex.INSTANCE;
        }
        return vertexType;
    }

    @Inject(method={"destroy"}, at={@At(value="TAIL")})
    private void destroy(CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            if (this.renderer == null) {
                throw new IllegalStateException("Pipeline already destroyed");
            }
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(null);
            this.renderer.delete();
            this.renderer = null;
        }
    }

    @Redirect(method={"onSectionRemoved"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;delete()V"))
    private void deleteSection(RenderSection section) {
        if (Nvidium.IS_ENABLED && Nvidium.config.region_keep_distance == 32) {
            this.renderer.deleteSection(section);
        }
        section.delete();
    }

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            ci.cancel();
            pass.startDrawing();
            if (pass == DefaultTerrainRenderPasses.SOLID) {
                if (this.renderer != null) {
                    this.renderer.renderFrame(matrices, x, y, z);
                }
            } else if (pass == DefaultTerrainRenderPasses.TRANSLUCENT && this.renderer != null) {
                this.renderer.renderTranslucent();
            }
            pass.endDrawing();
        }
    }

    @Inject(method={"getDebugStrings"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectDebug(CallbackInfoReturnable<Collection<String>> cir) {
        if (Nvidium.IS_ENABLED) {
            ArrayList<String> debugStrings = new ArrayList<String>();
            if (this.renderer != null) {
                this.renderer.addDebugInfo(debugStrings);
            }
            cir.setReturnValue(debugStrings);
            cir.cancel();
        }
    }

    @Override
    public NvidiumWorldRenderer getRenderer() {
        return this.renderer;
    }

    @Inject(method={"createTerrainRenderList"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectTerrainRenderList(Camera camera, Viewport viewport, int frame, boolean spectator, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isSectionVisibleBfs(RenderSection section) {
        if (this.renderer == null) {
            return false;
        }
        int delta = Math.abs(section.getLastVisibleFrame() - this.renderer.getAsyncFrameId());
        return delta <= 1;
    }

    @Inject(method={"isSectionVisible"}, at={@At(value="RETURN")}, cancellable=true)
    private void redirectIsSectionVisible(int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        RenderSection render;
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs && !cir.getReturnValueZ() && (render = (RenderSection)this.sectionByPosition.get(SectionPos.asLong((int)x, (int)y, (int)z))) != null) {
            cir.setReturnValue((Object)this.isSectionVisibleBfs(render));
        }
    }

    @Inject(method={"getVisibleChunkCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectVisibilityCount(CallbackInfoReturnable<Integer> cir) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs && this.renderer != null) {
            cir.setReturnValue((Object)this.renderer.getAsyncBfsVisibilityCount());
        }
    }
}

