/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.SpawnerDataBuilder;
import fuzs.enderzoology.attachment.SoulboundItems;
import fuzs.enderzoology.config.CommonConfig;
import fuzs.enderzoology.handler.HuntingBowHandler;
import fuzs.enderzoology.handler.MobHuntingHandler;
import fuzs.enderzoology.init.ModBlocks;
import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.enderzoology.init.ModPotions;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.EntityAttributeProviders;
import fuzs.enderzoology.world.entity.SpawnPlacementRules;
import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.entity.monster.DireWolf;
import fuzs.enderzoology.world.level.EnderExplosionHelper;
import fuzs.enderzoology.world.level.EnderExplosionType;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.GameplayContentContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.math.Fraction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderZoology
implements ModConstructor {
    public static final String MOD_ID = "enderzoology";
    public static final String MOD_NAME = "Ender Zoology";
    public static final Logger LOGGER = LogManager.getLogger((String)"Ender Zoology");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"enderzoology").common(CommonConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        EnderZoology.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ExplosionEvents.DETONATE.register(EnderExplosionHelper::onExplosionDetonate);
        UseItemEvents.TICK.register(HuntingBowHandler::onUseItemTick);
        ServerEntityLevelEvents.LOAD.register(MobHuntingHandler::onEntityLoad);
        PlayerCopyEvents.COPY.register(SoulboundItems::onCopy);
        LivingDropsCallback.EVENT.register(SoulboundItems::onLivingDrops);
        RegisterPotionBrewingMixesCallback.EVENT.register(EnderZoology::registerBrewingRecipes);
        UseItemEvents.FINISH.register(DireWolf::onUseItemFinish);
    }

    public void onCommonSetup() {
        EnderZoology.registerDispenseBehaviors();
    }

    private static void registerDispenseBehaviors() {
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ModItems.OWL_EGG_ITEM.value()));
        EnderZoology.registerChargeBehavior((Block)ModBlocks.ENDER_CHARGE_BLOCK.value(), EnderExplosionType.ENDER);
        EnderZoology.registerChargeBehavior((Block)ModBlocks.CONFUSING_CHARGE_BLOCK.value(), EnderExplosionType.CONFUSION);
        EnderZoology.registerChargeBehavior((Block)ModBlocks.CONCUSSION_CHARGE_BLOCK.value(), EnderExplosionType.CONCUSSION);
    }

    private static void registerChargeBehavior(Block block, final EnderExplosionType enderExplosionType) {
        DispenserBlock.registerBehavior((ItemLike)block, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
                ServerLevel level = blockSource.level();
                BlockPos blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                PrimedCharge primedTnt = new PrimedCharge((Level)level, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null, enderExplosionType);
                level.addFreshEntity((Entity)primedTnt);
                level.playSound(null, primedTnt.getX(), primedTnt.getY(), primedTnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                stack.shrink(1);
                return stack;
            }
        });
    }

    private static void registerBrewingRecipes(RegisterPotionBrewingMixesCallback.Builder builder) {
        builder.registerPotionRecipe(Potions.AWKWARD, (Item)ModItems.ENDER_FRAGMENT_ITEM.value(), ModPotions.DISPLACEMENT_POTION);
        builder.registerPotionRecipe(ModPotions.DISPLACEMENT_POTION, Items.GLOWSTONE_DUST, ModPotions.STRONG_DISPLACEMENT_POTION);
        builder.registerPotionRecipe(Potions.AWKWARD, (Item)ModItems.WITHERING_DUST_ITEM.value(), ModPotions.DECAY_POTION);
        builder.registerPotionRecipe(ModPotions.DECAY_POTION, Items.REDSTONE, ModPotions.LONG_DECAY_POTION);
        builder.registerPotionRecipe(ModPotions.DECAY_POTION, Items.GLOWSTONE_DUST, ModPotions.STRONG_DECAY_POTION);
        builder.registerPotionRecipe(Potions.AWKWARD, (Item)ModItems.CONFUSING_POWDER_ITEM.value(), ModPotions.CONFUSION_POTION);
        builder.registerPotionRecipe(ModPotions.CONFUSION_POTION, Items.REDSTONE, ModPotions.LONG_CONFUSION_POTION);
        builder.registerPotionRecipe(ModPotions.CONFUSION_POTION, Items.GLOWSTONE_DUST, ModPotions.STRONG_CONFUSION_POTION);
        builder.registerPotionRecipe(Potions.AWKWARD, (Item)ModItems.OWL_EGG_ITEM.value(), ModPotions.RISING_POTION);
        builder.registerPotionRecipe(ModPotions.RISING_POTION, Items.REDSTONE, ModPotions.LONG_RISING_POTION);
    }

    public void onRegisterGameplayContent(GameplayContentContext context) {
        context.registerFlammable(ModBlocks.ENDER_CHARGE_BLOCK, 15, 100);
        context.registerFlammable(ModBlocks.CONFUSING_CHARGE_BLOCK, 15, 100);
        context.registerFlammable(ModBlocks.CONCUSSION_CHARGE_BLOCK, 15, 100);
    }

    public void onRegisterEntityAttributes(EntityAttributesContext context) {
        context.registerAttributes((EntityType)ModEntityTypes.CONCUSSION_CREEPER_ENTITY_TYPE.value(), EntityAttributeProviders.createConcussionCreeperAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.INFESTED_ZOMBIE_ENTITY_TYPE.value(), EntityAttributeProviders.createEnderInfestedZombieAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.ENDERMINY_ENTITY_TYPE.value(), EntityAttributeProviders.createEnderminyAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.DIRE_WOLF_ENTITY_TYPE.value(), EntityAttributeProviders.createDireWolfAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value(), EntityAttributeProviders.createFallenMountAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.WITHER_CAT_ENTITY_TYPE.value(), EntityAttributeProviders.createWitherCatAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.WITHER_WITCH_ENTITY_TYPE.value(), EntityAttributeProviders.createWitherWitchAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value(), EntityAttributeProviders.createOwlAttributes());
        context.registerAttributes((EntityType)ModEntityTypes.FALLEN_KNIGHT_ENTITY_TYPE.value(), EntityAttributeProviders.createFallenKnightAttributes());
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModEntityTypes.CONCUSSION_CREEPER_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.INFESTED_ZOMBIE_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.ENDERMINY_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.DIRE_WOLF_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkDireWolfSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.WITHER_CAT_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.WITHER_WITCH_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnPlacementRules::checkOwlSpawnRules);
        context.registerSpawnPlacement((EntityType)ModEntityTypes.FALLEN_KNIGHT_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.registerBiomeModification(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.canGenerateIn(LevelStem.OVERWORLD), biomeModificationContext -> {
            MobSpawnSettingsContext settings = biomeModificationContext.mobSpawnSettings();
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).concussionCreeper) {
                SpawnerDataBuilder.create(settings, EntityType.CREEPER).setWeight(Fraction.ONE_QUARTER).apply((EntityType)ModEntityTypes.CONCUSSION_CREEPER_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).infestedZombie) {
                SpawnerDataBuilder.create(settings, EntityType.ZOMBIE).setWeight(Fraction.ONE_QUARTER).setMinCount(1).apply((EntityType)ModEntityTypes.INFESTED_ZOMBIE_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).fallenKnight) {
                SpawnerDataBuilder.create(settings, EntityType.ZOMBIE).setWeight(Fraction.ONE_QUARTER).setMinCount(4).setMaxCount(6).apply((EntityType)ModEntityTypes.FALLEN_KNIGHT_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).enderminy) {
                SpawnerDataBuilder.create(settings, EntityType.ENDERMAN).setWeight(Fraction.getFraction((int)3, (int)1)).setMinCount(Fraction.getFraction((int)4, (int)1)).apply((EntityType)ModEntityTypes.ENDERMINY_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).direWolf && biomeModificationContext.climateSettings().hasPrecipitation() && biomeModificationContext.climateSettings().getTemperature() < 0.0f) {
                SpawnerDataBuilder.create(settings, EntityType.WOLF).setWeight(Fraction.ONE_QUARTER).setMinCount(3).setMaxCount(8).apply((EntityType)ModEntityTypes.DIRE_WOLF_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).witherWitch) {
                SpawnerDataBuilder.create(settings, EntityType.WITCH).apply((EntityType)ModEntityTypes.WITHER_WITCH_ENTITY_TYPE.value());
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).owl && biomeModificationContext.climateSettings().hasPrecipitation()) {
                SpawnerDataBuilder.create(settings, EntityType.RABBIT).apply((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value());
            }
        });
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

