/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.model;

import fuzs.enderzoology.client.renderer.entity.state.OwlRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class OwlModel
extends EntityModel<OwlRenderState>
implements HeadedModel {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 24.0f, 0.0f, 3.0f, 2.0f, 24.0f, Set.of("head"));
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public OwlModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.head = this.body.getChild("head");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createEyesLayer() {
        return OwlModel.createBodyLayer().apply(meshDefinition -> {
            meshDefinition.getRoot().retainExactParts(Set.of("head"));
            return meshDefinition;
        });
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(1, 10).addBox(-3.0f, -3.0f, -2.5f, 6.0f, 6.0f, 5.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.0f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        head.addOrReplaceChild("right_eyebrow", CubeListBuilder.create().texOffs(23, 15).addBox(-4.0f, -14.0f, -2.6f, 3.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        head.addOrReplaceChild("left_eyebrow", CubeListBuilder.create().texOffs(23, 17).addBox(1.0f, -14.0f, -2.6f, 3.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, -11.0f, -3.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(18, 28).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 3.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)2.5f));
        PartDefinition rightLeg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(14, 22).addBox(-5.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)2.0f, (float)3.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_toes", CubeListBuilder.create().texOffs(11, 28).addBox(-3.5f, 0.0f, -3.0f, 3.0f, 0.0f, 2.0f), PartPose.offset((float)-2.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(23, 22).addBox(3.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)-2.0f, (float)3.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_toes", CubeListBuilder.create().texOffs(11, 28).addBox(0.5f, 0.0f, -3.0f, 3.0f, 0.0f, 2.0f), PartPose.offset((float)2.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(2, 21).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)-3.0f, (float)-3.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 4).addBox(0.0f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)3.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(OwlRenderState renderState) {
        super.setupAnim((Object)renderState);
        this.head.xRot = renderState.xRot * ((float)Math.PI / 180);
        this.head.yRot = renderState.yRot * ((float)Math.PI / 180);
        this.rightWing.zRot += renderState.flapAngle * 0.7f;
        this.leftWing.zRot -= renderState.flapAngle * 0.7f;
        if (renderState.isFlying) {
            float xRotFlying = 0.5235988f;
            this.body.xRot += xRotFlying;
            this.head.xRot -= xRotFlying;
            this.leftLeg.xRot -= xRotFlying / 2.0f;
            this.rightLeg.xRot -= xRotFlying / 2.0f;
            this.tail.xRot -= xRotFlying / 2.0f;
        }
    }

    public ModelPart getHead() {
        return this.head;
    }
}

