/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.packs;

import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class DynamicallyCopiedPackResources
extends AbstractModPackResources {
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;
    private final Map<ResourceLocation, TextureCopy> textures;

    protected DynamicallyCopiedPackResources(TextureCopy ... textures) {
        Minecraft minecraft = Minecraft.getInstance();
        this.resourceManager = minecraft.getResourceManager();
        this.vanillaPackResources = minecraft.getVanillaPackResources();
        this.textures = Stream.of(textures).collect(Collectors.toMap(TextureCopy::destinationLocation, Function.identity()));
    }

    public static Supplier<AbstractModPackResources> create(TextureCopy ... textures) {
        return () -> new DynamicallyCopiedPackResources(textures);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation resourceLocation) {
        if (!this.textures.containsKey(resourceLocation)) return null;
        TextureCopy textureCopy = this.textures.get(resourceLocation);
        Optional vanillaResource = this.resourceManager.getResource(textureCopy.vanillaLocation());
        if (!vanillaResource.isPresent()) return null;
        try (NativeImage nativeImage = NativeImage.read((InputStream)((Resource)vanillaResource.get()).open());){
            if (nativeImage.getWidth() / nativeImage.getHeight() == textureCopy.vanillaImageWidth() / textureCopy.vanillaImageHeight()) return () -> ((Resource)((Resource)vanillaResource.get())).open();
            IoSupplier ioSupplier = this.vanillaPackResources.getResource(packType, textureCopy.vanillaLocation());
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)vanillaResource.get())).open();
    }

    public Set<String> getNamespaces(PackType packType) {
        return this.textures.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
    }

    public record TextureCopy(ResourceLocation vanillaLocation, ResourceLocation destinationLocation, int vanillaImageWidth, int vanillaImageHeight) {
        public TextureCopy {
            if (vanillaLocation.getNamespace().equals(destinationLocation.getNamespace())) {
                throw new IllegalStateException("%s and %s share same namespace".formatted(vanillaLocation, destinationLocation));
            }
            if (!vanillaLocation.getPath().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(vanillaLocation));
            }
            if (!destinationLocation.getPath().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(destinationLocation));
            }
        }
    }
}

