/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.renderer.entity;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.client.init.ModModelLayers;
import fuzs.enderzoology.client.renderer.entity.state.FallenMountRenderState;
import fuzs.enderzoology.world.entity.monster.FallenMount;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.client.renderer.entity.state.HorseRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class FallenMountRenderer
extends AbstractHorseRenderer<FallenMount, HorseRenderState, HorseModel> {
    public static final ResourceLocation VANILLA_TEXTURE_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/horse/horse_zombie.png");
    public static final ResourceLocation TEXTURE_LOCATION = EnderZoology.id("textures/entity/horse/horse_zombie.png");

    public FallenMountRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HorseModel(context.bakeLayer(ModModelLayers.FALLEN_MOUNT)), (EntityModel)new HorseModel(context.bakeLayer(ModModelLayers.FALLEN_MOUNT_BABY)));
        this.addLayer((RenderLayer)new SimpleEquipmentLayer((RenderLayerParent)this, context.getEquipmentRenderer(), EquipmentClientInfo.LayerType.HORSE_BODY, horseRenderState -> horseRenderState.bodyArmorItem, (EntityModel)new HorseModel(context.bakeLayer(ModModelLayers.FALLEN_MOUNT_ARMOR)), (EntityModel)new HorseModel(context.bakeLayer(ModModelLayers.FALLEN_MOUNT_BABY_ARMOR))));
    }

    public HorseRenderState createRenderState() {
        return new FallenMountRenderState();
    }

    public void extractRenderState(FallenMount entity, HorseRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractHorse)entity, (EquineRenderState)reusedState, partialTick);
        reusedState.bodyArmorItem = entity.getBodyArmorItem().copy();
        ((FallenMountRenderState)reusedState).isShaking = entity.isConverting();
    }

    public ResourceLocation getTextureLocation(HorseRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    protected boolean isShaking(HorseRenderState renderState) {
        return super.isShaking((LivingEntityRenderState)renderState) || ((FallenMountRenderState)renderState).isShaking;
    }
}

