/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.renderer.entity;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.client.init.ModModelLayers;
import fuzs.enderzoology.client.model.OwlModel;
import fuzs.enderzoology.client.renderer.entity.state.OwlRenderState;
import fuzs.enderzoology.world.entity.animal.Owl;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.LivingEntityEmissiveLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class OwlRenderer
extends AgeableMobRenderer<Owl, OwlRenderState, OwlModel> {
    private static final ResourceLocation TEXTURE_LOCATION = EnderZoology.id("textures/entity/owl/owl.png");
    private static final ResourceLocation EYES_TEXTURE_LOCATION = EnderZoology.id("textures/entity/owl/owl_eyes.png");

    public OwlRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new OwlModel(context.bakeLayer(ModModelLayers.OWL)), (EntityModel)new OwlModel(context.bakeLayer(ModModelLayers.OWL_BABY)), 0.3f);
        this.addLayer((RenderLayer)new LivingEntityEmissiveLayer((RenderLayerParent)this, renderState -> EYES_TEXTURE_LOCATION, (renderState, ageInTicks) -> renderState.isBaby ? 0.0f : 1.0f, (EntityModel)new OwlModel(context.bakeLayer(ModModelLayers.OWL_EYES)), RenderType::eyes, true));
        this.addLayer((RenderLayer)new LivingEntityEmissiveLayer((RenderLayerParent)this, renderState -> EYES_TEXTURE_LOCATION, (renderState, ageInTicks) -> renderState.isBaby ? 1.0f : 0.0f, (EntityModel)new OwlModel(context.bakeLayer(ModModelLayers.OWL_BABY_EYES)), RenderType::eyes, true));
    }

    public OwlRenderState createRenderState() {
        return new OwlRenderState();
    }

    public ResourceLocation getTextureLocation(OwlRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    public void extractRenderState(Owl owl, OwlRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)owl, (LivingEntityRenderState)renderState, partialTick);
        renderState.isFlying = owl.isFlying();
        float flap = Mth.lerp((float)partialTick, (float)owl.oFlap, (float)owl.flap);
        float flapSpeed = Mth.lerp((float)partialTick, (float)owl.oFlapSpeed, (float)owl.flapSpeed);
        renderState.flapAngle = (Mth.sin((float)flap) + 1.0f) * flapSpeed;
    }
}

