/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModSoundEvents;
import fuzs.enderzoology.world.entity.ai.goal.FollowPackLeaderGoal;
import fuzs.enderzoology.world.entity.monster.PackMob;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class DireWolf
extends Wolf
implements Enemy,
PackMob {
    private static final UniformInt EATING_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && !(itemEntity.getItem().getItem() instanceof BlockItem);
    @Nullable
    private DireWolf wolfPackLeader;
    private int wolfPackSize = 1;
    private int ticksSinceEaten;

    public DireWolf(EntityType<? extends Wolf> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 10;
        this.setCanPickUpLoot(true);
        this.ticksSinceEaten = EATING_TIME.sample(this.random);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new SearchForItemsGoal((Mob)this));
        this.goalSelector.addGoal(5, new FollowPackLeaderGoal<DireWolf>(this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, 8, true, false, (livingEntity, serverLevel) -> livingEntity.getType() == EntityType.WOLF));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 12, true, false, (livingEntity, serverLevel) -> (livingEntity instanceof Animal || livingEntity instanceof Zombie) && !(livingEntity instanceof Wolf) && this.isHungry() && !this.getMainHandItem().has(DataComponents.FOOD)));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public int getBaseExperienceReward(ServerLevel serverLevel) {
        return this.xpReward;
    }

    public int getMaxSpawnClusterSize() {
        return this.getMaxSchoolSize();
    }

    @Override
    public int getMaxSchoolSize() {
        return super.getMaxSpawnClusterSize();
    }

    @Override
    public boolean isFollower() {
        return this.wolfPackLeader != null && this.wolfPackLeader.isAlive();
    }

    @Override
    public void startFollowing(PackMob leader) {
        if (leader == this) {
            throw new IllegalStateException("Wolf cannot follow itself");
        }
        this.wolfPackLeader = (DireWolf)leader;
        leader.addFollower();
    }

    @Override
    public void addFollower() {
        ++this.wolfPackSize;
    }

    @Override
    public void removeFollower() {
        --this.wolfPackSize;
    }

    @Override
    public void stopFollowing() {
        this.wolfPackLeader.removeFollower();
        this.wolfPackLeader = null;
    }

    @Override
    public boolean canBeFollowed() {
        return this.hasFollowers() && this.wolfPackSize < this.getMaxSchoolSize();
    }

    public void tick() {
        List list;
        super.tick();
        if (this.hasFollowers() && this.level().random.nextInt(200) == 1 && (list = this.level().getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(8.0, 8.0, 8.0))).size() <= 1) {
            this.wolfPackSize = 1;
        }
    }

    @Override
    public boolean hasFollowers() {
        return this.wolfPackSize > 1;
    }

    @Override
    public boolean inRangeOfLeader() {
        return this.distanceToSqr((Entity)this.wolfPackLeader) <= 121.0;
    }

    @Override
    public boolean tooCloseToLeader() {
        return this.distanceToSqr((Entity)this.wolfPackLeader) < 9.0;
    }

    @Override
    public void pathToLeader() {
        if (this.isFollower()) {
            this.getNavigation().moveTo((Entity)this.wolfPackLeader, 1.0);
        }
    }

    @Override
    public void addFollowers(Stream<? extends PackMob> followers) {
        followers.limit(this.getMaxSchoolSize() - this.wolfPackSize).filter(packMob -> packMob != this).forEach(packMob -> packMob.startFollowing(this));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new PackSpawnGroupData(this);
        } else if (spawnGroupData instanceof PackSpawnGroupData) {
            PackSpawnGroupData packSpawnData = (PackSpawnGroupData)((Object)spawnGroupData);
            this.startFollowing(packSpawnData.leader);
        }
        return super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
    }

    public void aiStep() {
        if (this.level() instanceof ServerLevel && this.isAlive() && this.isEffectiveAi()) {
            ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.canEat(itemStack) && --this.ticksSinceEaten < 40 && this.random.nextFloat() < 0.1f && !this.isUsingItem()) {
                this.startUsingItem(InteractionHand.MAIN_HAND);
            } else if (this.ticksSinceEaten < 0) {
                this.ticksSinceEaten = EATING_TIME.sample(this.random);
            }
        }
        super.aiStep();
    }

    public static void onUseItemFinish(LivingEntity livingEntity, MutableValue<ItemStack> itemStack, ItemStack originalItemStack) {
        FoodProperties foodProperties;
        if (livingEntity instanceof DireWolf && (foodProperties = (FoodProperties)originalItemStack.get(DataComponents.FOOD)) != null) {
            float meatMultiplier = originalItemStack.is(ItemTags.MEAT) ? 2.0f : 1.0f;
            livingEntity.heal((float)foodProperties.nutrition() * meatMultiplier);
            livingEntity.level().broadcastEntityEvent((Entity)livingEntity, (byte)18);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private boolean isHungry() {
        return this.getHealth() < this.getMaxHealth();
    }

    private boolean canEat(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND && this.canPickUpLoot();
    }

    public boolean canHoldItem(ItemStack stack) {
        ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemStack.isEmpty() || this.ticksSinceEaten > 0 && stack.has(DataComponents.FOOD) && !itemStack.has(DataComponents.FOOD);
    }

    private void spitOutItem(ServerLevel serverLevel, ItemStack itemStack) {
        if (!itemStack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, itemStack);
            itemEntity.setPickUpDelay(40);
            itemEntity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            serverLevel.addFreshEntity((Entity)itemEntity);
        }
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)itemEntity);
    }

    protected void pickUpItem(ServerLevel serverLevel, ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        if (this.canHoldItem(itemStack)) {
            int i = itemStack.getCount();
            if (i > 1) {
                this.dropItemStack(itemStack.split(i - 1));
            }
            this.spitOutItem(serverLevel, this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(itemEntity);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemStack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)itemEntity, itemStack.getCount());
            itemEntity.discard();
            this.ticksSinceEaten = EATING_TIME.sample(this.random);
        }
    }

    protected void dropAllDeathLoot(ServerLevel serverLevel, DamageSource damageSource) {
        ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemStack.isEmpty()) {
            this.spawnAtLocation(serverLevel, itemStack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        super.dropAllDeathLoot(serverLevel, damageSource);
    }

    protected SoundEvent getAmbientSound() {
        return this.random.nextFloat() < 0.1f ? (SoundEvent)ModSoundEvents.DIRE_WOLF_HOWL_SOUND_EVENT.value() : (SoundEvent)ModSoundEvents.DIRE_WOLF_GROWL_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.DIRE_WOLF_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.DIRE_WOLF_DEATH_SOUND_EVENT.value();
    }

    public boolean isTame() {
        return false;
    }

    public void setTame(boolean tame, boolean applyTamingSideEffects) {
    }

    public boolean isAngry() {
        return true;
    }

    public boolean isInterested() {
        return false;
    }

    public boolean isInSittingPose() {
        return false;
    }

    public int getAge() {
        return 0;
    }

    public void setAge(int age) {
    }

    public void setIsInterested(boolean isInterested) {
    }

    public Wolf getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    static class SearchForItemsGoal
    extends Goal {
        private final Mob mob;
        @Nullable
        private Path path;
        @Nullable
        private ItemEntity itemEntity;

        public SearchForItemsGoal(Mob mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.mob.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (this.mob.getTarget() == null && this.mob.getLastHurtByMob() == null) {
                if (this.mob.getRandom().nextInt(SearchForItemsGoal.reducedTickDelay((int)10)) != 0) {
                    return false;
                }
                for (ItemEntity itemEntity : this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(8.0), ALLOWED_ITEMS)) {
                    Path path = this.mob.getNavigation().createPath((Entity)itemEntity, 1);
                    if (path == null || !path.canReach()) continue;
                    this.path = path;
                    this.itemEntity = itemEntity;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            if (this.itemEntity == null || this.path == null) {
                return false;
            }
            if (this.itemEntity.isRemoved()) {
                return false;
            }
            return this.path.isDone() || this.itemEntity.closerThan((Entity)this.mob, 1.414);
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.path, (double)1.2f);
        }

        public void stop() {
            this.path = null;
            this.itemEntity = null;
        }
    }

    public static class PackSpawnGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final PackMob leader;

        public PackSpawnGroupData(PackMob leader) {
            super(false);
            this.leader = leader;
        }
    }
}

