/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.services.CommonAbstractions;
import fuzs.puzzleslib.api.util.v1.ValueSerializationHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class FallenMount
extends AbstractHorse
implements Enemy {
    static final String TAG_HORSE_DATA = "HorseData";
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(FallenMount.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private CompoundTag horseData;
    private int conversionTime;
    @Nullable
    private UUID conversionStarter;

    public FallenMount(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MountRestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new MountFleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2f, false){

            public boolean canUse() {
                return !this.mob.isVehicle() && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractHorse.class, false, (livingEntity, serverLevel) -> livingEntity.getType().is(ModRegistry.FALLEN_MOUNT_TARGETS_ENTITY_TYPE_TAG)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected int getBaseExperienceReward(ServerLevel serverLevel) {
        return this.xpReward;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    protected void randomizeAttributes(RandomSource randomSource) {
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(FallenMount.generateJumpStrength(() -> ((RandomSource)randomSource).nextDouble()));
    }

    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive() && this.isConverting()) {
                --this.conversionTime;
                if (this.conversionTime <= 0) {
                    this.finishConversion(serverLevel);
                }
            }
        }
        super.tick();
    }

    public boolean canEatGrass() {
        return false;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.yBodyRot = this.yBodyRot;
            living.yHeadRot = this.yHeadRot;
            living.setYRot(this.getYRot());
            living.setXRot(this.getXRot());
        }
    }

    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    public boolean isImmobile() {
        return this.isDeadOrDying();
    }

    public boolean isTamed() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                if (this.level() instanceof ServerLevel) {
                    this.startConverting(player.getUUID(), this.random.nextInt(2400) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void aiStep() {
        if (this.isAlive() && this.isSunBurnTick() && !this.isVehicle() && !this.isWearingBodyArmor()) {
            this.igniteForSeconds(8.0f);
        }
        super.aiStep();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        ItemStack itemStack = new ItemStack((ItemLike)this.pickDefaultHorseArmor(random));
        this.setItemSlot(EquipmentSlot.BODY, itemStack);
        this.setDropChance(EquipmentSlot.BODY, 0.0f);
    }

    private Item pickDefaultHorseArmor(RandomSource random) {
        float randomValue = random.nextFloat();
        if (randomValue < 0.015f) {
            return Items.DIAMOND_HORSE_ARMOR;
        }
        if (randomValue < 0.05f) {
            return Items.GOLDEN_HORSE_ARMOR;
        }
        if (randomValue < 0.2f) {
            return Items.LEATHER_HORSE_ARMOR;
        }
        return Items.IRON_HORSE_ARMOR;
    }

    public boolean isSaddled() {
        return true;
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return slot != EquipmentSlot.SADDLE;
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot slot) {
        return slot != EquipmentSlot.SADDLE && super.canDispenserEquipIntoSlot(slot);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.storeNullable(TAG_HORSE_DATA, CompoundTag.CODEC, (Object)this.horseData);
        valueOutput.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        valueOutput.storeNullable("ConversionPlayer", UUIDUtil.CODEC, (Object)this.conversionStarter);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.horseData = valueInput.read(TAG_HORSE_DATA, CompoundTag.CODEC).orElse(null);
        int conversionTime = valueInput.getIntOr("ConversionTime", -1);
        if (conversionTime != -1) {
            UUID uUID = valueInput.read("ConversionPlayer", UUIDUtil.CODEC).orElse(null);
            this.startConverting(uUID, conversionTime);
        } else {
            this.getEntityData().set(DATA_CONVERTING_ID, (Object)false);
            this.conversionTime = -1;
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isConverting() && (this.horseData == null || !this.horseData.getBooleanOr("Tame", false));
    }

    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID conversionStarter, int conversionTime) {
        this.conversionStarter = conversionStarter;
        this.conversionTime = conversionTime;
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffectInstance(MobEffects.STRENGTH, conversionTime, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent((Entity)this, (byte)16);
    }

    public void handleEntityEvent(byte id) {
        if (id == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void finishConversion(ServerLevel serverLevel) {
        this.createHorseFromData(serverLevel, this).or(() -> this.createFreshHorse(serverLevel)).ifPresent(abstractHorse -> {
            abstractHorse.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0));
            if (!this.isSilent()) {
                serverLevel.levelEvent(null, 1027, this.blockPosition(), 0);
            }
        });
    }

    private Optional<AbstractHorse> createHorseFromData(ServerLevel serverLevel, FallenMount fallenMount) {
        MutableObject mutableObject = new MutableObject(Optional.empty());
        if (fallenMount.horseData != null && !fallenMount.horseData.isEmpty()) {
            ValueSerializationHelper.load((ProblemReporter.PathElement)this.problemPath(), (HolderLookup.Provider)this.registryAccess(), (CompoundTag)fallenMount.horseData, valueInput -> {
                Optional<AbstractHorse> optional = EntityType.create((ValueInput)valueInput, (Level)serverLevel, (EntitySpawnReason)EntitySpawnReason.CONVERSION).map(entity -> {
                    AbstractHorse abstractHorse = (AbstractHorse)entity;
                    abstractHorse.copyPosition((Entity)fallenMount);
                    fallenMount.discard();
                    serverLevel.addFreshEntity((Entity)abstractHorse);
                    return abstractHorse;
                });
                mutableObject.setValue(optional);
            });
        }
        return (Optional)mutableObject.getValue();
    }

    private Optional<AbstractHorse> createFreshHorse(ServerLevel serverLevel) {
        ConversionParams conversionParams = ConversionParams.single((Mob)this, (boolean)false, (boolean)false);
        return Optional.ofNullable((AbstractHorse)this.convertTo(this.getRandomHorseType(), conversionParams, mob -> {
            Player player;
            for (EquipmentSlot equipmentSlot : this.dropPreservedEquipment(serverLevel, itemStack -> !EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE))) {
                ItemStack itemStack2 = this.getItemBySlot(equipmentSlot);
                mob.setItemSlot(equipmentSlot, itemStack2);
            }
            mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(mob.blockPosition()), EntitySpawnReason.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f));
            mob.setTamed(true);
            if (this.conversionStarter != null && (player = serverLevel.getPlayerByUUID(this.conversionStarter)) != null) {
                mob.setOwner((LivingEntity)player);
            }
            mob.setBaby(false);
            CommonAbstractions.INSTANCE.onLivingConvert((Mob)this, mob, conversionParams);
        }));
    }

    private EntityType<AbstractHorse> getRandomHorseType() {
        EntityType entityType = this.random.nextInt(6) == 0 ? EntityType.DONKEY : EntityType.HORSE;
        return entityType;
    }

    public boolean killedEntity(ServerLevel serverLevel, LivingEntity entity, DamageSource damageSource) {
        boolean killedEntity = super.killedEntity(serverLevel, entity, damageSource);
        if ((serverLevel.getDifficulty() == Difficulty.NORMAL || serverLevel.getDifficulty() == Difficulty.HARD) && entity instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)entity;
            if (CommonAbstractions.INSTANCE.canLivingConvert(entity, (EntityType<? extends LivingEntity>)((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value()))) {
                if (serverLevel.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return killedEntity;
                }
                ConversionParams conversionParams = ConversionParams.single((Mob)abstractHorse, (boolean)true, (boolean)true);
                FallenMount fallenMount = (FallenMount)abstractHorse.convertTo((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value(), conversionParams, mob -> {
                    abstractHorse.setHealth(abstractHorse.getMaxHealth());
                    abstractHorse.setDeltaMovement(Vec3.ZERO);
                    mob.horseData = ValueSerializationHelper.save((ProblemReporter.PathElement)mob.problemPath(), (HolderLookup.Provider)mob.registryAccess(), valueOutput -> {
                        valueOutput.putString("id", abstractHorse.getEncodeId());
                        abstractHorse.saveWithoutId(valueOutput);
                    });
                    CommonAbstractions.INSTANCE.onLivingConvert((Mob)abstractHorse, mob, conversionParams);
                    if (!this.isSilent()) {
                        serverLevel.levelEvent(null, 1026, this.blockPosition(), 0);
                    }
                });
                return fallenMount == null;
            }
        }
        return killedEntity;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData spawnGroupData = super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnData);
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        return spawnGroupData;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getWaterSlowDown() {
        return 0.96f;
    }

    static class MountRestrictSunGoal
    extends RestrictSunGoal {
        private final PathfinderMob mob;

        public MountRestrictSunGoal(PathfinderMob pathfinderMob) {
            super(pathfinderMob);
            this.mob = pathfinderMob;
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }

    static class MountFleeSunGoal
    extends FleeSunGoal {
        public MountFleeSunGoal(PathfinderMob pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }
}

