/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModPotions;
import fuzs.enderzoology.world.entity.monster.CompanionMob;
import fuzs.enderzoology.world.entity.monster.WitherCat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitherWitch
extends Witch
implements CompanionMob<WitherCat> {
    private NearestHealableRaiderTargetGoal<WitherCat> healCatsGoal;
    private int ticksUntilNextAlert;

    public WitherWitch(EntityType<? extends WitherWitch> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.healCatsGoal = new NearestHealableRaiderTargetGoal<WitherCat>(this, (Raider)this, WitherCat.class, true, (livingEntity, serverLevel) -> livingEntity.getHealth() < livingEntity.getMaxHealth()){

            public boolean canUse() {
                if (this.getCooldown() <= 0 && this.mob.getRandom().nextBoolean()) {
                    this.findTarget();
                    if (this.target != null) {
                        if (this.target.level().getNearestPlayer(this.target.getX(), this.target.getY(), this.target.getZ(), 12.0, true) != null) {
                            this.target = null;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        this.targetSelector.addGoal(2, this.healCatsGoal);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level() instanceof ServerLevel && this.isAlive()) {
            this.healCatsGoal.decrementCooldown();
            this.attackPlayersGoal.setCanAttack(this.healRaidersGoal.getCooldown() <= 0 || this.healCatsGoal.getCooldown() <= 0);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnData) {
        if (level instanceof ServerLevel && entitySpawnReason == EntitySpawnReason.NATURAL) {
            this.trySpawnCompanion((ServerLevel)level, this.blockPosition(), 4);
            if (this.random.nextInt(4) == 0) {
                this.trySpawnCompanion((ServerLevel)level, this.blockPosition(), 4);
            }
        }
        return super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnData);
    }

    private void trySpawnCompanion(ServerLevel serverLevel, BlockPos blockPos, int maxDistance) {
        BlockPos spawnPosition = this.findSpawnPositionNear(serverLevel, blockPos, maxDistance);
        if (spawnPosition != null) {
            ((EntityType)ModEntityTypes.WITHER_CAT_ENTITY_TYPE.value()).spawn(serverLevel, spawnPosition, EntitySpawnReason.EVENT);
        }
    }

    @Override
    public Mob getCompanionMob() {
        return this;
    }

    @Override
    public int getTicksUntilNextAlert() {
        return this.ticksUntilNextAlert;
    }

    @Override
    public void setTicksUntilNextAlert(int ticksUntilNextAlert) {
        this.ticksUntilNextAlert = ticksUntilNextAlert;
    }

    @Override
    public Class<WitherCat> getCompanionType() {
        return WitherCat.class;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(ServerLevel level, BlockPos pos, int maxDistance) {
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int j = pos.getX() + this.random.nextInt(maxDistance * 2) - maxDistance;
            int k = pos.getZ() + this.random.nextInt(maxDistance * 2) - maxDistance;
            int l = level.getHeight(Heightmap.Types.WORLD_SURFACE, j, k);
            BlockPos blockPos2 = new BlockPos(j, l, k);
            if (!SpawnPlacements.isSpawnPositionOk((EntityType)((EntityType)ModEntityTypes.WITHER_WITCH_ENTITY_TYPE.value()), (LevelReader)level, (BlockPos)blockPos2)) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (!this.isDrinkingPotion()) {
            Holder holder;
            Vec3 vec3 = target.getDeltaMovement();
            double d = target.getX() + vec3.x - this.getX();
            double e = target.getEyeY() - 1.1 - this.getY();
            double f = target.getZ() + vec3.z - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            Object object = holder = target.isInvertedHealAndHarm() ? Potions.HEALING : Potions.HARMING;
            if (target instanceof Raider || target instanceof WitherCat) {
                holder = this.random.nextInt(4) != 0 || target.getHealth() <= 4.0f ? Potions.HEALING : Potions.REGENERATION;
                this.setTarget(null);
            } else if (target.getHealth() >= 8.0f && !target.hasEffect(MobEffects.WITHER)) {
                holder = ModPotions.DECAY_POTION;
            } else if (g <= 3.0 && !target.hasEffect(MobEffects.LEVITATION) && this.random.nextFloat() < 0.05f) {
                holder = ModPotions.RISING_POTION;
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack itemStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, holder);
                Projectile.spawnProjectileUsingShoot(ThrownSplashPotion::new, (ServerLevel)serverLevel, (ItemStack)itemStack, (LivingEntity)this, (double)d, (double)(e + g * 0.2), (double)f, (float)0.75f, (float)8.0f);
            }
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            }
        }
    }

    public boolean isInvulnerableTo(ServerLevel serverLevel, DamageSource damageSource) {
        return super.isInvulnerableTo(serverLevel, damageSource) || damageSource.getEntity() instanceof Witch;
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!((MobEffect)effectInstance.getEffect().value()).isBeneficial() && entity instanceof Witch) {
            return false;
        }
        return super.addEffect(effectInstance, entity);
    }

    public boolean canBeAffected(@NotNull MobEffectInstance potion) {
        return potion.getEffect() != MobEffects.WITHER && super.canBeAffected(potion);
    }
}

